% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_update_rest_api}
\alias{apigateway_update_rest_api}
\title{Changes information about the specified API}
\usage{
apigateway_update_rest_api(restApiId, patchOperations)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{patchOperations}{A list of update operations to be applied to the specified resource and
in the order specified in this list.}
}
\value{
A list with the following syntax:\preformatted{list(
  id = "string",
  name = "string",
  description = "string",
  createdDate = as.POSIXct(
    "2015-01-01"
  ),
  version = "string",
  warnings = list(
    "string"
  ),
  binaryMediaTypes = list(
    "string"
  ),
  minimumCompressionSize = 123,
  apiKeySource = "HEADER"|"AUTHORIZER",
  endpointConfiguration = list(
    types = list(
      "REGIONAL"|"EDGE"|"PRIVATE"
    ),
    vpcEndpointIds = list(
      "string"
    )
  ),
  policy = "string",
  tags = list(
    "string"
  ),
  disableExecuteApiEndpoint = TRUE|FALSE
)
}
}
\description{
Changes information about the specified API.
}
\section{Request syntax}{
\preformatted{svc$update_rest_api(
  restApiId = "string",
  patchOperations = list(
    list(
      op = "add"|"remove"|"replace"|"move"|"copy"|"test",
      path = "string",
      value = "string",
      from = "string"
    )
  )
)
}
}

\keyword{internal}
