% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_query_logging_configs}
\alias{route53_list_query_logging_configs}
\title{Lists the configurations for DNS query logging that are associated with
the current AWS account or the configuration that is associated with a
specified hosted zone}
\usage{
route53_list_query_logging_configs(HostedZoneId, NextToken, MaxResults)
}
\arguments{
\item{HostedZoneId}{(Optional) If you want to list the query logging configuration that is
associated with a hosted zone, specify the ID in \code{HostedZoneId}.

If you don't specify a hosted zone ID, \code{ListQueryLoggingConfigs} returns
all of the configurations that are associated with the current AWS
account.}

\item{NextToken}{(Optional) If the current AWS account has more than \code{MaxResults} query
logging configurations, use \code{NextToken} to get the second and subsequent
pages of results.

For the first \code{ListQueryLoggingConfigs} request, omit this value.

For the second and subsequent requests, get the value of \code{NextToken}
from the previous response and specify that value for \code{NextToken} in the
request.}

\item{MaxResults}{(Optional) The maximum number of query logging configurations that you
want Amazon Route 53 to return in response to the current request. If
the current AWS account has more than \code{MaxResults} configurations, use
the value of
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax}{NextToken}
in the response to get the next page of results.

If you don't specify a value for \code{MaxResults}, Route 53 returns up to
100 configurations.}
}
\description{
Lists the configurations for DNS query logging that are associated with
the current AWS account or the configuration that is associated with a
specified hosted zone.

For more information about DNS query logs, see
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html}{CreateQueryLoggingConfig}.
Additional information, including the format of DNS query logs, appears
in \href{https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html}{Logging DNS Queries}
in the \emph{Amazon Route 53 Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_query_logging_configs(
  HostedZoneId = "string",
  NextToken = "string",
  MaxResults = "string"
)
}
}

\keyword{internal}
