# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include resiliencehub_service.R
NULL

#' Adds the source of resource-maps to the draft version of an application
#'
#' @description
#' Adds the source of resource-maps to the draft version of an application. During assessment, Resilience Hub will use these resource-maps to resolve the latest physical ID for each resource in the application template. For more information about different types of resources suported by Resilience Hub and how to add them in your application, see [Step 2: How is your application managed?](https://docs.aws.amazon.com/resilience-hub/latest/userguide/how-app-manage.html) in the Resilience Hub User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_add_draft_app_version_resource_mappings/](https://www.paws-r-sdk.com/docs/resiliencehub_add_draft_app_version_resource_mappings/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param resourceMappings &#91;required&#93; Mappings used to map logical resources from the template to physical
#' resources. You can use the mapping type `CFN_STACK` if the application
#' template uses a logical stack name. Or you can map individual resources
#' by using the mapping type `RESOURCE`. We recommend using the mapping
#' type `CFN_STACK` if the application is backed by a CloudFormation stack.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_add_draft_app_version_resource_mappings
resiliencehub_add_draft_app_version_resource_mappings <- function(appArn, resourceMappings) {
  op <- new_operation(
    name = "AddDraftAppVersionResourceMappings",
    http_method = "POST",
    http_path = "/add-draft-app-version-resource-mappings",
    paginator = list()
  )
  input <- .resiliencehub$add_draft_app_version_resource_mappings_input(appArn = appArn, resourceMappings = resourceMappings)
  output <- .resiliencehub$add_draft_app_version_resource_mappings_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$add_draft_app_version_resource_mappings <- resiliencehub_add_draft_app_version_resource_mappings

#' Enables you to include or exclude one or more operational
#' recommendations
#'
#' @description
#' Enables you to include or exclude one or more operational recommendations.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_batch_update_recommendation_status/](https://www.paws-r-sdk.com/docs/resiliencehub_batch_update_recommendation_status/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param requestEntries &#91;required&#93; Defines the list of operational recommendations that need to be included
#' or excluded.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_batch_update_recommendation_status
resiliencehub_batch_update_recommendation_status <- function(appArn, requestEntries) {
  op <- new_operation(
    name = "BatchUpdateRecommendationStatus",
    http_method = "POST",
    http_path = "/batch-update-recommendation-status",
    paginator = list()
  )
  input <- .resiliencehub$batch_update_recommendation_status_input(appArn = appArn, requestEntries = requestEntries)
  output <- .resiliencehub$batch_update_recommendation_status_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$batch_update_recommendation_status <- resiliencehub_batch_update_recommendation_status

#' Creates an Resilience Hub application
#'
#' @description
#' Creates an Resilience Hub application. An Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more CloudFormation stacks, Resource Groups, Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In addition, you can also add resources that are located on Amazon Elastic Kubernetes Service (Amazon EKS) clusters as optional resources. For more information about the number of resources supported per application, see [Service quotas](https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub).
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_create_app/](https://www.paws-r-sdk.com/docs/resiliencehub_create_app/) for full documentation.
#'
#' @param assessmentSchedule Assessment execution schedule with 'Daily' or 'Disabled' values.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param description The optional description for an app.
#' @param eventSubscriptions The list of events you would like to subscribe and get notification for.
#' Currently, Resilience Hub supports only **Drift detected** and
#' **Scheduled assessment failure** events notification.
#' @param name &#91;required&#93; Name of the application.
#' @param permissionModel Defines the roles and credentials that Resilience Hub would use while
#' creating the application, importing its resources, and running an
#' assessment.
#' @param policyArn Amazon Resource Name (ARN) of the resiliency policy. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param tags Tags assigned to the resource. A tag is a label that you assign to an
#' Amazon Web Services resource. Each tag consists of a key/value pair.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_create_app
resiliencehub_create_app <- function(assessmentSchedule = NULL, clientToken = NULL, description = NULL, eventSubscriptions = NULL, name, permissionModel = NULL, policyArn = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/create-app",
    paginator = list()
  )
  input <- .resiliencehub$create_app_input(assessmentSchedule = assessmentSchedule, clientToken = clientToken, description = description, eventSubscriptions = eventSubscriptions, name = name, permissionModel = permissionModel, policyArn = policyArn, tags = tags)
  output <- .resiliencehub$create_app_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$create_app <- resiliencehub_create_app

#' Creates a new Application Component in the Resilience Hub application
#'
#' @description
#' Creates a new Application Component in the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_create_app_version_app_component/](https://www.paws-r-sdk.com/docs/resiliencehub_create_app_version_app_component/) for full documentation.
#'
#' @param additionalInfo Currently, there is no supported additional information for Application
#' Components.
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param id Identifier of the Application Component.
#' @param name &#91;required&#93; Name of the Application Component.
#' @param type &#91;required&#93; Type of Application Component. For more information about the types of
#' Application Component, see [Grouping resources in an
#' AppComponent](https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).
#'
#' @keywords internal
#'
#' @rdname resiliencehub_create_app_version_app_component
resiliencehub_create_app_version_app_component <- function(additionalInfo = NULL, appArn, clientToken = NULL, id = NULL, name, type) {
  op <- new_operation(
    name = "CreateAppVersionAppComponent",
    http_method = "POST",
    http_path = "/create-app-version-app-component",
    paginator = list()
  )
  input <- .resiliencehub$create_app_version_app_component_input(additionalInfo = additionalInfo, appArn = appArn, clientToken = clientToken, id = id, name = name, type = type)
  output <- .resiliencehub$create_app_version_app_component_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$create_app_version_app_component <- resiliencehub_create_app_version_app_component

#' Adds a resource to the Resilience Hub application and assigns it to the
#' specified Application Components
#'
#' @description
#' Adds a resource to the Resilience Hub application and assigns it to the specified Application Components. If you specify a new Application Component, Resilience Hub will automatically create the Application Component.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_create_app_version_resource/](https://www.paws-r-sdk.com/docs/resiliencehub_create_app_version_resource/) for full documentation.
#'
#' @param additionalInfo Currently, there is no supported additional information for resources.
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appComponents &#91;required&#93; List of Application Components that this resource belongs to. If an
#' Application Component is not part of the Resilience Hub application, it
#' will be added.
#' @param awsAccountId Amazon Web Services account that owns the physical resource.
#' @param awsRegion Amazon Web Services region that owns the physical resource.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param logicalResourceId &#91;required&#93; Logical identifier of the resource.
#' @param physicalResourceId &#91;required&#93; Physical identifier of the resource.
#' @param resourceName Name of the resource.
#' @param resourceType &#91;required&#93; Type of resource.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_create_app_version_resource
resiliencehub_create_app_version_resource <- function(additionalInfo = NULL, appArn, appComponents, awsAccountId = NULL, awsRegion = NULL, clientToken = NULL, logicalResourceId, physicalResourceId, resourceName = NULL, resourceType) {
  op <- new_operation(
    name = "CreateAppVersionResource",
    http_method = "POST",
    http_path = "/create-app-version-resource",
    paginator = list()
  )
  input <- .resiliencehub$create_app_version_resource_input(additionalInfo = additionalInfo, appArn = appArn, appComponents = appComponents, awsAccountId = awsAccountId, awsRegion = awsRegion, clientToken = clientToken, logicalResourceId = logicalResourceId, physicalResourceId = physicalResourceId, resourceName = resourceName, resourceType = resourceType)
  output <- .resiliencehub$create_app_version_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$create_app_version_resource <- resiliencehub_create_app_version_resource

#' Creates a new recommendation template for the Resilience Hub application
#'
#' @description
#' Creates a new recommendation template for the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_create_recommendation_template/](https://www.paws-r-sdk.com/docs/resiliencehub_create_recommendation_template/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param bucketName The name of the Amazon S3 bucket that will contain the recommendation
#' template.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param format The format for the recommendation template.
#' 
#' **CfnJson**
#' 
#' The template is CloudFormation JSON.
#' 
#' **CfnYaml**
#' 
#' The template is CloudFormation YAML.
#' @param name &#91;required&#93; The name for the recommendation template.
#' @param recommendationIds Identifiers for the recommendations used to create a recommendation
#' template.
#' @param recommendationTypes An array of strings that specify the recommendation template type or
#' types.
#' 
#' **Alarm**
#' 
#' The template is an AlarmRecommendation template.
#' 
#' **Sop**
#' 
#' The template is a SopRecommendation template.
#' 
#' **Test**
#' 
#' The template is a TestRecommendation template.
#' @param tags Tags assigned to the resource. A tag is a label that you assign to an
#' Amazon Web Services resource. Each tag consists of a key/value pair.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_create_recommendation_template
resiliencehub_create_recommendation_template <- function(assessmentArn, bucketName = NULL, clientToken = NULL, format = NULL, name, recommendationIds = NULL, recommendationTypes = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRecommendationTemplate",
    http_method = "POST",
    http_path = "/create-recommendation-template",
    paginator = list()
  )
  input <- .resiliencehub$create_recommendation_template_input(assessmentArn = assessmentArn, bucketName = bucketName, clientToken = clientToken, format = format, name = name, recommendationIds = recommendationIds, recommendationTypes = recommendationTypes, tags = tags)
  output <- .resiliencehub$create_recommendation_template_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$create_recommendation_template <- resiliencehub_create_recommendation_template

#' Creates a resiliency policy for an application
#'
#' @description
#' Creates a resiliency policy for an application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_create_resiliency_policy/](https://www.paws-r-sdk.com/docs/resiliencehub_create_resiliency_policy/) for full documentation.
#'
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param dataLocationConstraint Specifies a high-level geographical location constraint for where your
#' resilience policy data can be stored.
#' @param policy &#91;required&#93; The type of resiliency policy to be created, including the recovery time
#' objective (RTO) and recovery point objective (RPO) in seconds.
#' @param policyDescription The description for the policy.
#' @param policyName &#91;required&#93; The name of the policy
#' @param tags Tags assigned to the resource. A tag is a label that you assign to an
#' Amazon Web Services resource. Each tag consists of a key/value pair.
#' @param tier &#91;required&#93; The tier for this resiliency policy, ranging from the highest severity
#' (`MissionCritical`) to lowest (`NonCritical`).
#'
#' @keywords internal
#'
#' @rdname resiliencehub_create_resiliency_policy
resiliencehub_create_resiliency_policy <- function(clientToken = NULL, dataLocationConstraint = NULL, policy, policyDescription = NULL, policyName, tags = NULL, tier) {
  op <- new_operation(
    name = "CreateResiliencyPolicy",
    http_method = "POST",
    http_path = "/create-resiliency-policy",
    paginator = list()
  )
  input <- .resiliencehub$create_resiliency_policy_input(clientToken = clientToken, dataLocationConstraint = dataLocationConstraint, policy = policy, policyDescription = policyDescription, policyName = policyName, tags = tags, tier = tier)
  output <- .resiliencehub$create_resiliency_policy_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$create_resiliency_policy <- resiliencehub_create_resiliency_policy

#' Deletes an Resilience Hub application
#'
#' @description
#' Deletes an Resilience Hub application. This is a destructive action that can't be undone.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_delete_app/](https://www.paws-r-sdk.com/docs/resiliencehub_delete_app/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param forceDelete A boolean option to force the deletion of an Resilience Hub application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_app
resiliencehub_delete_app <- function(appArn, clientToken = NULL, forceDelete = NULL) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "POST",
    http_path = "/delete-app",
    paginator = list()
  )
  input <- .resiliencehub$delete_app_input(appArn = appArn, clientToken = clientToken, forceDelete = forceDelete)
  output <- .resiliencehub$delete_app_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_app <- resiliencehub_delete_app

#' Deletes an Resilience Hub application assessment
#'
#' @description
#' Deletes an Resilience Hub application assessment. This is a destructive action that can't be undone.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_assessment/](https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_assessment/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_app_assessment
resiliencehub_delete_app_assessment <- function(assessmentArn, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteAppAssessment",
    http_method = "POST",
    http_path = "/delete-app-assessment",
    paginator = list()
  )
  input <- .resiliencehub$delete_app_assessment_input(assessmentArn = assessmentArn, clientToken = clientToken)
  output <- .resiliencehub$delete_app_assessment_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_app_assessment <- resiliencehub_delete_app_assessment

#' Deletes the input source and all of its imported resources from the
#' Resilience Hub application
#'
#' @description
#' Deletes the input source and all of its imported resources from the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_input_source/](https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_input_source/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param eksSourceClusterNamespace The namespace on your Amazon Elastic Kubernetes Service cluster that you
#' want to delete from the Resilience Hub application.
#' @param sourceArn The Amazon Resource Name (ARN) of the imported resource you want to
#' remove from the Resilience Hub application. For more information about
#' ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param terraformSource The imported Terraform s3 state file you want to remove from the
#' Resilience Hub application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_app_input_source
resiliencehub_delete_app_input_source <- function(appArn, clientToken = NULL, eksSourceClusterNamespace = NULL, sourceArn = NULL, terraformSource = NULL) {
  op <- new_operation(
    name = "DeleteAppInputSource",
    http_method = "POST",
    http_path = "/delete-app-input-source",
    paginator = list()
  )
  input <- .resiliencehub$delete_app_input_source_input(appArn = appArn, clientToken = clientToken, eksSourceClusterNamespace = eksSourceClusterNamespace, sourceArn = sourceArn, terraformSource = terraformSource)
  output <- .resiliencehub$delete_app_input_source_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_app_input_source <- resiliencehub_delete_app_input_source

#' Deletes an Application Component from the Resilience Hub application
#'
#' @description
#' Deletes an Application Component from the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_version_app_component/](https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_version_app_component/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param id &#91;required&#93; Identifier of the Application Component.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_app_version_app_component
resiliencehub_delete_app_version_app_component <- function(appArn, clientToken = NULL, id) {
  op <- new_operation(
    name = "DeleteAppVersionAppComponent",
    http_method = "POST",
    http_path = "/delete-app-version-app-component",
    paginator = list()
  )
  input <- .resiliencehub$delete_app_version_app_component_input(appArn = appArn, clientToken = clientToken, id = id)
  output <- .resiliencehub$delete_app_version_app_component_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_app_version_app_component <- resiliencehub_delete_app_version_app_component

#' Deletes a resource from the Resilience Hub application
#'
#' @description
#' Deletes a resource from the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_version_resource/](https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_version_resource/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param awsAccountId Amazon Web Services account that owns the physical resource.
#' @param awsRegion Amazon Web Services region that owns the physical resource.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param logicalResourceId Logical identifier of the resource.
#' @param physicalResourceId Physical identifier of the resource.
#' @param resourceName Name of the resource.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_app_version_resource
resiliencehub_delete_app_version_resource <- function(appArn, awsAccountId = NULL, awsRegion = NULL, clientToken = NULL, logicalResourceId = NULL, physicalResourceId = NULL, resourceName = NULL) {
  op <- new_operation(
    name = "DeleteAppVersionResource",
    http_method = "POST",
    http_path = "/delete-app-version-resource",
    paginator = list()
  )
  input <- .resiliencehub$delete_app_version_resource_input(appArn = appArn, awsAccountId = awsAccountId, awsRegion = awsRegion, clientToken = clientToken, logicalResourceId = logicalResourceId, physicalResourceId = physicalResourceId, resourceName = resourceName)
  output <- .resiliencehub$delete_app_version_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_app_version_resource <- resiliencehub_delete_app_version_resource

#' Deletes a recommendation template
#'
#' @description
#' Deletes a recommendation template. This is a destructive action that can't be undone.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_delete_recommendation_template/](https://www.paws-r-sdk.com/docs/resiliencehub_delete_recommendation_template/) for full documentation.
#'
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param recommendationTemplateArn &#91;required&#93; The Amazon Resource Name (ARN) for a recommendation template.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_recommendation_template
resiliencehub_delete_recommendation_template <- function(clientToken = NULL, recommendationTemplateArn) {
  op <- new_operation(
    name = "DeleteRecommendationTemplate",
    http_method = "POST",
    http_path = "/delete-recommendation-template",
    paginator = list()
  )
  input <- .resiliencehub$delete_recommendation_template_input(clientToken = clientToken, recommendationTemplateArn = recommendationTemplateArn)
  output <- .resiliencehub$delete_recommendation_template_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_recommendation_template <- resiliencehub_delete_recommendation_template

#' Deletes a resiliency policy
#'
#' @description
#' Deletes a resiliency policy. This is a destructive action that can't be undone.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_delete_resiliency_policy/](https://www.paws-r-sdk.com/docs/resiliencehub_delete_resiliency_policy/) for full documentation.
#'
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param policyArn &#91;required&#93; Amazon Resource Name (ARN) of the resiliency policy. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_resiliency_policy
resiliencehub_delete_resiliency_policy <- function(clientToken = NULL, policyArn) {
  op <- new_operation(
    name = "DeleteResiliencyPolicy",
    http_method = "POST",
    http_path = "/delete-resiliency-policy",
    paginator = list()
  )
  input <- .resiliencehub$delete_resiliency_policy_input(clientToken = clientToken, policyArn = policyArn)
  output <- .resiliencehub$delete_resiliency_policy_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_resiliency_policy <- resiliencehub_delete_resiliency_policy

#' Describes an Resilience Hub application
#'
#' @description
#' Describes an Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_app/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_app/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app
resiliencehub_describe_app <- function(appArn) {
  op <- new_operation(
    name = "DescribeApp",
    http_method = "POST",
    http_path = "/describe-app",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_input(appArn = appArn)
  output <- .resiliencehub$describe_app_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app <- resiliencehub_describe_app

#' Describes an assessment for an Resilience Hub application
#'
#' @description
#' Describes an assessment for an Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_assessment/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_assessment/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app_assessment
resiliencehub_describe_app_assessment <- function(assessmentArn) {
  op <- new_operation(
    name = "DescribeAppAssessment",
    http_method = "POST",
    http_path = "/describe-app-assessment",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_assessment_input(assessmentArn = assessmentArn)
  output <- .resiliencehub$describe_app_assessment_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_assessment <- resiliencehub_describe_app_assessment

#' Describes the Resilience Hub application version
#'
#' @description
#' Describes the Resilience Hub application version.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; Resilience Hub application version.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app_version
resiliencehub_describe_app_version <- function(appArn, appVersion) {
  op <- new_operation(
    name = "DescribeAppVersion",
    http_method = "POST",
    http_path = "/describe-app-version",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_version_input(appArn = appArn, appVersion = appVersion)
  output <- .resiliencehub$describe_app_version_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_version <- resiliencehub_describe_app_version

#' Describes an Application Component in the Resilience Hub application
#'
#' @description
#' Describes an Application Component in the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version_app_component/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version_app_component/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; Resilience Hub application version.
#' @param id &#91;required&#93; Identifier of the Application Component.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app_version_app_component
resiliencehub_describe_app_version_app_component <- function(appArn, appVersion, id) {
  op <- new_operation(
    name = "DescribeAppVersionAppComponent",
    http_method = "POST",
    http_path = "/describe-app-version-app-component",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_version_app_component_input(appArn = appArn, appVersion = appVersion, id = id)
  output <- .resiliencehub$describe_app_version_app_component_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_version_app_component <- resiliencehub_describe_app_version_app_component

#' Describes a resource of the Resilience Hub application
#'
#' @description
#' Describes a resource of the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version_resource/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version_resource/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; Resilience Hub application version.
#' @param awsAccountId Amazon Web Services account that owns the physical resource.
#' @param awsRegion Amazon Web Services region that owns the physical resource.
#' @param logicalResourceId Logical identifier of the resource.
#' @param physicalResourceId Physical identifier of the resource.
#' @param resourceName Name of the resource.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app_version_resource
resiliencehub_describe_app_version_resource <- function(appArn, appVersion, awsAccountId = NULL, awsRegion = NULL, logicalResourceId = NULL, physicalResourceId = NULL, resourceName = NULL) {
  op <- new_operation(
    name = "DescribeAppVersionResource",
    http_method = "POST",
    http_path = "/describe-app-version-resource",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_version_resource_input(appArn = appArn, appVersion = appVersion, awsAccountId = awsAccountId, awsRegion = awsRegion, logicalResourceId = logicalResourceId, physicalResourceId = physicalResourceId, resourceName = resourceName)
  output <- .resiliencehub$describe_app_version_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_version_resource <- resiliencehub_describe_app_version_resource

#' Returns the resolution status for the specified resolution identifier
#' for an application version
#'
#' @description
#' Returns the resolution status for the specified resolution identifier for an application version. If `resolutionId` is not specified, the current resolution status is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version_resources_resolution_status/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version_resources_resolution_status/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param resolutionId The identifier for a specific resolution.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_descri_app_versio_resour_resolu_status
resiliencehub_describe_app_version_resources_resolution_status <- function(appArn, appVersion, resolutionId = NULL) {
  op <- new_operation(
    name = "DescribeAppVersionResourcesResolutionStatus",
    http_method = "POST",
    http_path = "/describe-app-version-resources-resolution-status",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_version_resources_resolution_status_input(appArn = appArn, appVersion = appVersion, resolutionId = resolutionId)
  output <- .resiliencehub$describe_app_version_resources_resolution_status_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_version_resources_resolution_status <- resiliencehub_describe_app_version_resources_resolution_status

#' Describes details about an Resilience Hub application
#'
#' @description
#' Describes details about an Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version_template/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_app_version_template/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; The version of the application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app_version_template
resiliencehub_describe_app_version_template <- function(appArn, appVersion) {
  op <- new_operation(
    name = "DescribeAppVersionTemplate",
    http_method = "POST",
    http_path = "/describe-app-version-template",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_version_template_input(appArn = appArn, appVersion = appVersion)
  output <- .resiliencehub$describe_app_version_template_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_version_template <- resiliencehub_describe_app_version_template

#' Describes the status of importing resources to an application version
#'
#' @description
#' Describes the status of importing resources to an application version.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_draft_app_version_resources_import_status/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_draft_app_version_resources_import_status/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_descr_draft_app_versi_resou_impor_statu
resiliencehub_describe_draft_app_version_resources_import_status <- function(appArn) {
  op <- new_operation(
    name = "DescribeDraftAppVersionResourcesImportStatus",
    http_method = "POST",
    http_path = "/describe-draft-app-version-resources-import-status",
    paginator = list()
  )
  input <- .resiliencehub$describe_draft_app_version_resources_import_status_input(appArn = appArn)
  output <- .resiliencehub$describe_draft_app_version_resources_import_status_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_draft_app_version_resources_import_status <- resiliencehub_describe_draft_app_version_resources_import_status

#' Describes a specified resiliency policy for an Resilience Hub
#' application
#'
#' @description
#' Describes a specified resiliency policy for an Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_describe_resiliency_policy/](https://www.paws-r-sdk.com/docs/resiliencehub_describe_resiliency_policy/) for full documentation.
#'
#' @param policyArn &#91;required&#93; Amazon Resource Name (ARN) of the resiliency policy. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_resiliency_policy
resiliencehub_describe_resiliency_policy <- function(policyArn) {
  op <- new_operation(
    name = "DescribeResiliencyPolicy",
    http_method = "POST",
    http_path = "/describe-resiliency-policy",
    paginator = list()
  )
  input <- .resiliencehub$describe_resiliency_policy_input(policyArn = policyArn)
  output <- .resiliencehub$describe_resiliency_policy_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_resiliency_policy <- resiliencehub_describe_resiliency_policy

#' Imports resources to Resilience Hub application draft version from
#' different input sources
#'
#' @description
#' Imports resources to Resilience Hub application draft version from different input sources. For more information about the input sources supported by Resilience Hub, see [Discover the structure and describe your Resilience Hub application](https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html).
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_import_resources_to_draft_app_version/](https://www.paws-r-sdk.com/docs/resiliencehub_import_resources_to_draft_app_version/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param eksSources The input sources of the Amazon Elastic Kubernetes Service resources you
#' need to import.
#' @param importStrategy The import strategy you would like to set to import resources into
#' Resilience Hub application.
#' @param sourceArns The Amazon Resource Names (ARNs) for the resources.
#' @param terraformSources A list of terraform file s3 URLs you need to import.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_import_resources_to_draft_app_version
resiliencehub_import_resources_to_draft_app_version <- function(appArn, eksSources = NULL, importStrategy = NULL, sourceArns = NULL, terraformSources = NULL) {
  op <- new_operation(
    name = "ImportResourcesToDraftAppVersion",
    http_method = "POST",
    http_path = "/import-resources-to-draft-app-version",
    paginator = list()
  )
  input <- .resiliencehub$import_resources_to_draft_app_version_input(appArn = appArn, eksSources = eksSources, importStrategy = importStrategy, sourceArns = sourceArns, terraformSources = terraformSources)
  output <- .resiliencehub$import_resources_to_draft_app_version_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$import_resources_to_draft_app_version <- resiliencehub_import_resources_to_draft_app_version

#' Lists the alarm recommendations for an Resilience Hub application
#'
#' @description
#' Lists the alarm recommendations for an Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_alarm_recommendations/](https://www.paws-r-sdk.com/docs/resiliencehub_list_alarm_recommendations/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_alarm_recommendations
resiliencehub_list_alarm_recommendations <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAlarmRecommendations",
    http_method = "POST",
    http_path = "/list-alarm-recommendations",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_alarm_recommendations_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_alarm_recommendations_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_alarm_recommendations <- resiliencehub_list_alarm_recommendations

#' List of compliance drifts that were detected while running an assessment
#'
#' @description
#' List of compliance drifts that were detected while running an assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_assessment_compliance_drifts/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_assessment_compliance_drifts/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param maxResults Indicates the maximum number of applications requested.
#' @param nextToken Indicates the unique token number of the next application to be checked
#' for compliance and regulatory requirements from the list of
#' applications.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_assessment_compliance_drifts
resiliencehub_list_app_assessment_compliance_drifts <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppAssessmentComplianceDrifts",
    http_method = "POST",
    http_path = "/list-app-assessment-compliance-drifts",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_assessment_compliance_drifts_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_assessment_compliance_drifts_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_assessment_compliance_drifts <- resiliencehub_list_app_assessment_compliance_drifts

#' Lists the assessments for an Resilience Hub application
#'
#' @description
#' Lists the assessments for an Resilience Hub application. You can use request parameters to refine the results for the response object.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_assessments/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_assessments/) for full documentation.
#'
#' @param appArn Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param assessmentName The name for the assessment.
#' @param assessmentStatus The current status of the assessment for the resiliency policy.
#' @param complianceStatus The current status of compliance for the resiliency policy.
#' @param invoker Specifies the entity that invoked a specific assessment, either a `User`
#' or the `System`.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param reverseOrder The default is to sort by ascending **startTime**. To sort by descending
#' **startTime**, set reverseOrder to `true`.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_assessments
resiliencehub_list_app_assessments <- function(appArn = NULL, assessmentName = NULL, assessmentStatus = NULL, complianceStatus = NULL, invoker = NULL, maxResults = NULL, nextToken = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListAppAssessments",
    http_method = "GET",
    http_path = "/list-app-assessments",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_assessments_input(appArn = appArn, assessmentName = assessmentName, assessmentStatus = assessmentStatus, complianceStatus = complianceStatus, invoker = invoker, maxResults = maxResults, nextToken = nextToken, reverseOrder = reverseOrder)
  output <- .resiliencehub$list_app_assessments_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_assessments <- resiliencehub_list_app_assessments

#' Lists the compliances for an Resilience Hub Application Component
#'
#' @description
#' Lists the compliances for an Resilience Hub Application Component.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_component_compliances/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_component_compliances/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_component_compliances
resiliencehub_list_app_component_compliances <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppComponentCompliances",
    http_method = "POST",
    http_path = "/list-app-component-compliances",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_component_compliances_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_component_compliances_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_component_compliances <- resiliencehub_list_app_component_compliances

#' Lists the recommendations for an Resilience Hub Application Component
#'
#' @description
#' Lists the recommendations for an Resilience Hub Application Component.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_component_recommendations/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_component_recommendations/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_component_recommendations
resiliencehub_list_app_component_recommendations <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppComponentRecommendations",
    http_method = "POST",
    http_path = "/list-app-component-recommendations",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_component_recommendations_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_component_recommendations_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_component_recommendations <- resiliencehub_list_app_component_recommendations

#' Lists all the input sources of the Resilience Hub application
#'
#' @description
#' Lists all the input sources of the Resilience Hub application. For more information about the input sources supported by Resilience Hub, see [Discover the structure and describe your Resilience Hub application](https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html).
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_input_sources/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_input_sources/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; Resilience Hub application version.
#' @param maxResults Maximum number of input sources to be displayed per Resilience Hub
#' application.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_input_sources
resiliencehub_list_app_input_sources <- function(appArn, appVersion, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppInputSources",
    http_method = "POST",
    http_path = "/list-app-input-sources",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_input_sources_input(appArn = appArn, appVersion = appVersion, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_input_sources_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_input_sources <- resiliencehub_list_app_input_sources

#' Lists all the Application Components in the Resilience Hub application
#'
#' @description
#' Lists all the Application Components in the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_version_app_components/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_version_app_components/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; Version of the Application Component.
#' @param maxResults Maximum number of Application Components to be displayed per Resilience
#' Hub application version.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_version_app_components
resiliencehub_list_app_version_app_components <- function(appArn, appVersion, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppVersionAppComponents",
    http_method = "POST",
    http_path = "/list-app-version-app-components",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_version_app_components_input(appArn = appArn, appVersion = appVersion, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_version_app_components_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_version_app_components <- resiliencehub_list_app_version_app_components

#' Lists how the resources in an application version are mapped/sourced
#' from
#'
#' @description
#' Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_version_resource_mappings/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_version_resource_mappings/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_version_resource_mappings
resiliencehub_list_app_version_resource_mappings <- function(appArn, appVersion, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppVersionResourceMappings",
    http_method = "POST",
    http_path = "/list-app-version-resource-mappings",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_version_resource_mappings_input(appArn = appArn, appVersion = appVersion, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_version_resource_mappings_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_version_resource_mappings <- resiliencehub_list_app_version_resource_mappings

#' Lists all the resources in an Resilience Hub application
#'
#' @description
#' Lists all the resources in an Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_version_resources/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_version_resources/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param resolutionId The identifier for a specific resolution.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_version_resources
resiliencehub_list_app_version_resources <- function(appArn, appVersion, maxResults = NULL, nextToken = NULL, resolutionId = NULL) {
  op <- new_operation(
    name = "ListAppVersionResources",
    http_method = "POST",
    http_path = "/list-app-version-resources",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_version_resources_input(appArn = appArn, appVersion = appVersion, maxResults = maxResults, nextToken = nextToken, resolutionId = resolutionId)
  output <- .resiliencehub$list_app_version_resources_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_version_resources <- resiliencehub_list_app_version_resources

#' Lists the different versions for the Resilience Hub applications
#'
#' @description
#' Lists the different versions for the Resilience Hub applications.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_app_versions/](https://www.paws-r-sdk.com/docs/resiliencehub_list_app_versions/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param endTime Upper limit of the time range to filter the application versions.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param startTime Lower limit of the time range to filter the application versions.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_versions
resiliencehub_list_app_versions <- function(appArn, endTime = NULL, maxResults = NULL, nextToken = NULL, startTime = NULL) {
  op <- new_operation(
    name = "ListAppVersions",
    http_method = "POST",
    http_path = "/list-app-versions",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_app_versions_input(appArn = appArn, endTime = endTime, maxResults = maxResults, nextToken = nextToken, startTime = startTime)
  output <- .resiliencehub$list_app_versions_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_versions <- resiliencehub_list_app_versions

#' Lists your Resilience Hub applications
#'
#' @description
#' Lists your Resilience Hub applications.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_apps/](https://www.paws-r-sdk.com/docs/resiliencehub_list_apps/) for full documentation.
#'
#' @param appArn Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param fromLastAssessmentTime Indicates the lower limit of the range that is used to filter
#' applications based on their last assessment times.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param name The name for the one of the listed applications.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param reverseOrder The application list is sorted based on the values of
#' `lastAppComplianceEvaluationTime` field. By default, application list is
#' sorted in ascending order. To sort the appliation list in descending
#' order, set this field to `True`.
#' @param toLastAssessmentTime Indicates the upper limit of the range that is used to filter the
#' applications based on their last assessment times.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_apps
resiliencehub_list_apps <- function(appArn = NULL, fromLastAssessmentTime = NULL, maxResults = NULL, name = NULL, nextToken = NULL, reverseOrder = NULL, toLastAssessmentTime = NULL) {
  op <- new_operation(
    name = "ListApps",
    http_method = "GET",
    http_path = "/list-apps",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_apps_input(appArn = appArn, fromLastAssessmentTime = fromLastAssessmentTime, maxResults = maxResults, name = name, nextToken = nextToken, reverseOrder = reverseOrder, toLastAssessmentTime = toLastAssessmentTime)
  output <- .resiliencehub$list_apps_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_apps <- resiliencehub_list_apps

#' Lists the recommendation templates for the Resilience Hub applications
#'
#' @description
#' Lists the recommendation templates for the Resilience Hub applications.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_recommendation_templates/](https://www.paws-r-sdk.com/docs/resiliencehub_list_recommendation_templates/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param name The name for one of the listed recommendation templates.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param recommendationTemplateArn The Amazon Resource Name (ARN) for a recommendation template.
#' @param reverseOrder The default is to sort by ascending **startTime**. To sort by descending
#' **startTime**, set reverseOrder to `true`.
#' @param status Status of the action.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_recommendation_templates
resiliencehub_list_recommendation_templates <- function(assessmentArn, maxResults = NULL, name = NULL, nextToken = NULL, recommendationTemplateArn = NULL, reverseOrder = NULL, status = NULL) {
  op <- new_operation(
    name = "ListRecommendationTemplates",
    http_method = "GET",
    http_path = "/list-recommendation-templates",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_recommendation_templates_input(assessmentArn = assessmentArn, maxResults = maxResults, name = name, nextToken = nextToken, recommendationTemplateArn = recommendationTemplateArn, reverseOrder = reverseOrder, status = status)
  output <- .resiliencehub$list_recommendation_templates_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_recommendation_templates <- resiliencehub_list_recommendation_templates

#' Lists the resiliency policies for the Resilience Hub applications
#'
#' @description
#' Lists the resiliency policies for the Resilience Hub applications.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_resiliency_policies/](https://www.paws-r-sdk.com/docs/resiliencehub_list_resiliency_policies/) for full documentation.
#'
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param policyName The name of the policy
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_resiliency_policies
resiliencehub_list_resiliency_policies <- function(maxResults = NULL, nextToken = NULL, policyName = NULL) {
  op <- new_operation(
    name = "ListResiliencyPolicies",
    http_method = "GET",
    http_path = "/list-resiliency-policies",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_resiliency_policies_input(maxResults = maxResults, nextToken = nextToken, policyName = policyName)
  output <- .resiliencehub$list_resiliency_policies_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_resiliency_policies <- resiliencehub_list_resiliency_policies

#' Lists the standard operating procedure (SOP) recommendations for the
#' Resilience Hub applications
#'
#' @description
#' Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_sop_recommendations/](https://www.paws-r-sdk.com/docs/resiliencehub_list_sop_recommendations/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_sop_recommendations
resiliencehub_list_sop_recommendations <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSopRecommendations",
    http_method = "POST",
    http_path = "/list-sop-recommendations",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_sop_recommendations_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_sop_recommendations_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_sop_recommendations <- resiliencehub_list_sop_recommendations

#' Lists the suggested resiliency policies for the Resilience Hub
#' applications
#'
#' @description
#' Lists the suggested resiliency policies for the Resilience Hub applications.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_suggested_resiliency_policies/](https://www.paws-r-sdk.com/docs/resiliencehub_list_suggested_resiliency_policies/) for full documentation.
#'
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_suggested_resiliency_policies
resiliencehub_list_suggested_resiliency_policies <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSuggestedResiliencyPolicies",
    http_method = "GET",
    http_path = "/list-suggested-resiliency-policies",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_suggested_resiliency_policies_input(maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_suggested_resiliency_policies_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_suggested_resiliency_policies <- resiliencehub_list_suggested_resiliency_policies

#' Lists the tags for your resources in your Resilience Hub applications
#'
#' @description
#' Lists the tags for your resources in your Resilience Hub applications.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/resiliencehub_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for a specific resource in your
#' Resilience Hub application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_tags_for_resource
resiliencehub_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .resiliencehub$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .resiliencehub$list_tags_for_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_tags_for_resource <- resiliencehub_list_tags_for_resource

#' Lists the test recommendations for the Resilience Hub application
#'
#' @description
#' Lists the test recommendations for the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_test_recommendations/](https://www.paws-r-sdk.com/docs/resiliencehub_list_test_recommendations/) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; Amazon Resource Name (ARN) of the assessment. The format for this ARN
#' is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_test_recommendations
resiliencehub_list_test_recommendations <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTestRecommendations",
    http_method = "POST",
    http_path = "/list-test-recommendations",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_test_recommendations_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_test_recommendations_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_test_recommendations <- resiliencehub_list_test_recommendations

#' Lists the resources that are not currently supported in Resilience Hub
#'
#' @description
#' Lists the resources that are not currently supported in Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_list_unsupported_app_version_resources/](https://www.paws-r-sdk.com/docs/resiliencehub_list_unsupported_app_version_resources/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param maxResults Maximum number of results to include in the response. If more results
#' exist than the specified `MaxResults` value, a token is included in the
#' response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param resolutionId The identifier for a specific resolution.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_unsupported_app_version_resources
resiliencehub_list_unsupported_app_version_resources <- function(appArn, appVersion, maxResults = NULL, nextToken = NULL, resolutionId = NULL) {
  op <- new_operation(
    name = "ListUnsupportedAppVersionResources",
    http_method = "POST",
    http_path = "/list-unsupported-app-version-resources",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .resiliencehub$list_unsupported_app_version_resources_input(appArn = appArn, appVersion = appVersion, maxResults = maxResults, nextToken = nextToken, resolutionId = resolutionId)
  output <- .resiliencehub$list_unsupported_app_version_resources_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_unsupported_app_version_resources <- resiliencehub_list_unsupported_app_version_resources

#' Publishes a new version of a specific Resilience Hub application
#'
#' @description
#' Publishes a new version of a specific Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_publish_app_version/](https://www.paws-r-sdk.com/docs/resiliencehub_publish_app_version/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param versionName Name of the application version.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_publish_app_version
resiliencehub_publish_app_version <- function(appArn, versionName = NULL) {
  op <- new_operation(
    name = "PublishAppVersion",
    http_method = "POST",
    http_path = "/publish-app-version",
    paginator = list()
  )
  input <- .resiliencehub$publish_app_version_input(appArn = appArn, versionName = versionName)
  output <- .resiliencehub$publish_app_version_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$publish_app_version <- resiliencehub_publish_app_version

#' Adds or updates the app template for an Resilience Hub application draft
#' version
#'
#' @description
#' Adds or updates the app template for an Resilience Hub application draft version.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_put_draft_app_version_template/](https://www.paws-r-sdk.com/docs/resiliencehub_put_draft_app_version_template/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appTemplateBody &#91;required&#93; A JSON string that provides information about your application
#' structure. To learn more about the `appTemplateBody` template, see the
#' sample template provided in the *Examples* section.
#' 
#' The `appTemplateBody` JSON string has the following structure:
#' 
#' -   **`resources`**
#' 
#'     The list of logical resources that must be included in the
#'     Resilience Hub application.
#' 
#'     Type: Array
#' 
#'     Don't add the resources that you want to exclude.
#' 
#'     Each `resources` array item includes the following fields:
#' 
#'     -   *logicalResourceId*
#' 
#'         Logical identifier of the resource.
#' 
#'         Type: Object
#' 
#'         Each `logicalResourceId` object includes the following fields:
#' 
#'         -   `identifier`
#' 
#'             Identifier of the resource.
#' 
#'             Type: String
#' 
#'         -   `logicalStackName`
#' 
#'             The name of the CloudFormation stack this resource belongs
#'             to.
#' 
#'             Type: String
#' 
#'         -   `resourceGroupName`
#' 
#'             The name of the resource group this resource belongs to.
#' 
#'             Type: String
#' 
#'         -   `terraformSourceName`
#' 
#'             The name of the Terraform S3 state file this resource
#'             belongs to.
#' 
#'             Type: String
#' 
#'         -   `eksSourceName`
#' 
#'             Name of the Amazon Elastic Kubernetes Service cluster and
#'             namespace this resource belongs to.
#' 
#'             This parameter accepts values in "eks-cluster/namespace"
#'             format.
#' 
#'             Type: String
#' 
#'     -   *type*
#' 
#'         The type of resource.
#' 
#'         Type: string
#' 
#'     -   *name*
#' 
#'         The name of the resource.
#' 
#'         Type: String
#' 
#'     -   `additionalInfo`
#' 
#'         Additional configuration parameters for an Resilience Hub
#'         application. If you want to implement `additionalInfo` through
#'         the Resilience Hub console rather than using an API call, see
#'         [Configure the application configuration
#'         parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
#' 
#'         Currently, this parameter accepts a key-value mapping (in a
#'         string format) of only one failover region and one associated
#'         account.
#' 
#'         Key: `"failover-regions"`
#' 
#'         Value:
#'         `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
#' 
#' -   **`appComponents`**
#' 
#'     List of Application Components that this resource belongs to. If an
#'     Application Component is not part of the Resilience Hub application,
#'     it will be added.
#' 
#'     Type: Array
#' 
#'     Each `appComponents` array item includes the following fields:
#' 
#'     -   `name`
#' 
#'         Name of the Application Component.
#' 
#'         Type: String
#' 
#'     -   `type`
#' 
#'         Type of Application Component. For more information about the
#'         types of Application Component, see [Grouping resources in an
#'         AppComponent](https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).
#' 
#'         Type: String
#' 
#'     -   `resourceNames`
#' 
#'         The list of included resources that are assigned to the
#'         Application Component.
#' 
#'         Type: Array of strings
#' 
#'     -   `additionalInfo`
#' 
#'         Additional configuration parameters for an Resilience Hub
#'         application. If you want to implement `additionalInfo` through
#'         the Resilience Hub console rather than using an API call, see
#'         [Configure the application configuration
#'         parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
#' 
#'         Currently, this parameter accepts a key-value mapping (in a
#'         string format) of only one failover region and one associated
#'         account.
#' 
#'         Key: `"failover-regions"`
#' 
#'         Value:
#'         `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
#' 
#' -   **`excludedResources`**
#' 
#'     The list of logical resource identifiers to be excluded from the
#'     application.
#' 
#'     Type: Array
#' 
#'     Don't add the resources that you want to include.
#' 
#'     Each `excludedResources` array item includes the following fields:
#' 
#'     -   *logicalResourceIds*
#' 
#'         Logical identifier of the resource.
#' 
#'         Type: Object
#' 
#'         You can configure only one of the following fields:
#' 
#'         -   `logicalStackName`
#' 
#'         -   `resourceGroupName`
#' 
#'         -   `terraformSourceName`
#' 
#'         -   `eksSourceName`
#' 
#'         Each `logicalResourceIds` object includes the following fields:
#' 
#'         -   `identifier`
#' 
#'             Identifier of the resource.
#' 
#'             Type: String
#' 
#'         -   `logicalStackName`
#' 
#'             The name of the CloudFormation stack this resource belongs
#'             to.
#' 
#'             Type: String
#' 
#'         -   `resourceGroupName`
#' 
#'             The name of the resource group this resource belongs to.
#' 
#'             Type: String
#' 
#'         -   `terraformSourceName`
#' 
#'             The name of the Terraform S3 state file this resource
#'             belongs to.
#' 
#'             Type: String
#' 
#'         -   `eksSourceName`
#' 
#'             Name of the Amazon Elastic Kubernetes Service cluster and
#'             namespace this resource belongs to.
#' 
#'             This parameter accepts values in "eks-cluster/namespace"
#'             format.
#' 
#'             Type: String
#' 
#' -   **`version`**
#' 
#'     Resilience Hub application version.
#' 
#' -   `additionalInfo`
#' 
#'     Additional configuration parameters for an Resilience Hub
#'     application. If you want to implement `additionalInfo` through the
#'     Resilience Hub console rather than using an API call, see [Configure
#'     the application configuration
#'     parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
#' 
#'     Currently, this parameter accepts a key-value mapping (in a string
#'     format) of only one failover region and one associated account.
#' 
#'     Key: `"failover-regions"`
#' 
#'     Value:
#'     `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
#'
#' @keywords internal
#'
#' @rdname resiliencehub_put_draft_app_version_template
resiliencehub_put_draft_app_version_template <- function(appArn, appTemplateBody) {
  op <- new_operation(
    name = "PutDraftAppVersionTemplate",
    http_method = "POST",
    http_path = "/put-draft-app-version-template",
    paginator = list()
  )
  input <- .resiliencehub$put_draft_app_version_template_input(appArn = appArn, appTemplateBody = appTemplateBody)
  output <- .resiliencehub$put_draft_app_version_template_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$put_draft_app_version_template <- resiliencehub_put_draft_app_version_template

#' Removes resource mappings from a draft application version
#'
#' @description
#' Removes resource mappings from a draft application version.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_remove_draft_app_version_resource_mappings/](https://www.paws-r-sdk.com/docs/resiliencehub_remove_draft_app_version_resource_mappings/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appRegistryAppNames The names of the registered applications you want to remove from the
#' resource mappings.
#' @param eksSourceNames The names of the Amazon Elastic Kubernetes Service clusters and
#' namespaces you want to remove from the resource mappings.
#' 
#' This parameter accepts values in "eks-cluster/namespace" format.
#' @param logicalStackNames The names of the CloudFormation stacks you want to remove from the
#' resource mappings.
#' @param resourceGroupNames The names of the resource groups you want to remove from the resource
#' mappings.
#' @param resourceNames The names of the resources you want to remove from the resource
#' mappings.
#' @param terraformSourceNames The names of the Terraform sources you want to remove from the resource
#' mappings.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_remove_draft_app_version_resource_mappings
resiliencehub_remove_draft_app_version_resource_mappings <- function(appArn, appRegistryAppNames = NULL, eksSourceNames = NULL, logicalStackNames = NULL, resourceGroupNames = NULL, resourceNames = NULL, terraformSourceNames = NULL) {
  op <- new_operation(
    name = "RemoveDraftAppVersionResourceMappings",
    http_method = "POST",
    http_path = "/remove-draft-app-version-resource-mappings",
    paginator = list()
  )
  input <- .resiliencehub$remove_draft_app_version_resource_mappings_input(appArn = appArn, appRegistryAppNames = appRegistryAppNames, eksSourceNames = eksSourceNames, logicalStackNames = logicalStackNames, resourceGroupNames = resourceGroupNames, resourceNames = resourceNames, terraformSourceNames = terraformSourceNames)
  output <- .resiliencehub$remove_draft_app_version_resource_mappings_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$remove_draft_app_version_resource_mappings <- resiliencehub_remove_draft_app_version_resource_mappings

#' Resolves the resources for an application version
#'
#' @description
#' Resolves the resources for an application version.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_resolve_app_version_resources/](https://www.paws-r-sdk.com/docs/resiliencehub_resolve_app_version_resources/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; The version of the application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_resolve_app_version_resources
resiliencehub_resolve_app_version_resources <- function(appArn, appVersion) {
  op <- new_operation(
    name = "ResolveAppVersionResources",
    http_method = "POST",
    http_path = "/resolve-app-version-resources",
    paginator = list()
  )
  input <- .resiliencehub$resolve_app_version_resources_input(appArn = appArn, appVersion = appVersion)
  output <- .resiliencehub$resolve_app_version_resources_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$resolve_app_version_resources <- resiliencehub_resolve_app_version_resources

#' Creates a new application assessment for an application
#'
#' @description
#' Creates a new application assessment for an application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_start_app_assessment/](https://www.paws-r-sdk.com/docs/resiliencehub_start_app_assessment/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param assessmentName &#91;required&#93; The name for the assessment.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param tags Tags assigned to the resource. A tag is a label that you assign to an
#' Amazon Web Services resource. Each tag consists of a key/value pair.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_start_app_assessment
resiliencehub_start_app_assessment <- function(appArn, appVersion, assessmentName, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "StartAppAssessment",
    http_method = "POST",
    http_path = "/start-app-assessment",
    paginator = list()
  )
  input <- .resiliencehub$start_app_assessment_input(appArn = appArn, appVersion = appVersion, assessmentName = assessmentName, clientToken = clientToken, tags = tags)
  output <- .resiliencehub$start_app_assessment_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$start_app_assessment <- resiliencehub_start_app_assessment

#' Applies one or more tags to a resource
#'
#' @description
#' Applies one or more tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_tag_resource/](https://www.paws-r-sdk.com/docs/resiliencehub_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags to assign to the resource. Each tag consists of a key/value
#' pair.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_tag_resource
resiliencehub_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .resiliencehub$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .resiliencehub$tag_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$tag_resource <- resiliencehub_tag_resource

#' Removes one or more tags from a resource
#'
#' @description
#' Removes one or more tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_untag_resource/](https://www.paws-r-sdk.com/docs/resiliencehub_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The keys of the tags you want to remove.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_untag_resource
resiliencehub_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .resiliencehub$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .resiliencehub$untag_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$untag_resource <- resiliencehub_untag_resource

#' Updates an application
#'
#' @description
#' Updates an application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_update_app/](https://www.paws-r-sdk.com/docs/resiliencehub_update_app/) for full documentation.
#'
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param assessmentSchedule Assessment execution schedule with 'Daily' or 'Disabled' values.
#' @param clearResiliencyPolicyArn Specifies if the resiliency policy ARN should be cleared.
#' @param description The optional description for an app.
#' @param eventSubscriptions The list of events you would like to subscribe and get notification for.
#' Currently, Resilience Hub supports notifications only for **Drift
#' detected** and **Scheduled assessment failure** events.
#' @param permissionModel Defines the roles and credentials that Resilience Hub would use while
#' creating an application, importing its resources, and running an
#' assessment.
#' @param policyArn Amazon Resource Name (ARN) of the resiliency policy. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_update_app
resiliencehub_update_app <- function(appArn, assessmentSchedule = NULL, clearResiliencyPolicyArn = NULL, description = NULL, eventSubscriptions = NULL, permissionModel = NULL, policyArn = NULL) {
  op <- new_operation(
    name = "UpdateApp",
    http_method = "POST",
    http_path = "/update-app",
    paginator = list()
  )
  input <- .resiliencehub$update_app_input(appArn = appArn, assessmentSchedule = assessmentSchedule, clearResiliencyPolicyArn = clearResiliencyPolicyArn, description = description, eventSubscriptions = eventSubscriptions, permissionModel = permissionModel, policyArn = policyArn)
  output <- .resiliencehub$update_app_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$update_app <- resiliencehub_update_app

#' Updates the Resilience Hub application version
#'
#' @description
#' Updates the Resilience Hub application version.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_update_app_version/](https://www.paws-r-sdk.com/docs/resiliencehub_update_app_version/) for full documentation.
#'
#' @param additionalInfo Additional configuration parameters for an Resilience Hub application.
#' If you want to implement `additionalInfo` through the Resilience Hub
#' console rather than using an API call, see [Configure the application
#' configuration
#' parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
#' 
#' Currently, this parameter accepts a key-value mapping (in a string
#' format) of only one failover region and one associated account.
#' 
#' Key: `"failover-regions"`
#' 
#' Value: `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_update_app_version
resiliencehub_update_app_version <- function(additionalInfo = NULL, appArn) {
  op <- new_operation(
    name = "UpdateAppVersion",
    http_method = "POST",
    http_path = "/update-app-version",
    paginator = list()
  )
  input <- .resiliencehub$update_app_version_input(additionalInfo = additionalInfo, appArn = appArn)
  output <- .resiliencehub$update_app_version_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$update_app_version <- resiliencehub_update_app_version

#' Updates an existing Application Component in the Resilience Hub
#' application
#'
#' @description
#' Updates an existing Application Component in the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_update_app_version_app_component/](https://www.paws-r-sdk.com/docs/resiliencehub_update_app_version_app_component/) for full documentation.
#'
#' @param additionalInfo Currently, there is no supported additional information for Application
#' Components.
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param id &#91;required&#93; Identifier of the Application Component.
#' @param name Name of the Application Component.
#' @param type Type of Application Component. For more information about the types of
#' Application Component, see [Grouping resources in an
#' AppComponent](https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).
#'
#' @keywords internal
#'
#' @rdname resiliencehub_update_app_version_app_component
resiliencehub_update_app_version_app_component <- function(additionalInfo = NULL, appArn, id, name = NULL, type = NULL) {
  op <- new_operation(
    name = "UpdateAppVersionAppComponent",
    http_method = "POST",
    http_path = "/update-app-version-app-component",
    paginator = list()
  )
  input <- .resiliencehub$update_app_version_app_component_input(additionalInfo = additionalInfo, appArn = appArn, id = id, name = name, type = type)
  output <- .resiliencehub$update_app_version_app_component_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$update_app_version_app_component <- resiliencehub_update_app_version_app_component

#' Updates the resource details in the Resilience Hub application
#'
#' @description
#' Updates the resource details in the Resilience Hub application.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_update_app_version_resource/](https://www.paws-r-sdk.com/docs/resiliencehub_update_app_version_resource/) for full documentation.
#'
#' @param additionalInfo Currently, there is no supported additional information for resources.
#' @param appArn &#91;required&#93; Amazon Resource Name (ARN) of the Resilience Hub application. The format
#' for this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more
#' information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param appComponents List of Application Components that this resource belongs to. If an
#' Application Component is not part of the Resilience Hub application, it
#' will be added.
#' @param awsAccountId Amazon Web Services account that owns the physical resource.
#' @param awsRegion Amazon Web Services region that owns the physical resource.
#' @param excluded Indicates if a resource is excluded from an Resilience Hub application.
#' 
#' You can exclude only imported resources from an Resilience Hub
#' application.
#' @param logicalResourceId Logical identifier of the resource.
#' @param physicalResourceId Physical identifier of the resource.
#' @param resourceName Name of the resource.
#' @param resourceType Type of resource.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_update_app_version_resource
resiliencehub_update_app_version_resource <- function(additionalInfo = NULL, appArn, appComponents = NULL, awsAccountId = NULL, awsRegion = NULL, excluded = NULL, logicalResourceId = NULL, physicalResourceId = NULL, resourceName = NULL, resourceType = NULL) {
  op <- new_operation(
    name = "UpdateAppVersionResource",
    http_method = "POST",
    http_path = "/update-app-version-resource",
    paginator = list()
  )
  input <- .resiliencehub$update_app_version_resource_input(additionalInfo = additionalInfo, appArn = appArn, appComponents = appComponents, awsAccountId = awsAccountId, awsRegion = awsRegion, excluded = excluded, logicalResourceId = logicalResourceId, physicalResourceId = physicalResourceId, resourceName = resourceName, resourceType = resourceType)
  output <- .resiliencehub$update_app_version_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$update_app_version_resource <- resiliencehub_update_app_version_resource

#' Updates a resiliency policy
#'
#' @description
#' Updates a resiliency policy.
#'
#' See [https://www.paws-r-sdk.com/docs/resiliencehub_update_resiliency_policy/](https://www.paws-r-sdk.com/docs/resiliencehub_update_resiliency_policy/) for full documentation.
#'
#' @param dataLocationConstraint Specifies a high-level geographical location constraint for where your
#' resilience policy data can be stored.
#' @param policy The type of resiliency policy to be created, including the recovery time
#' objective (RTO) and recovery point objective (RPO) in seconds.
#' @param policyArn &#91;required&#93; Amazon Resource Name (ARN) of the resiliency policy. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference* guide.
#' @param policyDescription The description for the policy.
#' @param policyName The name of the policy
#' @param tier The tier for this resiliency policy, ranging from the highest severity
#' (`MissionCritical`) to lowest (`NonCritical`).
#'
#' @keywords internal
#'
#' @rdname resiliencehub_update_resiliency_policy
resiliencehub_update_resiliency_policy <- function(dataLocationConstraint = NULL, policy = NULL, policyArn, policyDescription = NULL, policyName = NULL, tier = NULL) {
  op <- new_operation(
    name = "UpdateResiliencyPolicy",
    http_method = "POST",
    http_path = "/update-resiliency-policy",
    paginator = list()
  )
  input <- .resiliencehub$update_resiliency_policy_input(dataLocationConstraint = dataLocationConstraint, policy = policy, policyArn = policyArn, policyDescription = policyDescription, policyName = policyName, tier = tier)
  output <- .resiliencehub$update_resiliency_policy_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$update_resiliency_policy <- resiliencehub_update_resiliency_policy
