# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include appregistry_service.R
NULL

#' Associates an attribute group with an application to augment the
#' application's metadata with the group's attributes
#'
#' @description
#' Associates an attribute group with an application to augment the application's metadata with the group's attributes. This feature enables applications to be described with user-defined details that are machine-readable, such as third-party integrations.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_associate_attribute_group/](https://www.paws-r-sdk.com/docs/appregistry_associate_attribute_group/) for full documentation.
#'
#' @param application &#91;required&#93; The name, ID, or ARN of the application.
#' @param attributeGroup &#91;required&#93; The name, ID, or ARN of the attribute group that holds the attributes to
#' describe the application.
#'
#' @keywords internal
#'
#' @rdname appregistry_associate_attribute_group
appregistry_associate_attribute_group <- function(application, attributeGroup) {
  op <- new_operation(
    name = "AssociateAttributeGroup",
    http_method = "PUT",
    http_path = "/applications/{application}/attribute-groups/{attributeGroup}",
    paginator = list()
  )
  input <- .appregistry$associate_attribute_group_input(application = application, attributeGroup = attributeGroup)
  output <- .appregistry$associate_attribute_group_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$associate_attribute_group <- appregistry_associate_attribute_group

#' Associates a resource with an application
#'
#' @description
#' Associates a resource with an application. The resource can be specified by its ARN or name. The application can be specified by ARN, ID, or name.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_associate_resource/](https://www.paws-r-sdk.com/docs/appregistry_associate_resource/) for full documentation.
#'
#' @param application &#91;required&#93; The name, ID, or ARN of the application.
#' @param resourceType &#91;required&#93; The type of resource of which the application will be associated.
#' @param resource &#91;required&#93; The name or ID of the resource of which the application will be
#' associated.
#'
#' @keywords internal
#'
#' @rdname appregistry_associate_resource
appregistry_associate_resource <- function(application, resourceType, resource) {
  op <- new_operation(
    name = "AssociateResource",
    http_method = "PUT",
    http_path = "/applications/{application}/resources/{resourceType}/{resource}",
    paginator = list()
  )
  input <- .appregistry$associate_resource_input(application = application, resourceType = resourceType, resource = resource)
  output <- .appregistry$associate_resource_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$associate_resource <- appregistry_associate_resource

#' Creates a new application that is the top-level node in a hierarchy of
#' related cloud resource abstractions
#'
#' @description
#' Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_create_application/](https://www.paws-r-sdk.com/docs/appregistry_create_application/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the application. The name must be unique in the region in
#' which you are creating the application.
#' @param description The description of the application.
#' @param tags Key-value pairs you can use to associate with the application.
#' @param clientToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If you retry
#' a request that completed successfully using the same client token and
#' the same parameters, the retry succeeds without performing any further
#' actions. If you retry a successful request using the same client token,
#' but one or more of the parameters are different, the retry fails.
#'
#' @keywords internal
#'
#' @rdname appregistry_create_application
appregistry_create_application <- function(name, description = NULL, tags = NULL, clientToken) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/applications",
    paginator = list()
  )
  input <- .appregistry$create_application_input(name = name, description = description, tags = tags, clientToken = clientToken)
  output <- .appregistry$create_application_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$create_application <- appregistry_create_application

#' Creates a new attribute group as a container for user-defined attributes
#'
#' @description
#' Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full control over their cloud application's metadata in a rich machine-readable format to facilitate integration with automated workflows and third-party tools.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_create_attribute_group/](https://www.paws-r-sdk.com/docs/appregistry_create_attribute_group/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the attribute group.
#' @param description The description of the attribute group that the user provides.
#' @param attributes &#91;required&#93; A JSON string in the form of nested key-value pairs that represent the
#' attributes in the group and describes an application and its components.
#' @param tags Key-value pairs you can use to associate with the attribute group.
#' @param clientToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If you retry
#' a request that completed successfully using the same client token and
#' the same parameters, the retry succeeds without performing any further
#' actions. If you retry a successful request using the same client token,
#' but one or more of the parameters are different, the retry fails.
#'
#' @keywords internal
#'
#' @rdname appregistry_create_attribute_group
appregistry_create_attribute_group <- function(name, description = NULL, attributes, tags = NULL, clientToken) {
  op <- new_operation(
    name = "CreateAttributeGroup",
    http_method = "POST",
    http_path = "/attribute-groups",
    paginator = list()
  )
  input <- .appregistry$create_attribute_group_input(name = name, description = description, attributes = attributes, tags = tags, clientToken = clientToken)
  output <- .appregistry$create_attribute_group_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$create_attribute_group <- appregistry_create_attribute_group

#' Deletes an application that is specified either by its application ID,
#' name, or ARN
#'
#' @description
#' Deletes an application that is specified either by its application ID, name, or ARN. All associated attribute groups and resources must be disassociated from it before deleting an application.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_delete_application/](https://www.paws-r-sdk.com/docs/appregistry_delete_application/) for full documentation.
#'
#' @param application &#91;required&#93; The name, ID, or ARN of the application.
#'
#' @keywords internal
#'
#' @rdname appregistry_delete_application
appregistry_delete_application <- function(application) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "DELETE",
    http_path = "/applications/{application}",
    paginator = list()
  )
  input <- .appregistry$delete_application_input(application = application)
  output <- .appregistry$delete_application_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$delete_application <- appregistry_delete_application

#' Deletes an attribute group, specified either by its attribute group ID,
#' name, or ARN
#'
#' @description
#' Deletes an attribute group, specified either by its attribute group ID, name, or ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_delete_attribute_group/](https://www.paws-r-sdk.com/docs/appregistry_delete_attribute_group/) for full documentation.
#'
#' @param attributeGroup &#91;required&#93; The name, ID, or ARN of the attribute group that holds the attributes to
#' describe the application.
#'
#' @keywords internal
#'
#' @rdname appregistry_delete_attribute_group
appregistry_delete_attribute_group <- function(attributeGroup) {
  op <- new_operation(
    name = "DeleteAttributeGroup",
    http_method = "DELETE",
    http_path = "/attribute-groups/{attributeGroup}",
    paginator = list()
  )
  input <- .appregistry$delete_attribute_group_input(attributeGroup = attributeGroup)
  output <- .appregistry$delete_attribute_group_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$delete_attribute_group <- appregistry_delete_attribute_group

#' Disassociates an attribute group from an application to remove the extra
#' attributes contained in the attribute group from the application's
#' metadata
#'
#' @description
#' Disassociates an attribute group from an application to remove the extra attributes contained in the attribute group from the application's metadata. This operation reverts [`associate_attribute_group`][appregistry_associate_attribute_group].
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_disassociate_attribute_group/](https://www.paws-r-sdk.com/docs/appregistry_disassociate_attribute_group/) for full documentation.
#'
#' @param application &#91;required&#93; The name, ID, or ARN of the application.
#' @param attributeGroup &#91;required&#93; The name, ID, or ARN of the attribute group that holds the attributes to
#' describe the application.
#'
#' @keywords internal
#'
#' @rdname appregistry_disassociate_attribute_group
appregistry_disassociate_attribute_group <- function(application, attributeGroup) {
  op <- new_operation(
    name = "DisassociateAttributeGroup",
    http_method = "DELETE",
    http_path = "/applications/{application}/attribute-groups/{attributeGroup}",
    paginator = list()
  )
  input <- .appregistry$disassociate_attribute_group_input(application = application, attributeGroup = attributeGroup)
  output <- .appregistry$disassociate_attribute_group_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$disassociate_attribute_group <- appregistry_disassociate_attribute_group

#' Disassociates a resource from application
#'
#' @description
#' Disassociates a resource from application. Both the resource and the application can be specified either by ID or name.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_disassociate_resource/](https://www.paws-r-sdk.com/docs/appregistry_disassociate_resource/) for full documentation.
#'
#' @param application &#91;required&#93; The name or ID of the application.
#' @param resourceType &#91;required&#93; The type of the resource that is being disassociated.
#' @param resource &#91;required&#93; The name or ID of the resource.
#'
#' @keywords internal
#'
#' @rdname appregistry_disassociate_resource
appregistry_disassociate_resource <- function(application, resourceType, resource) {
  op <- new_operation(
    name = "DisassociateResource",
    http_method = "DELETE",
    http_path = "/applications/{application}/resources/{resourceType}/{resource}",
    paginator = list()
  )
  input <- .appregistry$disassociate_resource_input(application = application, resourceType = resourceType, resource = resource)
  output <- .appregistry$disassociate_resource_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$disassociate_resource <- appregistry_disassociate_resource

#' Retrieves metadata information about one of your applications
#'
#' @description
#' Retrieves metadata information about one of your applications. The application can be specified by its ARN, ID, or name (which is unique within one account in one region at a given point in time). Specify by ARN or ID in automated workflows if you want to make sure that the exact same application is returned or a `ResourceNotFoundException` is thrown, avoiding the ABA addressing problem.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_get_application/](https://www.paws-r-sdk.com/docs/appregistry_get_application/) for full documentation.
#'
#' @param application &#91;required&#93; The name, ID, or ARN of the application.
#'
#' @keywords internal
#'
#' @rdname appregistry_get_application
appregistry_get_application <- function(application) {
  op <- new_operation(
    name = "GetApplication",
    http_method = "GET",
    http_path = "/applications/{application}",
    paginator = list()
  )
  input <- .appregistry$get_application_input(application = application)
  output <- .appregistry$get_application_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$get_application <- appregistry_get_application

#' Gets the resource associated with the application
#'
#' @description
#' Gets the resource associated with the application.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_get_associated_resource/](https://www.paws-r-sdk.com/docs/appregistry_get_associated_resource/) for full documentation.
#'
#' @param application &#91;required&#93; The name, ID, or ARN of the application.
#' @param resourceType &#91;required&#93; The type of resource associated with the application.
#' @param resource &#91;required&#93; The name or ID of the resource associated with the application.
#'
#' @keywords internal
#'
#' @rdname appregistry_get_associated_resource
appregistry_get_associated_resource <- function(application, resourceType, resource) {
  op <- new_operation(
    name = "GetAssociatedResource",
    http_method = "GET",
    http_path = "/applications/{application}/resources/{resourceType}/{resource}",
    paginator = list()
  )
  input <- .appregistry$get_associated_resource_input(application = application, resourceType = resourceType, resource = resource)
  output <- .appregistry$get_associated_resource_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$get_associated_resource <- appregistry_get_associated_resource

#' Retrieves an attribute group by its ARN, ID, or name
#'
#' @description
#' Retrieves an attribute group by its ARN, ID, or name. The attribute group can be specified by its ARN, ID, or name.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_get_attribute_group/](https://www.paws-r-sdk.com/docs/appregistry_get_attribute_group/) for full documentation.
#'
#' @param attributeGroup &#91;required&#93; The name, ID, or ARN of the attribute group that holds the attributes to
#' describe the application.
#'
#' @keywords internal
#'
#' @rdname appregistry_get_attribute_group
appregistry_get_attribute_group <- function(attributeGroup) {
  op <- new_operation(
    name = "GetAttributeGroup",
    http_method = "GET",
    http_path = "/attribute-groups/{attributeGroup}",
    paginator = list()
  )
  input <- .appregistry$get_attribute_group_input(attributeGroup = attributeGroup)
  output <- .appregistry$get_attribute_group_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$get_attribute_group <- appregistry_get_attribute_group

#' Retrieves a TagKey configuration from an account
#'
#' @description
#' Retrieves a `TagKey` configuration from an account.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_get_configuration/](https://www.paws-r-sdk.com/docs/appregistry_get_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname appregistry_get_configuration
appregistry_get_configuration <- function() {
  op <- new_operation(
    name = "GetConfiguration",
    http_method = "GET",
    http_path = "/configuration",
    paginator = list()
  )
  input <- .appregistry$get_configuration_input()
  output <- .appregistry$get_configuration_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$get_configuration <- appregistry_get_configuration

#' Retrieves a list of all of your applications
#'
#' @description
#' Retrieves a list of all of your applications. Results are paginated.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_list_applications/](https://www.paws-r-sdk.com/docs/appregistry_list_applications/) for full documentation.
#'
#' @param nextToken The token to use to get the next page of results after a previous API
#' call.
#' @param maxResults The upper bound of the number of results to return (cannot exceed 25).
#' If this parameter is omitted, it defaults to 25. This value is optional.
#'
#' @keywords internal
#'
#' @rdname appregistry_list_applications
appregistry_list_applications <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "GET",
    http_path = "/applications",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "applications")
  )
  input <- .appregistry$list_applications_input(nextToken = nextToken, maxResults = maxResults)
  output <- .appregistry$list_applications_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$list_applications <- appregistry_list_applications

#' Lists all attribute groups that are associated with specified
#' application
#'
#' @description
#' Lists all attribute groups that are associated with specified application. Results are paginated.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_list_associated_attribute_groups/](https://www.paws-r-sdk.com/docs/appregistry_list_associated_attribute_groups/) for full documentation.
#'
#' @param application &#91;required&#93; The name or ID of the application.
#' @param nextToken The token to use to get the next page of results after a previous API
#' call.
#' @param maxResults The upper bound of the number of results to return (cannot exceed 25).
#' If this parameter is omitted, it defaults to 25. This value is optional.
#'
#' @keywords internal
#'
#' @rdname appregistry_list_associated_attribute_groups
appregistry_list_associated_attribute_groups <- function(application, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssociatedAttributeGroups",
    http_method = "GET",
    http_path = "/applications/{application}/attribute-groups",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "attributeGroups")
  )
  input <- .appregistry$list_associated_attribute_groups_input(application = application, nextToken = nextToken, maxResults = maxResults)
  output <- .appregistry$list_associated_attribute_groups_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$list_associated_attribute_groups <- appregistry_list_associated_attribute_groups

#' Lists all of the resources that are associated with the specified
#' application
#'
#' @description
#' Lists all of the resources that are associated with the specified application. Results are paginated.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_list_associated_resources/](https://www.paws-r-sdk.com/docs/appregistry_list_associated_resources/) for full documentation.
#'
#' @param application &#91;required&#93; The name, ID, or ARN of the application.
#' @param nextToken The token to use to get the next page of results after a previous API
#' call.
#' @param maxResults The upper bound of the number of results to return (cannot exceed 25).
#' If this parameter is omitted, it defaults to 25. This value is optional.
#'
#' @keywords internal
#'
#' @rdname appregistry_list_associated_resources
appregistry_list_associated_resources <- function(application, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssociatedResources",
    http_method = "GET",
    http_path = "/applications/{application}/resources",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "resources")
  )
  input <- .appregistry$list_associated_resources_input(application = application, nextToken = nextToken, maxResults = maxResults)
  output <- .appregistry$list_associated_resources_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$list_associated_resources <- appregistry_list_associated_resources

#' Lists all attribute groups which you have access to
#'
#' @description
#' Lists all attribute groups which you have access to. Results are paginated.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_list_attribute_groups/](https://www.paws-r-sdk.com/docs/appregistry_list_attribute_groups/) for full documentation.
#'
#' @param nextToken The token to use to get the next page of results after a previous API
#' call.
#' @param maxResults The upper bound of the number of results to return (cannot exceed 25).
#' If this parameter is omitted, it defaults to 25. This value is optional.
#'
#' @keywords internal
#'
#' @rdname appregistry_list_attribute_groups
appregistry_list_attribute_groups <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAttributeGroups",
    http_method = "GET",
    http_path = "/attribute-groups",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "attributeGroups")
  )
  input <- .appregistry$list_attribute_groups_input(nextToken = nextToken, maxResults = maxResults)
  output <- .appregistry$list_attribute_groups_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$list_attribute_groups <- appregistry_list_attribute_groups

#' Lists the details of all attribute groups associated with a specific
#' application
#'
#' @description
#' Lists the details of all attribute groups associated with a specific application. The results display in pages.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_list_attribute_groups_for_application/](https://www.paws-r-sdk.com/docs/appregistry_list_attribute_groups_for_application/) for full documentation.
#'
#' @param application &#91;required&#93; The name or ID of the application.
#' @param nextToken This token retrieves the next page of results after a previous API call.
#' @param maxResults The upper bound of the number of results to return. The value cannot
#' exceed 25. If you omit this parameter, it defaults to 25. This value is
#' optional.
#'
#' @keywords internal
#'
#' @rdname appregistry_list_attribute_groups_for_application
appregistry_list_attribute_groups_for_application <- function(application, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAttributeGroupsForApplication",
    http_method = "GET",
    http_path = "/applications/{application}/attribute-group-details",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "attributeGroupsDetails")
  )
  input <- .appregistry$list_attribute_groups_for_application_input(application = application, nextToken = nextToken, maxResults = maxResults)
  output <- .appregistry$list_attribute_groups_for_application_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$list_attribute_groups_for_application <- appregistry_list_attribute_groups_for_application

#' Lists all of the tags on the resource
#'
#' @description
#' Lists all of the tags on the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/appregistry_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon resource name (ARN) that specifies the resource.
#'
#' @keywords internal
#'
#' @rdname appregistry_list_tags_for_resource
appregistry_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .appregistry$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .appregistry$list_tags_for_resource_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$list_tags_for_resource <- appregistry_list_tags_for_resource

#' Associates a TagKey configuration to an account
#'
#' @description
#' Associates a `TagKey` configuration to an account.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_put_configuration/](https://www.paws-r-sdk.com/docs/appregistry_put_configuration/) for full documentation.
#'
#' @param configuration &#91;required&#93; Associates a `TagKey` configuration to an account.
#'
#' @keywords internal
#'
#' @rdname appregistry_put_configuration
appregistry_put_configuration <- function(configuration) {
  op <- new_operation(
    name = "PutConfiguration",
    http_method = "PUT",
    http_path = "/configuration",
    paginator = list()
  )
  input <- .appregistry$put_configuration_input(configuration = configuration)
  output <- .appregistry$put_configuration_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$put_configuration <- appregistry_put_configuration

#' Syncs the resource with current AppRegistry records
#'
#' @description
#' Syncs the resource with current AppRegistry records.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_sync_resource/](https://www.paws-r-sdk.com/docs/appregistry_sync_resource/) for full documentation.
#'
#' @param resourceType &#91;required&#93; The type of resource of which the application will be associated.
#' @param resource &#91;required&#93; An entity you can work with and specify with a name or ID. Examples
#' include an Amazon EC2 instance, an Amazon Web Services CloudFormation
#' stack, or an Amazon S3 bucket.
#'
#' @keywords internal
#'
#' @rdname appregistry_sync_resource
appregistry_sync_resource <- function(resourceType, resource) {
  op <- new_operation(
    name = "SyncResource",
    http_method = "POST",
    http_path = "/sync/{resourceType}/{resource}",
    paginator = list()
  )
  input <- .appregistry$sync_resource_input(resourceType = resourceType, resource = resource)
  output <- .appregistry$sync_resource_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$sync_resource <- appregistry_sync_resource

#' Assigns one or more tags (key-value pairs) to the specified resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_tag_resource/](https://www.paws-r-sdk.com/docs/appregistry_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon resource name (ARN) that specifies the resource.
#' @param tags &#91;required&#93; The new or modified tags for the resource.
#'
#' @keywords internal
#'
#' @rdname appregistry_tag_resource
appregistry_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .appregistry$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .appregistry$tag_resource_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$tag_resource <- appregistry_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_untag_resource/](https://www.paws-r-sdk.com/docs/appregistry_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon resource name (ARN) that specifies the resource.
#' @param tagKeys &#91;required&#93; A list of the tag keys to remove from the specified resource.
#'
#' @keywords internal
#'
#' @rdname appregistry_untag_resource
appregistry_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .appregistry$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .appregistry$untag_resource_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$untag_resource <- appregistry_untag_resource

#' Updates an existing application with new attributes
#'
#' @description
#' Updates an existing application with new attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_update_application/](https://www.paws-r-sdk.com/docs/appregistry_update_application/) for full documentation.
#'
#' @param application &#91;required&#93; The name, ID, or ARN of the application that will be updated.
#' @param name Deprecated: The new name of the application. The name must be unique in
#' the region in which you are updating the application. Please do not use
#' this field as we have stopped supporting name updates.
#' @param description The new description of the application.
#'
#' @keywords internal
#'
#' @rdname appregistry_update_application
appregistry_update_application <- function(application, name = NULL, description = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "PATCH",
    http_path = "/applications/{application}",
    paginator = list()
  )
  input <- .appregistry$update_application_input(application = application, name = name, description = description)
  output <- .appregistry$update_application_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$update_application <- appregistry_update_application

#' Updates an existing attribute group with new details
#'
#' @description
#' Updates an existing attribute group with new details.
#'
#' See [https://www.paws-r-sdk.com/docs/appregistry_update_attribute_group/](https://www.paws-r-sdk.com/docs/appregistry_update_attribute_group/) for full documentation.
#'
#' @param attributeGroup &#91;required&#93; The name, ID, or ARN of the attribute group that holds the attributes to
#' describe the application.
#' @param name Deprecated: The new name of the attribute group. The name must be unique
#' in the region in which you are updating the attribute group. Please do
#' not use this field as we have stopped supporting name updates.
#' @param description The description of the attribute group that the user provides.
#' @param attributes A JSON string in the form of nested key-value pairs that represent the
#' attributes in the group and describes an application and its components.
#'
#' @keywords internal
#'
#' @rdname appregistry_update_attribute_group
appregistry_update_attribute_group <- function(attributeGroup, name = NULL, description = NULL, attributes = NULL) {
  op <- new_operation(
    name = "UpdateAttributeGroup",
    http_method = "PATCH",
    http_path = "/attribute-groups/{attributeGroup}",
    paginator = list()
  )
  input <- .appregistry$update_attribute_group_input(attributeGroup = attributeGroup, name = name, description = description, attributes = attributes)
  output <- .appregistry$update_attribute_group_output()
  config <- get_config()
  svc <- .appregistry$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appregistry$operations$update_attribute_group <- appregistry_update_attribute_group
