% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_put_resource_policy}
\alias{cloudtrail_put_resource_policy}
\title{Attaches a resource-based permission policy to a CloudTrail channel that
is used for an integration with an event source outside of Amazon Web
Services}
\usage{
cloudtrail_put_resource_policy(ResourceArn, ResourcePolicy)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the CloudTrail channel attached to the
resource-based policy. The following is the format of a resource ARN:
\code{arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel}.}

\item{ResourcePolicy}{[required] A JSON-formatted string for an Amazon Web Services resource-based
policy.

The following are requirements for the resource policy:
\itemize{
\item Contains only one action: cloudtrail-data:PutAuditEvents
\item Contains at least one statement. The policy can have a maximum of 20
statements.
\item Each statement contains at least one principal. A statement can have
a maximum of 50 principals.
}}
}
\description{
Attaches a resource-based permission policy to a CloudTrail channel that is used for an integration with an event source outside of Amazon Web Services. For more information about resource-based policies, see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html}{CloudTrail resource-based policy examples} in the \emph{CloudTrail User Guide}.

See \url{https://www.paws-r-sdk.com/docs/cloudtrail_put_resource_policy/} for full documentation.
}
\keyword{internal}
