% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchrum_operations.R
\name{cloudwatchrum_put_rum_events}
\alias{cloudwatchrum_put_rum_events}
\title{Sends telemetry events about your application performance and user
behavior to CloudWatch RUM}
\usage{
cloudwatchrum_put_rum_events(
  AppMonitorDetails,
  BatchId,
  Id,
  RumEvents,
  UserDetails
)
}
\arguments{
\item{AppMonitorDetails}{[required] A structure that contains information about the app monitor that
collected this telemetry information.}

\item{BatchId}{[required] A unique identifier for this batch of RUM event data.}

\item{Id}{[required] The ID of the app monitor that is sending this data.}

\item{RumEvents}{[required] An array of structures that contain the telemetry event data.}

\item{UserDetails}{[required] A structure that contains information about the user session that this
batch of events was collected from.}
}
\description{
Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code snippet that RUM generates for you to add to your application includes \code{\link[=cloudwatchrum_put_rum_events]{put_rum_events}} operations to send this data to RUM.

See \url{https://paws-r.github.io/docs/cloudwatchrum/put_rum_events.html} for full documentation.
}
\keyword{internal}
