% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_query_definition}
\alias{cloudwatchlogs_put_query_definition}
\title{Creates or updates a query definition for CloudWatch Logs Insights}
\usage{
cloudwatchlogs_put_query_definition(
  name,
  queryDefinitionId = NULL,
  logGroupNames = NULL,
  queryString
)
}
\arguments{
\item{name}{[required] A name for the query definition. If you are saving a lot of query
definitions, we recommend that you name them so that you can easily find
the ones you want by using the first part of the name as a filter in the
\code{queryDefinitionNamePrefix} parameter of
\code{\link[=cloudwatchlogs_describe_query_definitions]{describe_query_definitions}}.}

\item{queryDefinitionId}{If you are updating a query definition, use this parameter to specify
the ID of the query definition that you want to update. You can use
\code{\link[=cloudwatchlogs_describe_query_definitions]{describe_query_definitions}}
to retrieve the IDs of your saved query definitions.

If you are creating a query definition, do not specify this parameter.
CloudWatch generates a unique ID for the new query definition and
include it in the response to this operation.}

\item{logGroupNames}{Use this parameter to include specific log groups as part of your query
definition.

If you are updating a query definition and you omit this parameter, then
the updated definition will contain no log groups.}

\item{queryString}{[required] The query string to use for this definition. For more information, see
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html}{CloudWatch Logs Insights Query Syntax}.}
}
\description{
Creates or updates a query definition for CloudWatch Logs Insights. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html}{Analyzing Log Data with CloudWatch Logs Insights}.

See \url{https://paws-r.github.io/docs/cloudwatchlogs/put_query_definition.html} for full documentation.
}
\keyword{internal}
