% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_get_log_group_fields}
\alias{cloudwatchlogs_get_log_group_fields}
\title{Returns a list of the fields that are included in log events in the
specified log group, along with the percentage of log events that
contain each field}
\usage{
cloudwatchlogs_get_log_group_fields(logGroupName, time = NULL)
}
\arguments{
\item{logGroupName}{[required] The name of the log group to search.}

\item{time}{The time to set as the center of the query. If you specify \code{time}, the
15 minutes before this time are queries. If you omit \code{time} the 8
minutes before and 8 minutes after this time are searched.

The \code{time} value is specified as epoch time, the number of seconds since
January 1, 1970, 00:00:00 UTC.}
}
\description{
Returns a list of the fields that are included in log events in the specified log group, along with the percentage of log events that contain each field. The search is limited to a time period that you specify.

See \url{https://paws-r.github.io/docs/cloudwatchlogs/get_log_group_fields.html} for full documentation.
}
\keyword{internal}
