% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_put_rule}
\alias{cloudwatchevents_put_rule}
\title{Creates or updates the specified rule}
\usage{
cloudwatchevents_put_rule(
  Name,
  ScheduleExpression = NULL,
  EventPattern = NULL,
  State = NULL,
  Description = NULL,
  RoleArn = NULL,
  Tags = NULL,
  EventBusName = NULL
)
}
\arguments{
\item{Name}{[required] The name of the rule that you are creating or updating.}

\item{ScheduleExpression}{The scheduling expression. For example, "cron(0 20 * * ? *)" or
"rate(5 minutes)".}

\item{EventPattern}{The event pattern. For more information, see \href{https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html}{Events and Event Patterns}
in the \emph{Amazon EventBridge User Guide}.}

\item{State}{Indicates whether the rule is enabled or disabled.}

\item{Description}{A description of the rule.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the IAM role associated with the rule.

If you're setting an event bus in another account as the target and that
account granted permission to your account through an organization
instead of directly by the account ID, you must specify a \code{RoleArn} with
proper permissions in the \code{Target} structure, instead of here in this
parameter.}

\item{Tags}{The list of key-value pairs to associate with the rule.}

\item{EventBusName}{The name or ARN of the event bus to associate with this rule. If you
omit this, the default event bus is used.}
}
\description{
Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using \code{\link[=cloudwatchevents_disable_rule]{disable_rule}}.

See \url{https://paws-r.github.io/docs/cloudwatchevents/put_rule.html} for full documentation.
}
\keyword{internal}
