# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include resiliencehub_service.R
NULL

#' Adds the resource mapping for the draft application version
#'
#' @description
#' Adds the resource mapping for the draft application version.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/add_draft_app_version_resource_mappings.html](https://paws-r.github.io/docs/resiliencehub/add_draft_app_version_resource_mappings.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param resourceMappings &#91;required&#93; Mappings used to map logical resources from the template to physical
#' resources. You can use the mapping type `CFN_STACK` if the application
#' template uses a logical stack name. Or you can map individual resources
#' by using the mapping type `RESOURCE`. We recommend using the mapping
#' type `CFN_STACK` if the application is backed by a CloudFormation stack.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_add_draft_app_version_resource_mappings
resiliencehub_add_draft_app_version_resource_mappings <- function(appArn, resourceMappings) {
  op <- new_operation(
    name = "AddDraftAppVersionResourceMappings",
    http_method = "POST",
    http_path = "/add-draft-app-version-resource-mappings",
    paginator = list()
  )
  input <- .resiliencehub$add_draft_app_version_resource_mappings_input(appArn = appArn, resourceMappings = resourceMappings)
  output <- .resiliencehub$add_draft_app_version_resource_mappings_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$add_draft_app_version_resource_mappings <- resiliencehub_add_draft_app_version_resource_mappings

#' Creates a Resilience Hub application
#'
#' @description
#' Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks, and an appropriate resiliency policy.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/create_app.html](https://paws-r.github.io/docs/resiliencehub/create_app.html) for full documentation.
#'
#' @param assessmentSchedule Assessment execution schedule with 'Daily' or 'Disabled' values.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param description The optional description for an app.
#' @param name &#91;required&#93; The name for the application.
#' @param policyArn The Amazon Resource Name (ARN) of the resiliency policy. The format for
#' this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param tags The tags assigned to the resource. A tag is a label that you assign to
#' an Amazon Web Services resource. Each tag consists of a key/value pair.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_create_app
resiliencehub_create_app <- function(assessmentSchedule = NULL, clientToken = NULL, description = NULL, name, policyArn = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/create-app",
    paginator = list()
  )
  input <- .resiliencehub$create_app_input(assessmentSchedule = assessmentSchedule, clientToken = clientToken, description = description, name = name, policyArn = policyArn, tags = tags)
  output <- .resiliencehub$create_app_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$create_app <- resiliencehub_create_app

#' Creates a new recommendation template
#'
#' @description
#' Creates a new recommendation template.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/create_recommendation_template.html](https://paws-r.github.io/docs/resiliencehub/create_recommendation_template.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param bucketName The name of the Amazon S3 bucket that will contain the recommendation
#' template.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param format The format for the recommendation template.
#' 
#' **CfnJson**
#' 
#' The template is CloudFormation JSON.
#' 
#' **CfnYaml**
#' 
#' The template is CloudFormation YAML.
#' @param name &#91;required&#93; The name for the recommendation template.
#' @param recommendationIds Identifiers for the recommendations used to create a recommendation
#' template.
#' @param recommendationTypes An array of strings that specify the recommendation template type or
#' types.
#' 
#' **Alarm**
#' 
#' The template is an AlarmRecommendation template.
#' 
#' **Sop**
#' 
#' The template is a SopRecommendation template.
#' 
#' **Test**
#' 
#' The template is a TestRecommendation template.
#' @param tags The tags assigned to the resource. A tag is a label that you assign to
#' an Amazon Web Services resource. Each tag consists of a key/value pair.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_create_recommendation_template
resiliencehub_create_recommendation_template <- function(assessmentArn, bucketName = NULL, clientToken = NULL, format = NULL, name, recommendationIds = NULL, recommendationTypes = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRecommendationTemplate",
    http_method = "POST",
    http_path = "/create-recommendation-template",
    paginator = list()
  )
  input <- .resiliencehub$create_recommendation_template_input(assessmentArn = assessmentArn, bucketName = bucketName, clientToken = clientToken, format = format, name = name, recommendationIds = recommendationIds, recommendationTypes = recommendationTypes, tags = tags)
  output <- .resiliencehub$create_recommendation_template_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$create_recommendation_template <- resiliencehub_create_recommendation_template

#' Creates a resiliency policy for an application
#'
#' @description
#' Creates a resiliency policy for an application.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/create_resiliency_policy.html](https://paws-r.github.io/docs/resiliencehub/create_resiliency_policy.html) for full documentation.
#'
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param dataLocationConstraint Specifies a high-level geographical location constraint for where your
#' resilience policy data can be stored.
#' @param policy &#91;required&#93; The type of resiliency policy to be created, including the recovery time
#' objective (RTO) and recovery point objective (RPO) in seconds.
#' @param policyDescription The description for the policy.
#' @param policyName &#91;required&#93; The name of the policy
#' @param tags The tags assigned to the resource. A tag is a label that you assign to
#' an Amazon Web Services resource. Each tag consists of a key/value pair.
#' @param tier &#91;required&#93; The tier for this resiliency policy, ranging from the highest severity
#' (`MissionCritical`) to lowest (`NonCritical`).
#'
#' @keywords internal
#'
#' @rdname resiliencehub_create_resiliency_policy
resiliencehub_create_resiliency_policy <- function(clientToken = NULL, dataLocationConstraint = NULL, policy, policyDescription = NULL, policyName, tags = NULL, tier) {
  op <- new_operation(
    name = "CreateResiliencyPolicy",
    http_method = "POST",
    http_path = "/create-resiliency-policy",
    paginator = list()
  )
  input <- .resiliencehub$create_resiliency_policy_input(clientToken = clientToken, dataLocationConstraint = dataLocationConstraint, policy = policy, policyDescription = policyDescription, policyName = policyName, tags = tags, tier = tier)
  output <- .resiliencehub$create_resiliency_policy_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$create_resiliency_policy <- resiliencehub_create_resiliency_policy

#' Deletes an AWS Resilience Hub application
#'
#' @description
#' Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/delete_app.html](https://paws-r.github.io/docs/resiliencehub/delete_app.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param forceDelete A boolean option to force the deletion of a Resilience Hub application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_app
resiliencehub_delete_app <- function(appArn, clientToken = NULL, forceDelete = NULL) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "POST",
    http_path = "/delete-app",
    paginator = list()
  )
  input <- .resiliencehub$delete_app_input(appArn = appArn, clientToken = clientToken, forceDelete = forceDelete)
  output <- .resiliencehub$delete_app_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_app <- resiliencehub_delete_app

#' Deletes an AWS Resilience Hub application assessment
#'
#' @description
#' Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/delete_app_assessment.html](https://paws-r.github.io/docs/resiliencehub/delete_app_assessment.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_app_assessment
resiliencehub_delete_app_assessment <- function(assessmentArn, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteAppAssessment",
    http_method = "POST",
    http_path = "/delete-app-assessment",
    paginator = list()
  )
  input <- .resiliencehub$delete_app_assessment_input(assessmentArn = assessmentArn, clientToken = clientToken)
  output <- .resiliencehub$delete_app_assessment_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_app_assessment <- resiliencehub_delete_app_assessment

#' Deletes a recommendation template
#'
#' @description
#' Deletes a recommendation template. This is a destructive action that can't be undone.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/delete_recommendation_template.html](https://paws-r.github.io/docs/resiliencehub/delete_recommendation_template.html) for full documentation.
#'
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param recommendationTemplateArn &#91;required&#93; The Amazon Resource Name (ARN) for a recommendation template.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_recommendation_template
resiliencehub_delete_recommendation_template <- function(clientToken = NULL, recommendationTemplateArn) {
  op <- new_operation(
    name = "DeleteRecommendationTemplate",
    http_method = "POST",
    http_path = "/delete-recommendation-template",
    paginator = list()
  )
  input <- .resiliencehub$delete_recommendation_template_input(clientToken = clientToken, recommendationTemplateArn = recommendationTemplateArn)
  output <- .resiliencehub$delete_recommendation_template_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_recommendation_template <- resiliencehub_delete_recommendation_template

#' Deletes a resiliency policy
#'
#' @description
#' Deletes a resiliency policy. This is a destructive action that can't be undone.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/delete_resiliency_policy.html](https://paws-r.github.io/docs/resiliencehub/delete_resiliency_policy.html) for full documentation.
#'
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param policyArn &#91;required&#93; The Amazon Resource Name (ARN) of the resiliency policy. The format for
#' this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_delete_resiliency_policy
resiliencehub_delete_resiliency_policy <- function(clientToken = NULL, policyArn) {
  op <- new_operation(
    name = "DeleteResiliencyPolicy",
    http_method = "POST",
    http_path = "/delete-resiliency-policy",
    paginator = list()
  )
  input <- .resiliencehub$delete_resiliency_policy_input(clientToken = clientToken, policyArn = policyArn)
  output <- .resiliencehub$delete_resiliency_policy_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$delete_resiliency_policy <- resiliencehub_delete_resiliency_policy

#' Describes an AWS Resilience Hub application
#'
#' @description
#' Describes an AWS Resilience Hub application.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/describe_app.html](https://paws-r.github.io/docs/resiliencehub/describe_app.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app
resiliencehub_describe_app <- function(appArn) {
  op <- new_operation(
    name = "DescribeApp",
    http_method = "POST",
    http_path = "/describe-app",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_input(appArn = appArn)
  output <- .resiliencehub$describe_app_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app <- resiliencehub_describe_app

#' Describes an assessment for an AWS Resilience Hub application
#'
#' @description
#' Describes an assessment for an AWS Resilience Hub application.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/describe_app_assessment.html](https://paws-r.github.io/docs/resiliencehub/describe_app_assessment.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app_assessment
resiliencehub_describe_app_assessment <- function(assessmentArn) {
  op <- new_operation(
    name = "DescribeAppAssessment",
    http_method = "POST",
    http_path = "/describe-app-assessment",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_assessment_input(assessmentArn = assessmentArn)
  output <- .resiliencehub$describe_app_assessment_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_assessment <- resiliencehub_describe_app_assessment

#' Returns the resolution status for the specified resolution identifier
#' for an application version
#'
#' @description
#' Returns the resolution status for the specified resolution identifier for an application version. If `resolutionId` is not specified, the current resolution status is returned.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/describe_app_version_resources_resolution_status.html](https://paws-r.github.io/docs/resiliencehub/describe_app_version_resources_resolution_status.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param resolutionId The identifier for a specific resolution.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_descri_app_versio_resour_resolu_status
resiliencehub_describe_app_version_resources_resolution_status <- function(appArn, appVersion, resolutionId = NULL) {
  op <- new_operation(
    name = "DescribeAppVersionResourcesResolutionStatus",
    http_method = "POST",
    http_path = "/describe-app-version-resources-resolution-status",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_version_resources_resolution_status_input(appArn = appArn, appVersion = appVersion, resolutionId = resolutionId)
  output <- .resiliencehub$describe_app_version_resources_resolution_status_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_version_resources_resolution_status <- resiliencehub_describe_app_version_resources_resolution_status

#' Describes details about an AWS Resilience Hub
#'
#' @description
#' Describes details about an AWS Resilience Hub
#'
#' See [https://paws-r.github.io/docs/resiliencehub/describe_app_version_template.html](https://paws-r.github.io/docs/resiliencehub/describe_app_version_template.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appVersion &#91;required&#93; The version of the application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_app_version_template
resiliencehub_describe_app_version_template <- function(appArn, appVersion) {
  op <- new_operation(
    name = "DescribeAppVersionTemplate",
    http_method = "POST",
    http_path = "/describe-app-version-template",
    paginator = list()
  )
  input <- .resiliencehub$describe_app_version_template_input(appArn = appArn, appVersion = appVersion)
  output <- .resiliencehub$describe_app_version_template_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_app_version_template <- resiliencehub_describe_app_version_template

#' Describes the status of importing resources to an application version
#'
#' @description
#' Describes the status of importing resources to an application version.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/describe_draft_app_version_resources_import_status.html](https://paws-r.github.io/docs/resiliencehub/describe_draft_app_version_resources_import_status.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_descr_draft_app_versi_resou_impor_statu
resiliencehub_describe_draft_app_version_resources_import_status <- function(appArn) {
  op <- new_operation(
    name = "DescribeDraftAppVersionResourcesImportStatus",
    http_method = "POST",
    http_path = "/describe-draft-app-version-resources-import-status",
    paginator = list()
  )
  input <- .resiliencehub$describe_draft_app_version_resources_import_status_input(appArn = appArn)
  output <- .resiliencehub$describe_draft_app_version_resources_import_status_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_draft_app_version_resources_import_status <- resiliencehub_describe_draft_app_version_resources_import_status

#' Describes a specified resiliency policy for an AWS Resilience Hub
#' application
#'
#' @description
#' Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/describe_resiliency_policy.html](https://paws-r.github.io/docs/resiliencehub/describe_resiliency_policy.html) for full documentation.
#'
#' @param policyArn &#91;required&#93; The Amazon Resource Name (ARN) of the resiliency policy. The format for
#' this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_describe_resiliency_policy
resiliencehub_describe_resiliency_policy <- function(policyArn) {
  op <- new_operation(
    name = "DescribeResiliencyPolicy",
    http_method = "POST",
    http_path = "/describe-resiliency-policy",
    paginator = list()
  )
  input <- .resiliencehub$describe_resiliency_policy_input(policyArn = policyArn)
  output <- .resiliencehub$describe_resiliency_policy_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$describe_resiliency_policy <- resiliencehub_describe_resiliency_policy

#' Imports resources from sources such as a CloudFormation stack,
#' resource-groups, or application registry app to a draft application
#' version
#'
#' @description
#' Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a draft application version.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/import_resources_to_draft_app_version.html](https://paws-r.github.io/docs/resiliencehub/import_resources_to_draft_app_version.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param sourceArns The Amazon Resource Names (ARNs) for the resources that you want to
#' import.
#' @param terraformSources A list of terraform file s3 URLs you need to import.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_import_resources_to_draft_app_version
resiliencehub_import_resources_to_draft_app_version <- function(appArn, sourceArns = NULL, terraformSources = NULL) {
  op <- new_operation(
    name = "ImportResourcesToDraftAppVersion",
    http_method = "POST",
    http_path = "/import-resources-to-draft-app-version",
    paginator = list()
  )
  input <- .resiliencehub$import_resources_to_draft_app_version_input(appArn = appArn, sourceArns = sourceArns, terraformSources = terraformSources)
  output <- .resiliencehub$import_resources_to_draft_app_version_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$import_resources_to_draft_app_version <- resiliencehub_import_resources_to_draft_app_version

#' Lists the alarm recommendations for a AWS Resilience Hub application
#'
#' @description
#' Lists the alarm recommendations for a AWS Resilience Hub application.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_alarm_recommendations.html](https://paws-r.github.io/docs/resiliencehub/list_alarm_recommendations.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_alarm_recommendations
resiliencehub_list_alarm_recommendations <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAlarmRecommendations",
    http_method = "POST",
    http_path = "/list-alarm-recommendations",
    paginator = list()
  )
  input <- .resiliencehub$list_alarm_recommendations_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_alarm_recommendations_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_alarm_recommendations <- resiliencehub_list_alarm_recommendations

#' Lists the assessments for an AWS Resilience Hub application
#'
#' @description
#' Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results for the response object.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_app_assessments.html](https://paws-r.github.io/docs/resiliencehub/list_app_assessments.html) for full documentation.
#'
#' @param appArn The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param assessmentName The name for the assessment.
#' @param assessmentStatus The current status of the assessment for the resiliency policy.
#' @param complianceStatus The current status of compliance for the resiliency policy.
#' @param invoker Specifies the entity that invoked a specific assessment, either a `User`
#' or the `System`.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param reverseOrder The default is to sort by ascending **startTime**. To sort by descending
#' **startTime**, set reverseOrder to `true`.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_assessments
resiliencehub_list_app_assessments <- function(appArn = NULL, assessmentName = NULL, assessmentStatus = NULL, complianceStatus = NULL, invoker = NULL, maxResults = NULL, nextToken = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListAppAssessments",
    http_method = "GET",
    http_path = "/list-app-assessments",
    paginator = list()
  )
  input <- .resiliencehub$list_app_assessments_input(appArn = appArn, assessmentName = assessmentName, assessmentStatus = assessmentStatus, complianceStatus = complianceStatus, invoker = invoker, maxResults = maxResults, nextToken = nextToken, reverseOrder = reverseOrder)
  output <- .resiliencehub$list_app_assessments_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_assessments <- resiliencehub_list_app_assessments

#' Lists the compliances for an AWS Resilience Hub component
#'
#' @description
#' Lists the compliances for an AWS Resilience Hub component.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_app_component_compliances.html](https://paws-r.github.io/docs/resiliencehub/list_app_component_compliances.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_component_compliances
resiliencehub_list_app_component_compliances <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppComponentCompliances",
    http_method = "POST",
    http_path = "/list-app-component-compliances",
    paginator = list()
  )
  input <- .resiliencehub$list_app_component_compliances_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_component_compliances_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_component_compliances <- resiliencehub_list_app_component_compliances

#' Lists the recommendations for an AWS Resilience Hub component
#'
#' @description
#' Lists the recommendations for an AWS Resilience Hub component.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_app_component_recommendations.html](https://paws-r.github.io/docs/resiliencehub/list_app_component_recommendations.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_component_recommendations
resiliencehub_list_app_component_recommendations <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppComponentRecommendations",
    http_method = "POST",
    http_path = "/list-app-component-recommendations",
    paginator = list()
  )
  input <- .resiliencehub$list_app_component_recommendations_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_component_recommendations_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_component_recommendations <- resiliencehub_list_app_component_recommendations

#' Lists how the resources in an application version are mapped/sourced
#' from
#'
#' @description
#' Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_app_version_resource_mappings.html](https://paws-r.github.io/docs/resiliencehub/list_app_version_resource_mappings.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_version_resource_mappings
resiliencehub_list_app_version_resource_mappings <- function(appArn, appVersion, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppVersionResourceMappings",
    http_method = "POST",
    http_path = "/list-app-version-resource-mappings",
    paginator = list()
  )
  input <- .resiliencehub$list_app_version_resource_mappings_input(appArn = appArn, appVersion = appVersion, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_version_resource_mappings_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_version_resource_mappings <- resiliencehub_list_app_version_resource_mappings

#' Lists all the resources in an application version
#'
#' @description
#' Lists all the resources in an application version.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_app_version_resources.html](https://paws-r.github.io/docs/resiliencehub/list_app_version_resources.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param resolutionId The identifier for a specific resolution.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_version_resources
resiliencehub_list_app_version_resources <- function(appArn, appVersion, maxResults = NULL, nextToken = NULL, resolutionId = NULL) {
  op <- new_operation(
    name = "ListAppVersionResources",
    http_method = "POST",
    http_path = "/list-app-version-resources",
    paginator = list()
  )
  input <- .resiliencehub$list_app_version_resources_input(appArn = appArn, appVersion = appVersion, maxResults = maxResults, nextToken = nextToken, resolutionId = resolutionId)
  output <- .resiliencehub$list_app_version_resources_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_version_resources <- resiliencehub_list_app_version_resources

#' Lists the different versions for the Resilience Hub applications
#'
#' @description
#' Lists the different versions for the Resilience Hub applications.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_app_versions.html](https://paws-r.github.io/docs/resiliencehub/list_app_versions.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_app_versions
resiliencehub_list_app_versions <- function(appArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppVersions",
    http_method = "POST",
    http_path = "/list-app-versions",
    paginator = list()
  )
  input <- .resiliencehub$list_app_versions_input(appArn = appArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_app_versions_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_app_versions <- resiliencehub_list_app_versions

#' Lists your Resilience Hub applications
#'
#' @description
#' Lists your Resilience Hub applications.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_apps.html](https://paws-r.github.io/docs/resiliencehub/list_apps.html) for full documentation.
#'
#' @param appArn The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param name The name for the one of the listed applications.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_apps
resiliencehub_list_apps <- function(appArn = NULL, maxResults = NULL, name = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListApps",
    http_method = "GET",
    http_path = "/list-apps",
    paginator = list()
  )
  input <- .resiliencehub$list_apps_input(appArn = appArn, maxResults = maxResults, name = name, nextToken = nextToken)
  output <- .resiliencehub$list_apps_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_apps <- resiliencehub_list_apps

#' Lists the recommendation templates for the Resilience Hub applications
#'
#' @description
#' Lists the recommendation templates for the Resilience Hub applications.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_recommendation_templates.html](https://paws-r.github.io/docs/resiliencehub/list_recommendation_templates.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param name The name for one of the listed recommendation templates.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param recommendationTemplateArn The Amazon Resource Name (ARN) for a recommendation template.
#' @param reverseOrder The default is to sort by ascending **startTime**. To sort by descending
#' **startTime**, set reverseOrder to `true`.
#' @param status The status of the action.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_recommendation_templates
resiliencehub_list_recommendation_templates <- function(assessmentArn, maxResults = NULL, name = NULL, nextToken = NULL, recommendationTemplateArn = NULL, reverseOrder = NULL, status = NULL) {
  op <- new_operation(
    name = "ListRecommendationTemplates",
    http_method = "GET",
    http_path = "/list-recommendation-templates",
    paginator = list()
  )
  input <- .resiliencehub$list_recommendation_templates_input(assessmentArn = assessmentArn, maxResults = maxResults, name = name, nextToken = nextToken, recommendationTemplateArn = recommendationTemplateArn, reverseOrder = reverseOrder, status = status)
  output <- .resiliencehub$list_recommendation_templates_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_recommendation_templates <- resiliencehub_list_recommendation_templates

#' Lists the resiliency policies for the Resilience Hub applications
#'
#' @description
#' Lists the resiliency policies for the Resilience Hub applications.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_resiliency_policies.html](https://paws-r.github.io/docs/resiliencehub/list_resiliency_policies.html) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param policyName The name of the policy
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_resiliency_policies
resiliencehub_list_resiliency_policies <- function(maxResults = NULL, nextToken = NULL, policyName = NULL) {
  op <- new_operation(
    name = "ListResiliencyPolicies",
    http_method = "GET",
    http_path = "/list-resiliency-policies",
    paginator = list()
  )
  input <- .resiliencehub$list_resiliency_policies_input(maxResults = maxResults, nextToken = nextToken, policyName = policyName)
  output <- .resiliencehub$list_resiliency_policies_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_resiliency_policies <- resiliencehub_list_resiliency_policies

#' Lists the standard operating procedure (SOP) recommendations for the
#' Resilience Hub applications
#'
#' @description
#' Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_sop_recommendations.html](https://paws-r.github.io/docs/resiliencehub/list_sop_recommendations.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_sop_recommendations
resiliencehub_list_sop_recommendations <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSopRecommendations",
    http_method = "POST",
    http_path = "/list-sop-recommendations",
    paginator = list()
  )
  input <- .resiliencehub$list_sop_recommendations_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_sop_recommendations_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_sop_recommendations <- resiliencehub_list_sop_recommendations

#' Lists the suggested resiliency policies for the Resilience Hub
#' applications
#'
#' @description
#' Lists the suggested resiliency policies for the Resilience Hub applications.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_suggested_resiliency_policies.html](https://paws-r.github.io/docs/resiliencehub/list_suggested_resiliency_policies.html) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_suggested_resiliency_policies
resiliencehub_list_suggested_resiliency_policies <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSuggestedResiliencyPolicies",
    http_method = "GET",
    http_path = "/list-suggested-resiliency-policies",
    paginator = list()
  )
  input <- .resiliencehub$list_suggested_resiliency_policies_input(maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_suggested_resiliency_policies_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_suggested_resiliency_policies <- resiliencehub_list_suggested_resiliency_policies

#' Lists the tags for your resources in your Resilience Hub applications
#'
#' @description
#' Lists the tags for your resources in your Resilience Hub applications.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_tags_for_resource.html](https://paws-r.github.io/docs/resiliencehub/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for a specific resource in your
#' Resilience Hub application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_tags_for_resource
resiliencehub_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .resiliencehub$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .resiliencehub$list_tags_for_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_tags_for_resource <- resiliencehub_list_tags_for_resource

#' Lists the test recommendations for the Resilience Hub application
#'
#' @description
#' Lists the test recommendations for the Resilience Hub application.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_test_recommendations.html](https://paws-r.github.io/docs/resiliencehub/list_test_recommendations.html) for full documentation.
#'
#' @param assessmentArn &#91;required&#93; The Amazon Resource Name (ARN) of the assessment. The format for this
#' ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_test_recommendations
resiliencehub_list_test_recommendations <- function(assessmentArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTestRecommendations",
    http_method = "POST",
    http_path = "/list-test-recommendations",
    paginator = list()
  )
  input <- .resiliencehub$list_test_recommendations_input(assessmentArn = assessmentArn, maxResults = maxResults, nextToken = nextToken)
  output <- .resiliencehub$list_test_recommendations_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_test_recommendations <- resiliencehub_list_test_recommendations

#' Lists the resources that are not currently supported in AWS Resilience
#' Hub
#'
#' @description
#' Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/list_unsupported_app_version_resources.html](https://paws-r.github.io/docs/resiliencehub/list_unsupported_app_version_resources.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param maxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param nextToken Null, or the token from a previous call to get the next set of results.
#' @param resolutionId The identifier for a specific resolution.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_list_unsupported_app_version_resources
resiliencehub_list_unsupported_app_version_resources <- function(appArn, appVersion, maxResults = NULL, nextToken = NULL, resolutionId = NULL) {
  op <- new_operation(
    name = "ListUnsupportedAppVersionResources",
    http_method = "POST",
    http_path = "/list-unsupported-app-version-resources",
    paginator = list()
  )
  input <- .resiliencehub$list_unsupported_app_version_resources_input(appArn = appArn, appVersion = appVersion, maxResults = maxResults, nextToken = nextToken, resolutionId = resolutionId)
  output <- .resiliencehub$list_unsupported_app_version_resources_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$list_unsupported_app_version_resources <- resiliencehub_list_unsupported_app_version_resources

#' Publishes a new version of a specific Resilience Hub application
#'
#' @description
#' Publishes a new version of a specific Resilience Hub application.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/publish_app_version.html](https://paws-r.github.io/docs/resiliencehub/publish_app_version.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_publish_app_version
resiliencehub_publish_app_version <- function(appArn) {
  op <- new_operation(
    name = "PublishAppVersion",
    http_method = "POST",
    http_path = "/publish-app-version",
    paginator = list()
  )
  input <- .resiliencehub$publish_app_version_input(appArn = appArn)
  output <- .resiliencehub$publish_app_version_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$publish_app_version <- resiliencehub_publish_app_version

#' Adds or updates the app template for a draft version of a Resilience Hub
#' app
#'
#' @description
#' Adds or updates the app template for a draft version of a Resilience Hub app.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/put_draft_app_version_template.html](https://paws-r.github.io/docs/resiliencehub/put_draft_app_version_template.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appTemplateBody &#91;required&#93; A JSON string that contains the body of the app template.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_put_draft_app_version_template
resiliencehub_put_draft_app_version_template <- function(appArn, appTemplateBody) {
  op <- new_operation(
    name = "PutDraftAppVersionTemplate",
    http_method = "POST",
    http_path = "/put-draft-app-version-template",
    paginator = list()
  )
  input <- .resiliencehub$put_draft_app_version_template_input(appArn = appArn, appTemplateBody = appTemplateBody)
  output <- .resiliencehub$put_draft_app_version_template_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$put_draft_app_version_template <- resiliencehub_put_draft_app_version_template

#' Removes resource mappings from a draft application version
#'
#' @description
#' Removes resource mappings from a draft application version.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/remove_draft_app_version_resource_mappings.html](https://paws-r.github.io/docs/resiliencehub/remove_draft_app_version_resource_mappings.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appRegistryAppNames The names of the registered applications to remove from the resource
#' mappings.
#' @param logicalStackNames The names of the CloudFormation stacks to remove from the resource
#' mappings.
#' @param resourceGroupNames The names of the resource groups to remove from the resource mappings.
#' @param resourceNames The names of the resources to remove from the resource mappings.
#' @param terraformSourceNames     </p> 
#'
#' @keywords internal
#'
#' @rdname resiliencehub_remove_draft_app_version_resource_mappings
resiliencehub_remove_draft_app_version_resource_mappings <- function(appArn, appRegistryAppNames = NULL, logicalStackNames = NULL, resourceGroupNames = NULL, resourceNames = NULL, terraformSourceNames = NULL) {
  op <- new_operation(
    name = "RemoveDraftAppVersionResourceMappings",
    http_method = "POST",
    http_path = "/remove-draft-app-version-resource-mappings",
    paginator = list()
  )
  input <- .resiliencehub$remove_draft_app_version_resource_mappings_input(appArn = appArn, appRegistryAppNames = appRegistryAppNames, logicalStackNames = logicalStackNames, resourceGroupNames = resourceGroupNames, resourceNames = resourceNames, terraformSourceNames = terraformSourceNames)
  output <- .resiliencehub$remove_draft_app_version_resource_mappings_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$remove_draft_app_version_resource_mappings <- resiliencehub_remove_draft_app_version_resource_mappings

#' Resolves the resources for an application version
#'
#' @description
#' Resolves the resources for an application version.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/resolve_app_version_resources.html](https://paws-r.github.io/docs/resiliencehub/resolve_app_version_resources.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appVersion &#91;required&#93; The version of the application.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_resolve_app_version_resources
resiliencehub_resolve_app_version_resources <- function(appArn, appVersion) {
  op <- new_operation(
    name = "ResolveAppVersionResources",
    http_method = "POST",
    http_path = "/resolve-app-version-resources",
    paginator = list()
  )
  input <- .resiliencehub$resolve_app_version_resources_input(appArn = appArn, appVersion = appVersion)
  output <- .resiliencehub$resolve_app_version_resources_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$resolve_app_version_resources <- resiliencehub_resolve_app_version_resources

#' Creates a new application assessment for an application
#'
#' @description
#' Creates a new application assessment for an application.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/start_app_assessment.html](https://paws-r.github.io/docs/resiliencehub/start_app_assessment.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param appVersion &#91;required&#93; The version of the application.
#' @param assessmentName &#91;required&#93; The name for the assessment.
#' @param clientToken Used for an idempotency token. A client token is a unique,
#' case-sensitive string of up to 64 ASCII characters. You should not reuse
#' the same client token for other API requests.
#' @param tags The tags assigned to the resource. A tag is a label that you assign to
#' an Amazon Web Services resource. Each tag consists of a key/value pair.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_start_app_assessment
resiliencehub_start_app_assessment <- function(appArn, appVersion, assessmentName, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "StartAppAssessment",
    http_method = "POST",
    http_path = "/start-app-assessment",
    paginator = list()
  )
  input <- .resiliencehub$start_app_assessment_input(appArn = appArn, appVersion = appVersion, assessmentName = assessmentName, clientToken = clientToken, tags = tags)
  output <- .resiliencehub$start_app_assessment_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$start_app_assessment <- resiliencehub_start_app_assessment

#' Applies one or more tags to a resource
#'
#' @description
#' Applies one or more tags to a resource.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/tag_resource.html](https://paws-r.github.io/docs/resiliencehub/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags to assign to the resource. Each tag consists of a key/value
#' pair.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_tag_resource
resiliencehub_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .resiliencehub$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .resiliencehub$tag_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$tag_resource <- resiliencehub_tag_resource

#' Removes one or more tags from a resource
#'
#' @description
#' Removes one or more tags from a resource.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/untag_resource.html](https://paws-r.github.io/docs/resiliencehub/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The keys of the tags to remove.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_untag_resource
resiliencehub_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .resiliencehub$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .resiliencehub$untag_resource_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$untag_resource <- resiliencehub_untag_resource

#' Updates an application
#'
#' @description
#' Updates an application.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/update_app.html](https://paws-r.github.io/docs/resiliencehub/update_app.html) for full documentation.
#'
#' @param appArn &#91;required&#93; The Amazon Resource Name (ARN) of the application. The format for this
#' ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param assessmentSchedule Assessment execution schedule with 'Daily' or 'Disabled' values.
#' @param clearResiliencyPolicyArn Specifies if the resiliency policy ARN should be cleared.
#' @param description The optional description for an app.
#' @param policyArn The Amazon Resource Name (ARN) of the resiliency policy. The format for
#' this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @keywords internal
#'
#' @rdname resiliencehub_update_app
resiliencehub_update_app <- function(appArn, assessmentSchedule = NULL, clearResiliencyPolicyArn = NULL, description = NULL, policyArn = NULL) {
  op <- new_operation(
    name = "UpdateApp",
    http_method = "POST",
    http_path = "/update-app",
    paginator = list()
  )
  input <- .resiliencehub$update_app_input(appArn = appArn, assessmentSchedule = assessmentSchedule, clearResiliencyPolicyArn = clearResiliencyPolicyArn, description = description, policyArn = policyArn)
  output <- .resiliencehub$update_app_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$update_app <- resiliencehub_update_app

#' Updates a resiliency policy
#'
#' @description
#' Updates a resiliency policy.
#'
#' See [https://paws-r.github.io/docs/resiliencehub/update_resiliency_policy.html](https://paws-r.github.io/docs/resiliencehub/update_resiliency_policy.html) for full documentation.
#'
#' @param dataLocationConstraint Specifies a high-level geographical location constraint for where your
#' resilience policy data can be stored.
#' @param policy The type of resiliency policy to be created, including the recovery time
#' objective (RTO) and recovery point objective (RPO) in seconds.
#' @param policyArn &#91;required&#93; The Amazon Resource Name (ARN) of the resiliency policy. The format for
#' this ARN is:
#' arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`.
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param policyDescription The description for the policy.
#' @param policyName The name of the policy
#' @param tier The tier for this resiliency policy, ranging from the highest severity
#' (`MissionCritical`) to lowest (`NonCritical`).
#'
#' @keywords internal
#'
#' @rdname resiliencehub_update_resiliency_policy
resiliencehub_update_resiliency_policy <- function(dataLocationConstraint = NULL, policy = NULL, policyArn, policyDescription = NULL, policyName = NULL, tier = NULL) {
  op <- new_operation(
    name = "UpdateResiliencyPolicy",
    http_method = "POST",
    http_path = "/update-resiliency-policy",
    paginator = list()
  )
  input <- .resiliencehub$update_resiliency_policy_input(dataLocationConstraint = dataLocationConstraint, policy = policy, policyArn = policyArn, policyDescription = policyDescription, policyName = policyName, tier = tier)
  output <- .resiliencehub$update_resiliency_policy_output()
  config <- get_config()
  svc <- .resiliencehub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resiliencehub$operations$update_resiliency_policy <- resiliencehub_update_resiliency_policy
