% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_start_instance_refresh}
\alias{autoscaling_start_instance_refresh}
\title{Starts a new instance refresh operation, which triggers a rolling
replacement of all previously launched instances in the Auto Scaling
group with a new group of instances}
\usage{
autoscaling_start_instance_refresh(AutoScalingGroupName, Strategy,
  Preferences)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{Strategy}{The strategy to use for the instance refresh. The only valid value is
\code{Rolling}.

A rolling update is an update that is applied to all instances in an
Auto Scaling group until all instances have been updated. A rolling
update can fail due to failed health checks or if instances are on
standby or are protected from scale in. If the rolling update process
fails, any instances that were already replaced are not rolled back to
their previous configuration.}

\item{Preferences}{Set of preferences associated with the instance refresh request.

If not provided, the default values are used. For
\code{MinHealthyPercentage}, the default value is \code{90}. For \code{InstanceWarmup},
the default is to use the value specified for the health check grace
period for the Auto Scaling group.

For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_RefreshPreferences.html}{RefreshPreferences}
in the \emph{Amazon EC2 Auto Scaling API Reference}.}
}
\description{
Starts a new instance refresh operation, which triggers a rolling
replacement of all previously launched instances in the Auto Scaling
group with a new group of instances.
}
\details{
If successful, this call creates a new instance refresh request with a
unique ID that you can use to track its progress. To query its status,
call the DescribeInstanceRefreshes API. To describe the instance
refreshes that have already run, call the DescribeInstanceRefreshes API.
To cancel an instance refresh operation in progress, use the
CancelInstanceRefresh API.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html}{Replacing Auto Scaling Instances Based on an Instance Refresh}.
}
\section{Request syntax}{
\preformatted{svc$start_instance_refresh(
  AutoScalingGroupName = "string",
  Strategy = "Rolling",
  Preferences = list(
    MinHealthyPercentage = 123,
    InstanceWarmup = 123
  )
)
}
}

\examples{
\dontrun{
# This example starts an instance refresh for the specified Auto Scaling
# group.
svc$start_instance_refresh(
  AutoScalingGroupName = "my-auto-scaling-group",
  Preferences = list(
    InstanceWarmup = 400L,
    MinHealthyPercentage = 50L
  )
)
}

}
\keyword{internal}
