% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_attach_policy}
\alias{organizations_attach_policy}
\title{Attaches a policy to a root, an organizational unit (OU), or an
individual account}
\usage{
organizations_attach_policy(PolicyId, TargetId)
}
\arguments{
\item{PolicyId}{[required] The unique identifier (ID) of the policy that you want to attach to the
target. You can get the ID for the policy by calling the ListPolicies
operation.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a policy ID
string requires \"p-\" followed by from 8 to 128 lowercase letters or
digits.}

\item{TargetId}{[required] The unique identifier (ID) of the root, OU, or account that you want to
attach the policy to. You can get the ID by calling the ListRoots,
ListOrganizationalUnitsForParent, or ListAccounts operations.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a target ID
string requires one of the following:
\itemize{
\item \strong{Root} - A string that begins with \"r-\" followed by from 4 to 32
lowercase letters or digits.
\item \strong{Account} - A string that consists of exactly 12 digits.
\item \strong{Organizational unit (OU)} - A string that begins with \"ou-\"
followed by from 4 to 32 lowercase letters or digits (the ID of the
root that the OU is in). This string is followed by a second \"-\"
dash and from 8 to 32 additional lowercase letters or digits.
}}
}
\description{
Attaches a policy to a root, an organizational unit (OU), or an
individual account.
}
\details{
How the policy affects accounts depends on the type of policy:
\itemize{
\item For more information about attaching SCPs, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_about-scps.html}{How SCPs Work}
in the \emph{AWS Organizations User Guide.}
\item For information about attaching tag policies, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies-inheritance.html}{How Policy Inheritance Works}
in the \emph{AWS Organizations User Guide.}
}

This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$attach_policy(
  PolicyId = "string",
  TargetId = "string"
)
}
}

\examples{
# The following example shows how to attach a service control policy (SCP)
# to an OU:
# 
\donttest{svc$attach_policy(
  PolicyId = "p-examplepolicyid111",
  TargetId = "ou-examplerootid111-exampleouid111"
)}

# The following example shows how to attach a service control policy (SCP)
# to an account:
# 
\donttest{svc$attach_policy(
  PolicyId = "p-examplepolicyid111",
  TargetId = "333333333333"
)}

}
\keyword{internal}
