# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon CloudWatch
#'
#' @description
#' Amazon CloudWatch monitors your Amazon Web Services (AWS) resources and
#' the applications you run on AWS in real time. You can use CloudWatch to
#' collect and track metrics, which are the variables you want to measure
#' for your resources and applications.
#' 
#' CloudWatch alarms send notifications or automatically change the
#' resources you are monitoring based on rules that you define. For
#' example, you can monitor the CPU usage and disk reads and writes of your
#' Amazon EC2 instances. Then, use this data to determine whether you
#' should launch additional instances to handle increased load. You can
#' also use this data to stop under-used instances to save money.
#' 
#' In addition to monitoring the built-in metrics that come with AWS, you
#' can monitor your own custom metrics. With CloudWatch, you gain
#' system-wide visibility into resource utilization, application
#' performance, and operational health.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- cloudwatch(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- cloudwatch()
#' svc$delete_alarms(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudwatch_delete_alarms]{delete_alarms} \tab Deletes the specified alarms \cr
#'  \link[=cloudwatch_delete_anomaly_detector]{delete_anomaly_detector} \tab Deletes the specified anomaly detection model from your account \cr
#'  \link[=cloudwatch_delete_dashboards]{delete_dashboards} \tab Deletes all dashboards that you specify \cr
#'  \link[=cloudwatch_describe_alarm_history]{describe_alarm_history} \tab Retrieves the history for the specified alarm \cr
#'  \link[=cloudwatch_describe_alarms]{describe_alarms} \tab Retrieves the specified alarms \cr
#'  \link[=cloudwatch_describe_alarms_for_metric]{describe_alarms_for_metric} \tab Retrieves the alarms for the specified metric \cr
#'  \link[=cloudwatch_describe_anomaly_detectors]{describe_anomaly_detectors} \tab Lists the anomaly detection models that you have created in your account \cr
#'  \link[=cloudwatch_disable_alarm_actions]{disable_alarm_actions} \tab Disables the actions for the specified alarms \cr
#'  \link[=cloudwatch_enable_alarm_actions]{enable_alarm_actions} \tab Enables the actions for the specified alarms \cr
#'  \link[=cloudwatch_get_dashboard]{get_dashboard} \tab Displays the details of the dashboard that you specify \cr
#'  \link[=cloudwatch_get_metric_data]{get_metric_data} \tab You can use the GetMetricData API to retrieve as many as 100 different metrics in a single request, with a total of as many as 100,800 datapoints\cr
#'  \link[=cloudwatch_get_metric_statistics]{get_metric_statistics} \tab Gets statistics for the specified metric \cr
#'  \link[=cloudwatch_get_metric_widget_image]{get_metric_widget_image} \tab You can use the GetMetricWidgetImage API to retrieve a snapshot graph of one or more Amazon CloudWatch metrics as a bitmap image \cr
#'  \link[=cloudwatch_list_dashboards]{list_dashboards} \tab Returns a list of the dashboards for your account \cr
#'  \link[=cloudwatch_list_metrics]{list_metrics} \tab List the specified metrics \cr
#'  \link[=cloudwatch_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with a CloudWatch resource \cr
#'  \link[=cloudwatch_put_anomaly_detector]{put_anomaly_detector} \tab Creates an anomaly detection model for a CloudWatch metric \cr
#'  \link[=cloudwatch_put_dashboard]{put_dashboard} \tab Creates a dashboard if it does not already exist, or updates an existing dashboard \cr
#'  \link[=cloudwatch_put_metric_alarm]{put_metric_alarm} \tab Creates or updates an alarm and associates it with the specified metric, metric math expression, or anomaly detection model \cr
#'  \link[=cloudwatch_put_metric_data]{put_metric_data} \tab Publishes metric data points to Amazon CloudWatch \cr
#'  \link[=cloudwatch_set_alarm_state]{set_alarm_state} \tab Temporarily sets the state of an alarm for testing purposes \cr
#'  \link[=cloudwatch_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified CloudWatch resource \cr
#'  \link[=cloudwatch_untag_resource]{untag_resource} \tab Removes one or more tags from the specified resource 
#' }
#'
#' @rdname cloudwatch
#' @export
cloudwatch <- function(config = list()) {
  svc <- .cloudwatch$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudwatch <- list()

.cloudwatch$operations <- list()

.cloudwatch$metadata <- list(
  service_name = "monitoring",
  endpoints = list("*" = list(endpoint = "monitoring.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "monitoring.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "CloudWatch",
  api_version = "2010-08-01",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

.cloudwatch$handlers <- new_handlers("query", "v4")

.cloudwatch$service <- function(config = list()) {
  new_service(.cloudwatch$metadata, .cloudwatch$handlers, config)
}
