% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationinsights_operations.R
\name{applicationinsights_describe_component}
\alias{applicationinsights_describe_component}
\title{Describes a component and lists the resources that are grouped together
in a component}
\usage{
applicationinsights_describe_component(ResourceGroupName, ComponentName)
}
\arguments{
\item{ResourceGroupName}{[required] The name of the resource group.}

\item{ComponentName}{[required] The name of the component.}
}
\value{
A list with the following syntax:\preformatted{list(
  ApplicationComponent = list(
    ComponentName = "string",
    ComponentRemarks = "string",
    ResourceType = "string",
    OsType = "WINDOWS"|"LINUX",
    Tier = "CUSTOM"|"DEFAULT"|"DOT_NET_CORE"|"DOT_NET_WORKER"|"DOT_NET_WEB_TIER"|"DOT_NET_WEB"|"SQL_SERVER"|"SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP"|"MYSQL"|"POSTGRESQL"|"JAVA_JMX"|"ORACLE",
    Monitor = TRUE|FALSE,
    DetectedWorkload = list(
      list(
        "string"
      )
    )
  ),
  ResourceList = list(
    "string"
  )
)
}
}
\description{
Describes a component and lists the resources that are grouped together
in a component.
}
\section{Request syntax}{
\preformatted{svc$describe_component(
  ResourceGroupName = "string",
  ComponentName = "string"
)
}
}

\keyword{internal}
