% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_restore_server}
\alias{opsworkscm_restore_server}
\title{Restores a backup to a server that is in a CONNECTION_LOST, HEALTHY,
RUNNING, UNHEALTHY, or TERMINATED state}
\usage{
opsworkscm_restore_server(BackupId, ServerName, InstanceType, KeyPair)
}
\arguments{
\item{BackupId}{[required] The ID of the backup that you want to use to restore a server.}

\item{ServerName}{[required] The name of the server that you want to restore.}

\item{InstanceType}{The type of instance to restore. Valid values must be specified in the
following format: \verb{^([cm][34]|t2).*} For example, \code{m5.large}. Valid
values are \code{m5.large}, \code{r5.xlarge}, and \code{r5.2xlarge}. If you do not
specify this parameter, RestoreServer uses the instance type from the
specified backup.}

\item{KeyPair}{The name of the key pair to set on the new EC2 instance. This can be
helpful if the administrator no longer has the SSH key.}
}
\value{
An empty list.
}
\description{
Restores a backup to a server that is in a \code{CONNECTION_LOST}, \code{HEALTHY},
\code{RUNNING}, \code{UNHEALTHY}, or \code{TERMINATED} state. When you run
RestoreServer, the server's EC2 instance is deleted, and a new EC2
instance is configured. RestoreServer maintains the existing server
endpoint, so configuration management of the server's client devices
(nodes) should continue to work.

Restoring from a backup is performed by creating a new EC2 instance. If
restoration is successful, and the server is in a \code{HEALTHY} state, AWS
OpsWorks CM switches traffic over to the new instance. After restoration
is finished, the old EC2 instance is maintained in a \code{Running} or
\code{Stopped} state, but is eventually terminated.

This operation is asynchronous.

An \code{InvalidStateException} is thrown when the server is not in a valid
state. A \code{ResourceNotFoundException} is thrown when the server does not
exist. A \code{ValidationException} is raised when parameters of the request
are not valid.
}
\section{Request syntax}{
\preformatted{svc$restore_server(
  BackupId = "string",
  ServerName = "string",
  InstanceType = "string",
  KeyPair = "string"
)
}
}

\keyword{internal}
