% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_describe_export_tasks}
\alias{cloudwatchlogs_describe_export_tasks}
\title{Lists the specified export tasks}
\usage{
cloudwatchlogs_describe_export_tasks(taskId, statusCode, nextToken,
  limit)
}
\arguments{
\item{taskId}{The ID of the export task. Specifying a task ID filters the results to
zero or one export tasks.}

\item{statusCode}{The status code of the export task. Specifying a status code filters the
results to zero or more export tasks.}

\item{nextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{limit}{The maximum number of items returned. If you don't specify a value, the
default is up to 50 items.}
}
\value{
A list with the following syntax:\preformatted{list(
  exportTasks = list(
    list(
      taskId = "string",
      taskName = "string",
      logGroupName = "string",
      from = 123,
      to = 123,
      destination = "string",
      destinationPrefix = "string",
      status = list(
        code = "CANCELLED"|"COMPLETED"|"FAILED"|"PENDING"|"PENDING_CANCEL"|"RUNNING",
        message = "string"
      ),
      executionInfo = list(
        creationTime = 123,
        completionTime = 123
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists the specified export tasks. You can list all your export tasks or
filter the results based on task ID or task status.
}
\section{Request syntax}{
\preformatted{svc$describe_export_tasks(
  taskId = "string",
  statusCode = "CANCELLED"|"COMPLETED"|"FAILED"|"PENDING"|"PENDING_CANCEL"|"RUNNING",
  nextToken = "string",
  limit = 123
)
}
}

\keyword{internal}
