% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_create_server}
\alias{opsworkscm_create_server}
\title{Creates and immedately starts a new server}
\usage{
opsworkscm_create_server(AssociatePublicIpAddress,
  DisableAutomatedBackup, Engine, EngineModel, EngineVersion,
  EngineAttributes, BackupRetentionCount, ServerName, InstanceProfileArn,
  InstanceType, KeyPair, PreferredMaintenanceWindow,
  PreferredBackupWindow, SecurityGroupIds, ServiceRoleArn, SubnetIds,
  BackupId)
}
\arguments{
\item{AssociatePublicIpAddress}{Associate a public IP address with a server that you are launching.
Valid values are \code{true} or \code{false}. The default value is \code{true}.}

\item{DisableAutomatedBackup}{Enable or disable scheduled backups. Valid values are \code{true} or \code{false}.
The default value is \code{true}.}

\item{Engine}{The configuration management engine to use. Valid values include \code{Chef}
and \code{Puppet}.}

\item{EngineModel}{The engine model of the server. Valid values in this release include
\code{Monolithic} for Puppet and \code{Single} for Chef.}

\item{EngineVersion}{The major release version of the engine that you want to use. For a Chef
server, the valid value for EngineVersion is currently \code{12}. For a
Puppet server, the valid value is \code{2017}.}

\item{EngineAttributes}{Optional engine attributes on a specified server.

\strong{Attributes accepted in a Chef createServer request:}
\itemize{
\item \code{CHEF_PIVOTAL_KEY}: A base64-encoded RSA public key. The
corresponding private key is required to access the Chef API. When
no CHEF\_PIVOTAL\_KEY is set, a private key is generated and
returned in the response.
\item \code{CHEF_DELIVERY_ADMIN_PASSWORD}: The password for the administrative
user in the Chef Automate GUI. The password length is a minimum of
eight characters, and a maximum of 32. The password can contain
letters, numbers, and special characters (!/@\#\$\%\^&+=\_). The
password must contain at least one lower case letter, one upper case
letter, one number, and one special character. When no
CHEF\_DELIVERY\_ADMIN\_PASSWORD is set, one is generated and
returned in the response.
}

\strong{Attributes accepted in a Puppet createServer request:}
\itemize{
\item \code{PUPPET_ADMIN_PASSWORD}: To work with the Puppet Enterprise console,
a password must use ASCII characters.
\item \code{PUPPET_R10K_REMOTE}: The r10k remote is the URL of your control
repository (for example,
ssh://git\@your.git-repo.com:user/control-repo.git). Specifying an
r10k remote opens TCP port 8170.
\item \code{PUPPET_R10K_PRIVATE_KEY}: If you are using a private Git
repository, add PUPPET\_R10K\_PRIVATE\_KEY to specify an SSH URL and
a PEM-encoded private SSH key.
}}

\item{BackupRetentionCount}{The number of automated backups that you want to keep. Whenever a new
backup is created, AWS OpsWorks CM deletes the oldest backups if this
number is exceeded. The default value is \code{1}.}

\item{ServerName}{[required] The name of the server. The server name must be unique within your AWS
account, within each region. Server names must start with a letter; then
letters, numbers, or hyphens (-) are allowed, up to a maximum of 40
characters.}

\item{InstanceProfileArn}{[required] The ARN of the instance profile that your Amazon EC2 instances use.
Although the AWS OpsWorks console typically creates the instance profile
for you, if you are using API commands instead, run the
service-role-creation.yaml AWS CloudFormation template, located at
https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml.
This template creates a CloudFormation stack that includes the instance
profile you need.}

\item{InstanceType}{[required] The Amazon EC2 instance type to use. For example, \code{m4.large}.
Recommended instance types include \code{t2.medium} and greater, \code{m4.*}, or
\code{c4.xlarge} and greater.}

\item{KeyPair}{The Amazon EC2 key pair to set for the instance. This parameter is
optional; if desired, you may specify this parameter to connect to your
instances by using SSH.}

\item{PreferredMaintenanceWindow}{The start time for a one-hour period each week during which AWS OpsWorks
CM performs maintenance on the instance. Valid values must be specified
in the following format: \code{DDD:HH:MM}. The specified time is in
coordinated universal time (UTC). The default value is a random one-hour
period on Tuesday, Wednesday, or Friday. See \code{TimeWindowDefinition} for
more information.

\strong{Example:} \code{Mon:08:00}, which represents a start time of every Monday
at 08:00 UTC. (8:00 a.m.)}

\item{PreferredBackupWindow}{The start time for a one-hour period during which AWS OpsWorks CM backs
up application-level data on your server if automated backups are
enabled. Valid values must be specified in one of the following formats:
\itemize{
\item \code{HH:MM} for daily backups
\item \code{DDD:HH:MM} for weekly backups
}

The specified time is in coordinated universal time (UTC). The default
value is a random, daily start time.

\strong{Example:} \code{08:00}, which represents a daily start time of 08:00 UTC.

\strong{Example:} \code{Mon:08:00}, which represents a start time of every Monday
at 08:00 UTC. (8:00 a.m.)}

\item{SecurityGroupIds}{A list of security group IDs to attach to the Amazon EC2 instance. If
you add this parameter, the specified security groups must be within the
VPC that is specified by \code{SubnetIds}.

If you do not specify this parameter, AWS OpsWorks CM creates one new
security group that uses TCP ports 22 and 443, open to 0.0.0.0/0
(everyone).}

\item{ServiceRoleArn}{[required] The service role that the AWS OpsWorks CM service backend uses to work
with your account. Although the AWS OpsWorks management console
typically creates the service role for you, if you are using the AWS CLI
or API commands, run the service-role-creation.yaml AWS CloudFormation
template, located at
https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml.
This template creates a CloudFormation stack that includes the service
role and instance profile that you need.}

\item{SubnetIds}{The IDs of subnets in which to launch the server EC2 instance.

Amazon EC2-Classic customers: This field is required. All servers must
run within a VPC. The VPC must have "Auto Assign Public IP" enabled.

EC2-VPC customers: This field is optional. If you do not specify subnet
IDs, your EC2 instances are created in a default subnet that is selected
by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto
Assign Public IP" enabled.

For more information about supported Amazon EC2 platforms, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html}{Supported Platforms}.}

\item{BackupId}{If you specify this field, AWS OpsWorks CM creates the server by using
the backup represented by BackupId.}
}
\description{
Creates and immedately starts a new server. The server is ready to use
when it is in the \code{HEALTHY} state. By default, you can create a maximum
of 10 servers.
}
\details{
This operation is asynchronous.

A \code{LimitExceededException} is thrown when you have created the maximum
number of servers (10). A \code{ResourceAlreadyExistsException} is thrown
when a server with the same name already exists in the account. A
\code{ResourceNotFoundException} is thrown when you specify a backup ID that
is not valid or is for a backup that does not exist. A
\code{ValidationException} is thrown when parameters of the request are not
valid.

If you do not specify a security group by adding the \code{SecurityGroupIds}
parameter, AWS OpsWorks creates a new security group.

\emph{Chef Automate:} The default security group opens the Chef server to the
world on TCP port 443. If a KeyName is present, AWS OpsWorks enables SSH
access. SSH is also open to the world on TCP port 22.

\emph{Puppet Enterprise:} The default security group opens TCP ports 22, 443,
4433, 8140, 8142, 8143, and 8170. If a KeyName is present, AWS OpsWorks
enables SSH access. SSH is also open to the world on TCP port 22.

By default, your server is accessible from any IP address. We recommend
that you update your security group rules to allow access from known IP
addresses and address ranges only. To edit security group rules, open
Security Groups in the navigation pane of the EC2 management console.
}
\section{Request syntax}{
\preformatted{svc$create_server(
  AssociatePublicIpAddress = TRUE|FALSE,
  DisableAutomatedBackup = TRUE|FALSE,
  Engine = "string",
  EngineModel = "string",
  EngineVersion = "string",
  EngineAttributes = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  BackupRetentionCount = 123,
  ServerName = "string",
  InstanceProfileArn = "string",
  InstanceType = "string",
  KeyPair = "string",
  PreferredMaintenanceWindow = "string",
  PreferredBackupWindow = "string",
  SecurityGroupIds = list(
    "string"
  ),
  ServiceRoleArn = "string",
  SubnetIds = list(
    "string"
  ),
  BackupId = "string"
)
}
}

\keyword{internal}
