% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_delete_stack_instances}
\alias{cloudformation_delete_stack_instances}
\title{Deletes stack instances for the specified accounts, in the specified
regions}
\usage{
cloudformation_delete_stack_instances(StackSetName, Accounts, Regions,
  OperationPreferences, RetainStacks, OperationId)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set that you want to delete stack
instances for.}

\item{Accounts}{[required] The names of the AWS accounts that you want to delete stack instances
for.}

\item{Regions}{[required] The regions where you want to delete stack set instances.}

\item{OperationPreferences}{Preferences for how AWS CloudFormation performs this stack set
operation.}

\item{RetainStacks}{[required] Removes the stack instances from the specified stack set, but doesn't
delete the stacks. You can't reassociate a retained stack or add an
existing, saved stack to a new stack set.

For more information, see \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options}{Stack set operation options}.}

\item{OperationId}{The unique identifier for this stack set operation.

If you don't specify an operation ID, the SDK generates one
automatically.

The operation ID also functions as an idempotency token, to ensure that
AWS CloudFormation performs the stack set operation only once, even if
you retry the request multiple times. You can retry stack set operation
requests to ensure that AWS CloudFormation successfully received them.

Repeating this stack set operation with a new operation ID retries all
stack instances whose status is \code{OUTDATED}.}
}
\description{
Deletes stack instances for the specified accounts, in the specified
regions.
}
\section{Request syntax}{
\preformatted{svc$delete_stack_instances(
  StackSetName = "string",
  Accounts = list(
    "string"
  ),
  Regions = list(
    "string"
  ),
  OperationPreferences = list(
    RegionOrder = list(
      "string"
    ),
    FailureToleranceCount = 123,
    FailureTolerancePercentage = 123,
    MaxConcurrentCount = 123,
    MaxConcurrentPercentage = 123
  ),
  RetainStacks = TRUE|FALSE,
  OperationId = "string"
)
}
}

\keyword{internal}
