# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Lex Model Building V2
#'
#' 
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- lexmodelsv2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- lexmodelsv2()
#' svc$batch_create_custom_vocabulary_item(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=lexmodelsv2_batch_create_custom_vocabulary_item]{batch_create_custom_vocabulary_item} \tab Create a batch of custom vocabulary items for a given bot locale's custom vocabulary\cr
#'  \link[=lexmodelsv2_batch_delete_custom_vocabulary_item]{batch_delete_custom_vocabulary_item} \tab Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary\cr
#'  \link[=lexmodelsv2_batch_update_custom_vocabulary_item]{batch_update_custom_vocabulary_item} \tab Update a batch of custom vocabulary items for a given bot locale's custom vocabulary\cr
#'  \link[=lexmodelsv2_build_bot_locale]{build_bot_locale} \tab Builds a bot, its intents, and its slot types into a specific locale\cr
#'  \link[=lexmodelsv2_create_bot]{create_bot} \tab Creates an Amazon Lex conversational bot\cr
#'  \link[=lexmodelsv2_create_bot_alias]{create_bot_alias} \tab Creates an alias for the specified version of a bot\cr
#'  \link[=lexmodelsv2_create_bot_locale]{create_bot_locale} \tab Creates a locale in the bot\cr
#'  \link[=lexmodelsv2_create_bot_version]{create_bot_version} \tab Creates a new version of the bot based on the DRAFT version\cr
#'  \link[=lexmodelsv2_create_export]{create_export} \tab Creates a zip archive containing the contents of a bot or a bot locale\cr
#'  \link[=lexmodelsv2_create_intent]{create_intent} \tab Creates an intent\cr
#'  \link[=lexmodelsv2_create_resource_policy]{create_resource_policy} \tab Creates a new resource policy with the specified policy statements\cr
#'  \link[=lexmodelsv2_create_resource_policy_statement]{create_resource_policy_statement} \tab Adds a new resource policy statement to a bot or bot alias\cr
#'  \link[=lexmodelsv2_create_slot]{create_slot} \tab Creates a slot in an intent\cr
#'  \link[=lexmodelsv2_create_slot_type]{create_slot_type} \tab Creates a custom slot type\cr
#'  \link[=lexmodelsv2_create_test_set_discrepancy_report]{create_test_set_discrepancy_report} \tab Create a report that describes the differences between the bot and the test set\cr
#'  \link[=lexmodelsv2_create_upload_url]{create_upload_url} \tab Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale\cr
#'  \link[=lexmodelsv2_delete_bot]{delete_bot} \tab Deletes all versions of a bot, including the Draft version\cr
#'  \link[=lexmodelsv2_delete_bot_alias]{delete_bot_alias} \tab Deletes the specified bot alias\cr
#'  \link[=lexmodelsv2_delete_bot_locale]{delete_bot_locale} \tab Removes a locale from a bot\cr
#'  \link[=lexmodelsv2_delete_bot_version]{delete_bot_version} \tab Deletes a specific version of a bot\cr
#'  \link[=lexmodelsv2_delete_custom_vocabulary]{delete_custom_vocabulary} \tab Removes a custom vocabulary from the specified locale in the specified bot\cr
#'  \link[=lexmodelsv2_delete_export]{delete_export} \tab Removes a previous export and the associated files stored in an S3 bucket\cr
#'  \link[=lexmodelsv2_delete_import]{delete_import} \tab Removes a previous import and the associated file stored in an S3 bucket\cr
#'  \link[=lexmodelsv2_delete_intent]{delete_intent} \tab Removes the specified intent\cr
#'  \link[=lexmodelsv2_delete_resource_policy]{delete_resource_policy} \tab Removes an existing policy from a bot or bot alias\cr
#'  \link[=lexmodelsv2_delete_resource_policy_statement]{delete_resource_policy_statement} \tab Deletes a policy statement from a resource policy\cr
#'  \link[=lexmodelsv2_delete_slot]{delete_slot} \tab Deletes the specified slot from an intent\cr
#'  \link[=lexmodelsv2_delete_slot_type]{delete_slot_type} \tab Deletes a slot type from a bot locale\cr
#'  \link[=lexmodelsv2_delete_test_set]{delete_test_set} \tab The action to delete the selected test set\cr
#'  \link[=lexmodelsv2_delete_utterances]{delete_utterances} \tab Deletes stored utterances\cr
#'  \link[=lexmodelsv2_describe_bot]{describe_bot} \tab Provides metadata information about a bot\cr
#'  \link[=lexmodelsv2_describe_bot_alias]{describe_bot_alias} \tab Get information about a specific bot alias\cr
#'  \link[=lexmodelsv2_describe_bot_locale]{describe_bot_locale} \tab Describes the settings that a bot has for a specific locale\cr
#'  \link[=lexmodelsv2_describe_bot_recommendation]{describe_bot_recommendation} \tab Provides metadata information about a bot recommendation\cr
#'  \link[=lexmodelsv2_describe_bot_version]{describe_bot_version} \tab Provides metadata about a version of a bot\cr
#'  \link[=lexmodelsv2_describe_custom_vocabulary_metadata]{describe_custom_vocabulary_metadata} \tab Provides metadata information about a custom vocabulary\cr
#'  \link[=lexmodelsv2_describe_export]{describe_export} \tab Gets information about a specific export\cr
#'  \link[=lexmodelsv2_describe_import]{describe_import} \tab Gets information about a specific import\cr
#'  \link[=lexmodelsv2_describe_intent]{describe_intent} \tab Returns metadata about an intent\cr
#'  \link[=lexmodelsv2_describe_resource_policy]{describe_resource_policy} \tab Gets the resource policy and policy revision for a bot or bot alias\cr
#'  \link[=lexmodelsv2_describe_slot]{describe_slot} \tab Gets metadata information about a slot\cr
#'  \link[=lexmodelsv2_describe_slot_type]{describe_slot_type} \tab Gets metadata information about a slot type\cr
#'  \link[=lexmodelsv2_describe_test_execution]{describe_test_execution} \tab Gets metadata information about the test execution\cr
#'  \link[=lexmodelsv2_describe_test_set]{describe_test_set} \tab Gets metadata information about the test set\cr
#'  \link[=lexmodelsv2_describe_test_set_discrepancy_report]{describe_test_set_discrepancy_report} \tab Gets metadata information about the test set discrepancy report\cr
#'  \link[=lexmodelsv2_describe_test_set_generation]{describe_test_set_generation} \tab Gets metadata information about the test set generation\cr
#'  \link[=lexmodelsv2_get_test_execution_artifacts_url]{get_test_execution_artifacts_url} \tab The pre-signed Amazon S3 URL to download the test execution result artifacts\cr
#'  \link[=lexmodelsv2_list_aggregated_utterances]{list_aggregated_utterances} \tab Provides a list of utterances that users have sent to the bot\cr
#'  \link[=lexmodelsv2_list_bot_aliases]{list_bot_aliases} \tab Gets a list of aliases for the specified bot\cr
#'  \link[=lexmodelsv2_list_bot_locales]{list_bot_locales} \tab Gets a list of locales for the specified bot\cr
#'  \link[=lexmodelsv2_list_bot_recommendations]{list_bot_recommendations} \tab Get a list of bot recommendations that meet the specified criteria\cr
#'  \link[=lexmodelsv2_list_bots]{list_bots} \tab Gets a list of available bots\cr
#'  \link[=lexmodelsv2_list_bot_versions]{list_bot_versions} \tab Gets information about all of the versions of a bot\cr
#'  \link[=lexmodelsv2_list_built_in_intents]{list_built_in_intents} \tab Gets a list of built-in intents provided by Amazon Lex that you can use in your bot\cr
#'  \link[=lexmodelsv2_list_built_in_slot_types]{list_built_in_slot_types} \tab Gets a list of built-in slot types that meet the specified criteria\cr
#'  \link[=lexmodelsv2_list_custom_vocabulary_items]{list_custom_vocabulary_items} \tab Paginated list of custom vocabulary items for a given bot locale's custom vocabulary\cr
#'  \link[=lexmodelsv2_list_exports]{list_exports} \tab Lists the exports for a bot, bot locale, or custom vocabulary\cr
#'  \link[=lexmodelsv2_list_imports]{list_imports} \tab Lists the imports for a bot, bot locale, or custom vocabulary\cr
#'  \link[=lexmodelsv2_list_intents]{list_intents} \tab Get a list of intents that meet the specified criteria\cr
#'  \link[=lexmodelsv2_list_recommended_intents]{list_recommended_intents} \tab Gets a list of recommended intents provided by the bot recommendation that you can use in your bot\cr
#'  \link[=lexmodelsv2_list_slots]{list_slots} \tab Gets a list of slots that match the specified criteria\cr
#'  \link[=lexmodelsv2_list_slot_types]{list_slot_types} \tab Gets a list of slot types that match the specified criteria\cr
#'  \link[=lexmodelsv2_list_tags_for_resource]{list_tags_for_resource} \tab Gets a list of tags associated with a resource\cr
#'  \link[=lexmodelsv2_list_test_execution_result_items]{list_test_execution_result_items} \tab Gets a list of test execution result items\cr
#'  \link[=lexmodelsv2_list_test_executions]{list_test_executions} \tab The list of test set executions\cr
#'  \link[=lexmodelsv2_list_test_set_records]{list_test_set_records} \tab The list of test set records\cr
#'  \link[=lexmodelsv2_list_test_sets]{list_test_sets} \tab The list of the test sets\cr
#'  \link[=lexmodelsv2_search_associated_transcripts]{search_associated_transcripts} \tab Search for associated transcripts that meet the specified criteria\cr
#'  \link[=lexmodelsv2_start_bot_recommendation]{start_bot_recommendation} \tab Use this to provide your transcript data, and to start the bot recommendation process\cr
#'  \link[=lexmodelsv2_start_import]{start_import} \tab Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket\cr
#'  \link[=lexmodelsv2_start_test_execution]{start_test_execution} \tab The action to start test set execution\cr
#'  \link[=lexmodelsv2_start_test_set_generation]{start_test_set_generation} \tab The action to start the generation of test set\cr
#'  \link[=lexmodelsv2_stop_bot_recommendation]{stop_bot_recommendation} \tab Stop an already running Bot Recommendation request\cr
#'  \link[=lexmodelsv2_tag_resource]{tag_resource} \tab Adds the specified tags to the specified resource\cr
#'  \link[=lexmodelsv2_untag_resource]{untag_resource} \tab Removes tags from a bot, bot alias, or bot channel\cr
#'  \link[=lexmodelsv2_update_bot]{update_bot} \tab Updates the configuration of an existing bot\cr
#'  \link[=lexmodelsv2_update_bot_alias]{update_bot_alias} \tab Updates the configuration of an existing bot alias\cr
#'  \link[=lexmodelsv2_update_bot_locale]{update_bot_locale} \tab Updates the settings that a bot has for a specific locale\cr
#'  \link[=lexmodelsv2_update_bot_recommendation]{update_bot_recommendation} \tab Updates an existing bot recommendation request\cr
#'  \link[=lexmodelsv2_update_export]{update_export} \tab Updates the password used to protect an export zip archive\cr
#'  \link[=lexmodelsv2_update_intent]{update_intent} \tab Updates the settings for an intent\cr
#'  \link[=lexmodelsv2_update_resource_policy]{update_resource_policy} \tab Replaces the existing resource policy for a bot or bot alias with a new one\cr
#'  \link[=lexmodelsv2_update_slot]{update_slot} \tab Updates the settings for a slot\cr
#'  \link[=lexmodelsv2_update_slot_type]{update_slot_type} \tab Updates the configuration of an existing slot type\cr
#'  \link[=lexmodelsv2_update_test_set]{update_test_set} \tab The action to update the test set
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname lexmodelsv2
#' @export
lexmodelsv2 <- function(config = list()) {
  svc <- .lexmodelsv2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.lexmodelsv2 <- list()

.lexmodelsv2$operations <- list()

.lexmodelsv2$metadata <- list(
  service_name = "lexmodelsv2",
  endpoints = list("*" = list(endpoint = "models-v2-lex.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "models-v2-lex.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "models-v2-lex.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "models-v2-lex.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Lex Models V2",
  api_version = "2020-08-07",
  signing_name = "lex",
  json_version = "1.1",
  target_prefix = ""
)

.lexmodelsv2$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.lexmodelsv2$metadata, handlers, config)
}
