% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_lineage_groups}
\alias{sagemaker_list_lineage_groups}
\title{A list of lineage groups shared with your Amazon Web Services account}
\usage{
sagemaker_list_lineage_groups(
  CreatedAfter = NULL,
  CreatedBefore = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{CreatedAfter}{A timestamp to filter against lineage groups created after a certain
point in time.}

\item{CreatedBefore}{A timestamp to filter against lineage groups created before a certain
point in time.}

\item{SortBy}{The parameter by which to sort the results. The default is
\code{CreationTime}.}

\item{SortOrder}{The sort order for the results. The default is \code{Ascending}.}

\item{NextToken}{If the response is truncated, SageMaker returns this token. To retrieve
the next set of algorithms, use it in the subsequent request.}

\item{MaxResults}{The maximum number of endpoints to return in the response. This value
defaults to 10.}
}
\description{
A list of lineage groups shared with your Amazon Web Services account. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html}{Cross-Account Lineage Tracking} in the \emph{Amazon SageMaker Developer Guide}.

See \url{https://paws-r.github.io/docs/sagemaker/list_lineage_groups.html} for full documentation.
}
\keyword{internal}
