% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_delete_faces}
\alias{rekognition_delete_faces}
\title{Deletes faces from a collection}
\usage{
rekognition_delete_faces(CollectionId, FaceIds)
}
\arguments{
\item{CollectionId}{[required] Collection from which to remove the specific faces.}

\item{FaceIds}{[required] An array of face IDs to delete.}
}
\description{
Deletes faces from a collection. You specify a collection ID and an
array of face IDs to remove from the collection.
}
\details{
This operation requires permissions to perform the
\code{rekognition:DeleteFaces} action.
}
\section{Request syntax}{
\preformatted{svc$delete_faces(
  CollectionId = "string",
  FaceIds = list(
    "string"
  )
)
}
}

\examples{
# This operation deletes one or more faces from a Rekognition collection.
\dontrun{svc$delete_faces(
  CollectionId = "myphotos",
  FaceIds = list(
    "ff43d742-0c13-5d16-a3e8-03d3f58e980b"
  )
)}

}
\keyword{internal}
