% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_model_package}
\alias{sagemaker_create_model_package}
\title{Creates a model package that you can use to create Amazon SageMaker
models or list on AWS Marketplace, or a versioned model that is part of
a model group}
\usage{
sagemaker_create_model_package(ModelPackageName, ModelPackageGroupName,
  ModelPackageDescription, InferenceSpecification,
  ValidationSpecification, SourceAlgorithmSpecification,
  CertifyForMarketplace, Tags, ModelApprovalStatus, MetadataProperties,
  ModelMetrics, ClientToken)
}
\arguments{
\item{ModelPackageName}{The name of the model package. The name must have 1 to 63 characters.
Valid characters are a-z, A-Z, 0-9, and - (hyphen).

This parameter is required for unversioned models. It is not applicable
to versioned models.}

\item{ModelPackageGroupName}{The name of the model group that this model version belongs to.

This parameter is required for versioned models, and does not apply to
unversioned models.}

\item{ModelPackageDescription}{A description of the model package.}

\item{InferenceSpecification}{Specifies details about inference jobs that can be run with models based
on this model package, including the following:
\itemize{
\item The Amazon ECR paths of containers that contain the inference code
and model artifacts.
\item The instance types that the model package supports for transform
jobs and real-time endpoints used for inference.
\item The input and output content formats that the model package supports
for inference.
}}

\item{ValidationSpecification}{Specifies configurations for one or more transform jobs that Amazon
SageMaker runs to test the model package.}

\item{SourceAlgorithmSpecification}{Details about the algorithm that was used to create the model package.}

\item{CertifyForMarketplace}{Whether to certify the model package for listing on AWS Marketplace.

This parameter is optional for unversioned models, and does not apply to
versioned models.}

\item{Tags}{A list of key value pairs associated with the model. For more
information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging AWS resources}
in the \emph{AWS General Reference Guide}.}

\item{ModelApprovalStatus}{Whether the model is approved for deployment.

This parameter is optional for versioned models, and does not apply to
unversioned models.

For versioned models, the value of this parameter must be set to
\code{Approved} to deploy the model.}

\item{MetadataProperties}{}

\item{ModelMetrics}{A structure that contains model metrics reports.}

\item{ClientToken}{A unique token that guarantees that the call to this API is idempotent.}
}
\value{
A list with the following syntax:\preformatted{list(
  ModelPackageArn = "string"
)
}
}
\description{
Creates a model package that you can use to create Amazon SageMaker
models or list on AWS Marketplace, or a versioned model that is part of
a model group. Buyers can subscribe to model packages listed on AWS
Marketplace to create models in Amazon SageMaker.

To create a model package by specifying a Docker container that contains
your inference code and the Amazon S3 location of your model artifacts,
provide values for \code{InferenceSpecification}. To create a model from an
algorithm resource that you created or subscribed to in AWS Marketplace,
provide a value for \code{SourceAlgorithmSpecification}.

There are two types of model packages:
\itemize{
\item Versioned - a model that is part of a model group in the model
registry.
\item Unversioned - a model package that is not part of a model group.
}
}
\section{Request syntax}{
\preformatted{svc$create_model_package(
  ModelPackageName = "string",
  ModelPackageGroupName = "string",
  ModelPackageDescription = "string",
  InferenceSpecification = list(
    Containers = list(
      list(
        ContainerHostname = "string",
        Image = "string",
        ImageDigest = "string",
        ModelDataUrl = "string",
        ProductId = "string"
      )
    ),
    SupportedTransformInstanceTypes = list(
      "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"
    ),
    SupportedRealtimeInferenceInstanceTypes = list(
      "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.m5d.large"|"ml.m5d.xlarge"|"ml.m5d.2xlarge"|"ml.m5d.4xlarge"|"ml.m5d.12xlarge"|"ml.m5d.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.large"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.12xlarge"|"ml.r5.24xlarge"|"ml.r5d.large"|"ml.r5d.xlarge"|"ml.r5d.2xlarge"|"ml.r5d.4xlarge"|"ml.r5d.12xlarge"|"ml.r5d.24xlarge"|"ml.inf1.xlarge"|"ml.inf1.2xlarge"|"ml.inf1.6xlarge"|"ml.inf1.24xlarge"
    ),
    SupportedContentTypes = list(
      "string"
    ),
    SupportedResponseMIMETypes = list(
      "string"
    )
  ),
  ValidationSpecification = list(
    ValidationRole = "string",
    ValidationProfiles = list(
      list(
        ProfileName = "string",
        TransformJobDefinition = list(
          MaxConcurrentTransforms = 123,
          MaxPayloadInMB = 123,
          BatchStrategy = "MultiRecord"|"SingleRecord",
          Environment = list(
            "string"
          ),
          TransformInput = list(
            DataSource = list(
              S3DataSource = list(
                S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
                S3Uri = "string"
              )
            ),
            ContentType = "string",
            CompressionType = "None"|"Gzip",
            SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
          ),
          TransformOutput = list(
            S3OutputPath = "string",
            Accept = "string",
            AssembleWith = "None"|"Line",
            KmsKeyId = "string"
          ),
          TransformResources = list(
            InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
            InstanceCount = 123,
            VolumeKmsKeyId = "string"
          )
        )
      )
    )
  ),
  SourceAlgorithmSpecification = list(
    SourceAlgorithms = list(
      list(
        ModelDataUrl = "string",
        AlgorithmName = "string"
      )
    )
  ),
  CertifyForMarketplace = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  ModelApprovalStatus = "Approved"|"Rejected"|"PendingManualApproval",
  MetadataProperties = list(
    CommitId = "string",
    Repository = "string",
    GeneratedBy = "string",
    ProjectId = "string"
  ),
  ModelMetrics = list(
    ModelQuality = list(
      Statistics = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      ),
      Constraints = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      )
    ),
    ModelDataQuality = list(
      Statistics = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      ),
      Constraints = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      )
    ),
    Bias = list(
      Report = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      )
    ),
    Explainability = list(
      Report = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      )
    )
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
