% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_delete_tags}
\alias{machinelearning_delete_tags}
\title{Deletes the specified tags associated with an ML object}
\usage{
machinelearning_delete_tags(TagKeys, ResourceId, ResourceType)
}
\arguments{
\item{TagKeys}{[required] One or more tags to delete.}

\item{ResourceId}{[required] The ID of the tagged ML object. For example, \code{exampleModelId}.}

\item{ResourceType}{[required] The type of the tagged ML object.}
}
\description{
Deletes the specified tags associated with an ML object. After this
operation is complete, you can't recover deleted tags.

If you specify a tag that doesn't exist, Amazon ML ignores it.
}
\section{Request syntax}{
\preformatted{svc$delete_tags(
  TagKeys = list(
    "string"
  ),
  ResourceId = "string",
  ResourceType = "BatchPrediction"|"DataSource"|"Evaluation"|"MLModel"
)
}
}

\keyword{internal}
