# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon SageMaker Runtime
#'
#' @description
#' The Amazon SageMaker runtime API.
#'
#' @examples
#' \donttest{svc <- sagemakerruntime()
#' svc$invoke_endpoint(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=sagemakerruntime_invoke_endpoint]{invoke_endpoint} \tab After you deploy a model into production using Amazon SageMaker hosting services, your client applications use this API to get inferences from the model hosted at the specified endpoint
#' }
#'
#' @rdname sagemakerruntime
#' @export
sagemakerruntime <- function() {
  .sagemakerruntime$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.sagemakerruntime <- list()

.sagemakerruntime$operations <- list()

.sagemakerruntime$metadata <- list(
  service_name = "runtime.sagemaker",
  endpoints = list("*" = "runtime.sagemaker.{region}.amazonaws.com", "cn-*" = "runtime.sagemaker.{region}.amazonaws.com.cn"),
  service_id = "SageMaker Runtime",
  api_version = "2017-05-13",
  signing_name = "sagemaker",
  json_version = "1.1",
  target_prefix = ""
)

.sagemakerruntime$handlers <- new_handlers("restjson", "v4")

.sagemakerruntime$service <- function() {
  new_service(.sagemakerruntime$metadata, .sagemakerruntime$handlers)
}
