% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudcontrolapi_operations.R
\name{cloudcontrolapi_list_resource_requests}
\alias{cloudcontrolapi_list_resource_requests}
\title{Returns existing resource operation requests}
\usage{
cloudcontrolapi_list_resource_requests(
  MaxResults = NULL,
  NextToken = NULL,
  ResourceRequestStatusFilter = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.

The default is \code{20}.}

\item{NextToken}{If the previous paginated request didn't return all of the remaining
results, the response object's \code{NextToken} parameter value is set to a
token. To retrieve the next set of results, call this action again and
assign that token to the request object's \code{NextToken} parameter. If
there are no remaining results, the previous response object's
\code{NextToken} parameter is set to \code{null}.}

\item{ResourceRequestStatusFilter}{The filter criteria to apply to the requests returned.}
}
\description{
Returns existing resource operation requests. This includes requests of all status types. For more information, see \href{https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-list}{Listing active resource operation requests} in the \emph{Amazon Web Services Cloud Control API User Guide}.

See \url{https://www.paws-r-sdk.com/docs/cloudcontrolapi_list_resource_requests/} for full documentation.
}
\keyword{internal}
