% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_create_sampling_rule}
\alias{xray_create_sampling_rule}
\title{Creates a rule to control sampling behavior for instrumented
applications}
\usage{
xray_create_sampling_rule(SamplingRule, Tags = NULL)
}
\arguments{
\item{SamplingRule}{[required] The rule definition.}

\item{Tags}{A map that contains one or more tag keys and tag values to attach to an
X-Ray sampling rule. For more information about ways to use tags, see
\href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging Amazon Web Services resources}
in the \emph{Amazon Web Services General Reference}.

The following restrictions apply to tags:
\itemize{
\item Maximum number of user-applied tags per resource: 50
\item Maximum tag key length: 128 Unicode characters
\item Maximum tag value length: 256 Unicode characters
\item Valid values for key and value: a-z, A-Z, 0-9, space, and the
following characters: _ . : / = + - and @
\item Tag keys and values are case sensitive.
\item Don't use \verb{aws:} as a prefix for keys; it's reserved for Amazon Web
Services use.
}}
}
\description{
Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with \code{\link[=xray_get_sampling_rules]{get_sampling_rules}}, and evaluate each rule in ascending order of \emph{priority} for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with \code{\link[=xray_get_sampling_targets]{get_sampling_targets}} to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.

See \url{https://paws-r.github.io/docs/xray/create_sampling_rule.html} for full documentation.
}
\keyword{internal}
