% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_merge_pull_request_by_fast_forward}
\alias{codecommit_merge_pull_request_by_fast_forward}
\title{Attempts to merge the source commit of a pull request into the specified
destination branch for that pull request at the specified commit using
the fast-forward merge strategy}
\usage{
codecommit_merge_pull_request_by_fast_forward(
  pullRequestId,
  repositoryName,
  sourceCommitId = NULL
)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request. To get this ID, use
\code{\link[=codecommit_list_pull_requests]{list_pull_requests}}.}

\item{repositoryName}{[required] The name of the repository where the pull request was created.}

\item{sourceCommitId}{The full commit ID of the original or updated commit in the pull request
source branch. Pass this value if you want an exception thrown if the
current commit ID of the tip of the source branch does not match this
commit ID.}
}
\description{
Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.

See \url{https://paws-r.github.io/docs/codecommit/merge_pull_request_by_fast_forward.html} for full documentation.
}
\keyword{internal}
