% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_start_build_batch}
\alias{codebuild_start_build_batch}
\title{Starts a batch build for a project}
\usage{
codebuild_start_build_batch(
  projectName,
  secondarySourcesOverride = NULL,
  secondarySourcesVersionOverride = NULL,
  sourceVersion = NULL,
  artifactsOverride = NULL,
  secondaryArtifactsOverride = NULL,
  environmentVariablesOverride = NULL,
  sourceTypeOverride = NULL,
  sourceLocationOverride = NULL,
  sourceAuthOverride = NULL,
  gitCloneDepthOverride = NULL,
  gitSubmodulesConfigOverride = NULL,
  buildspecOverride = NULL,
  insecureSslOverride = NULL,
  reportBuildBatchStatusOverride = NULL,
  environmentTypeOverride = NULL,
  imageOverride = NULL,
  computeTypeOverride = NULL,
  certificateOverride = NULL,
  cacheOverride = NULL,
  serviceRoleOverride = NULL,
  privilegedModeOverride = NULL,
  buildTimeoutInMinutesOverride = NULL,
  queuedTimeoutInMinutesOverride = NULL,
  encryptionKeyOverride = NULL,
  idempotencyToken = NULL,
  logsConfigOverride = NULL,
  registryCredentialOverride = NULL,
  imagePullCredentialsTypeOverride = NULL,
  buildBatchConfigOverride = NULL,
  debugSessionEnabled = NULL
)
}
\arguments{
\item{projectName}{[required] The name of the project.}

\item{secondarySourcesOverride}{An array of \code{ProjectSource} objects that override the secondary sources
defined in the batch build project.}

\item{secondarySourcesVersionOverride}{An array of \code{ProjectSourceVersion} objects that override the secondary
source versions in the batch build project.}

\item{sourceVersion}{The version of the batch build input to be built, for this build only.
If not specified, the latest version is used. If specified, the contents
depends on the source provider:

\strong{CodeCommit}

The commit ID, branch, or Git tag to use.

\strong{GitHub}

The commit ID, pull request ID, branch name, or tag name that
corresponds to the version of the source code you want to build. If a
pull request ID is specified, it must use the format
\code{pr/pull-request-ID} (for example \code{pr/25}). If a branch name is
specified, the branch's HEAD commit ID is used. If not specified, the
default branch's HEAD commit ID is used.

\strong{Bitbucket}

The commit ID, branch name, or tag name that corresponds to the version
of the source code you want to build. If a branch name is specified, the
branch's HEAD commit ID is used. If not specified, the default branch's
HEAD commit ID is used.

\strong{Amazon S3}

The version ID of the object that represents the build input ZIP file to
use.

If \code{sourceVersion} is specified at the project level, then this
\code{sourceVersion} (at the build level) takes precedence.

For more information, see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html}{Source Version Sample with CodeBuild}
in the \emph{CodeBuild User Guide}.}

\item{artifactsOverride}{An array of \code{ProjectArtifacts} objects that contains information about
the build output artifact overrides for the build project.}

\item{secondaryArtifactsOverride}{An array of \code{ProjectArtifacts} objects that override the secondary
artifacts defined in the batch build project.}

\item{environmentVariablesOverride}{An array of \code{EnvironmentVariable} objects that override, or add to, the
environment variables defined in the batch build project.}

\item{sourceTypeOverride}{The source input type that overrides the source input defined in the
batch build project.}

\item{sourceLocationOverride}{A location that overrides, for this batch build, the source location
defined in the batch build project.}

\item{sourceAuthOverride}{A \code{SourceAuth} object that overrides the one defined in the batch build
project. This override applies only if the build project's source is
BitBucket or GitHub.}

\item{gitCloneDepthOverride}{The user-defined depth of history, with a minimum value of 0, that
overrides, for this batch build only, any previous depth of history
defined in the batch build project.}

\item{gitSubmodulesConfigOverride}{A \code{GitSubmodulesConfig} object that overrides the Git submodules
configuration for this batch build.}

\item{buildspecOverride}{A buildspec file declaration that overrides, for this build only, the
latest one already defined in the build project.

If this value is set, it can be either an inline buildspec definition,
the path to an alternate buildspec file relative to the value of the
built-in \code{CODEBUILD_SRC_DIR} environment variable, or the path to an S3
bucket. The bucket must be in the same Amazon Web Services Region as the
build project. Specify the buildspec file using its ARN (for example,
\code{arn:aws:s3:::my-codebuild-sample2/buildspec.yml}). If this value is not
provided or is set to an empty string, the source code must contain a
buildspec file in its root directory. For more information, see
\href{https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage}{Buildspec File Name and Storage Location}.}

\item{insecureSslOverride}{Enable this flag to override the insecure SSL setting that is specified
in the batch build project. The insecure SSL setting determines whether
to ignore SSL warnings while connecting to the project source code. This
override applies only if the build's source is GitHub Enterprise.}

\item{reportBuildBatchStatusOverride}{Set to \code{true} to report to your source provider the status of a batch
build's start and completion. If you use this option with a source
provider other than GitHub, GitHub Enterprise, or Bitbucket, an
\code{invalidInputException} is thrown.

The status of a build triggered by a webhook is always reported to your
source provider.}

\item{environmentTypeOverride}{A container type for this batch build that overrides the one specified
in the batch build project.}

\item{imageOverride}{The name of an image for this batch build that overrides the one
specified in the batch build project.}

\item{computeTypeOverride}{The name of a compute type for this batch build that overrides the one
specified in the batch build project.}

\item{certificateOverride}{The name of a certificate for this batch build that overrides the one
specified in the batch build project.}

\item{cacheOverride}{A \code{ProjectCache} object that specifies cache overrides.}

\item{serviceRoleOverride}{The name of a service role for this batch build that overrides the one
specified in the batch build project.}

\item{privilegedModeOverride}{Enable this flag to override privileged mode in the batch build project.}

\item{buildTimeoutInMinutesOverride}{Overrides the build timeout specified in the batch build project.}

\item{queuedTimeoutInMinutesOverride}{The number of minutes a batch build is allowed to be queued before it
times out.}

\item{encryptionKeyOverride}{The Key Management Service customer master key (CMK) that overrides the
one specified in the batch build project. The CMK key encrypts the build
output artifacts.

You can use a cross-account KMS key to encrypt the build output
artifacts if your service role has permission to that key.

You can specify either the Amazon Resource Name (ARN) of the CMK or, if
available, the CMK's alias (using the format \verb{alias/<alias-name>}).}

\item{idempotencyToken}{A unique, case sensitive identifier you provide to ensure the
idempotency of the \code{\link[=codebuild_start_build_batch]{start_build_batch}}
request. The token is included in the
\code{\link[=codebuild_start_build_batch]{start_build_batch}} request and is valid
for five minutes. If you repeat the
\code{\link[=codebuild_start_build_batch]{start_build_batch}} request with the same
token, but change a parameter, CodeBuild returns a parameter mismatch
error.}

\item{logsConfigOverride}{A \code{LogsConfig} object that override the log settings defined in the
batch build project.}

\item{registryCredentialOverride}{A \code{RegistryCredential} object that overrides credentials for access to a
private registry.}

\item{imagePullCredentialsTypeOverride}{The type of credentials CodeBuild uses to pull images in your batch
build. There are two valid values:

\strong{CODEBUILD}

Specifies that CodeBuild uses its own credentials. This requires that
you modify your ECR repository policy to trust CodeBuild's service
principal.

\strong{SERVICE_ROLE}

Specifies that CodeBuild uses your build project's service role.

When using a cross-account or private registry image, you must use
\code{SERVICE_ROLE} credentials. When using an CodeBuild curated image, you
must use \code{CODEBUILD} credentials.}

\item{buildBatchConfigOverride}{A \code{BuildBatchConfigOverride} object that contains batch build
configuration overrides.}

\item{debugSessionEnabled}{Specifies if session debugging is enabled for this batch build. For more
information, see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html}{Viewing a running build in Session Manager}.
Batch session debugging is not supported for matrix batch builds.}
}
\description{
Starts a batch build for a project.

See \url{https://paws-r.github.io/docs/codebuild/start_build_batch.html} for full documentation.
}
\keyword{internal}
