% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_list_associated_approval_rule_templates_for_repository}
\alias{codecommit_list_associated_approval_rule_templates_for_repository}
\title{Lists all approval rule templates that are associated with a specified
repository}
\usage{
codecommit_list_associated_approval_rule_templates_for_repository(
  repositoryName, nextToken, maxResults)
}
\arguments{
\item{repositoryName}{[required] The name of the repository for which you want to list all associated
approval rule templates.}

\item{nextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}

\item{maxResults}{A non-zero, non-negative integer used to limit the number of returned
results.}
}
\value{
A list with the following syntax:\preformatted{list(
  approvalRuleTemplateNames = list(
    "string"
  ),
  nextToken = "string"
)
}
}
\description{
Lists all approval rule templates that are associated with a specified
repository.
}
\section{Request syntax}{
\preformatted{svc$list_associated_approval_rule_templates_for_repository(
  repositoryName = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
