% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_restore_table_from_cluster_snapshot}
\alias{redshift_restore_table_from_cluster_snapshot}
\title{Creates a new table from a table in an Amazon Redshift cluster snapshot}
\usage{
redshift_restore_table_from_cluster_snapshot(
  ClusterIdentifier,
  SnapshotIdentifier,
  SourceDatabaseName,
  SourceSchemaName = NULL,
  SourceTableName,
  TargetDatabaseName = NULL,
  TargetSchemaName = NULL,
  NewTableName,
  EnableCaseSensitiveIdentifier = NULL
)
}
\arguments{
\item{ClusterIdentifier}{[required] The identifier of the Amazon Redshift cluster to restore the table to.}

\item{SnapshotIdentifier}{[required] The identifier of the snapshot to restore the table from. This snapshot
must have been created from the Amazon Redshift cluster specified by the
\code{ClusterIdentifier} parameter.}

\item{SourceDatabaseName}{[required] The name of the source database that contains the table to restore from.}

\item{SourceSchemaName}{The name of the source schema that contains the table to restore from.
If you do not specify a \code{SourceSchemaName} value, the default is
\code{public}.}

\item{SourceTableName}{[required] The name of the source table to restore from.}

\item{TargetDatabaseName}{The name of the database to restore the table to.}

\item{TargetSchemaName}{The name of the schema to restore the table to.}

\item{NewTableName}{[required] The name of the table to create as a result of the current request.}

\item{EnableCaseSensitiveIdentifier}{Indicates whether name identifiers for database, schema, and table are
case sensitive. If \code{true}, the names are case sensitive. If \code{false}
(default), the names are not case sensitive.}
}
\description{
Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the Amazon Redshift cluster that the snapshot was taken from.

See \url{https://paws-r.github.io/docs/redshift/restore_table_from_cluster_snapshot.html} for full documentation.
}
\keyword{internal}
