% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_resize_cluster}
\alias{redshift_resize_cluster}
\title{Changes the size of the cluster}
\usage{
redshift_resize_cluster(
  ClusterIdentifier,
  ClusterType = NULL,
  NodeType = NULL,
  NumberOfNodes = NULL,
  Classic = NULL,
  ReservedNodeId = NULL,
  TargetReservedNodeOfferingId = NULL
)
}
\arguments{
\item{ClusterIdentifier}{[required] The unique identifier for the cluster to resize.}

\item{ClusterType}{The new cluster type for the specified cluster.}

\item{NodeType}{The new node type for the nodes you are adding. If not specified, the
cluster's current node type is used.}

\item{NumberOfNodes}{The new number of nodes for the cluster. If not specified, the cluster's
current number of nodes is used.}

\item{Classic}{A boolean value indicating whether the resize operation is using the
classic resize process. If you don't provide this parameter or set the
value to \code{false}, the resize type is elastic.}

\item{ReservedNodeId}{The identifier of the reserved node.}

\item{TargetReservedNodeOfferingId}{The identifier of the target reserved node offering.}
}
\description{
Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read and write operations more quickly than with the classic resize method.

See \url{https://paws-r.github.io/docs/redshift/resize_cluster.html} for full documentation.
}
\keyword{internal}
