% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_db_parameter_group}
\alias{neptune_create_db_parameter_group}
\title{Creates a new DB parameter group}
\usage{
neptune_create_db_parameter_group(
  DBParameterGroupName,
  DBParameterGroupFamily,
  Description,
  Tags = NULL
)
}
\arguments{
\item{DBParameterGroupName}{[required] The name of the DB parameter group.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}

This value is stored as a lowercase string.}

\item{DBParameterGroupFamily}{[required] The DB parameter group family name. A DB parameter group can be
associated with one and only one DB parameter group family, and can be
applied only to a DB instance running a database engine and engine
version compatible with that DB parameter group family.}

\item{Description}{[required] The description for the DB parameter group.}

\item{Tags}{The tags to be assigned to the new DB parameter group.}
}
\description{
Creates a new DB parameter group.

See \url{https://paws-r.github.io/docs/neptune/create_db_parameter_group.html} for full documentation.
}
\keyword{internal}
