% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_db_instance}
\alias{neptune_create_db_instance}
\title{Creates a new DB instance}
\usage{
neptune_create_db_instance(
  DBName = NULL,
  DBInstanceIdentifier,
  AllocatedStorage = NULL,
  DBInstanceClass,
  Engine,
  MasterUsername = NULL,
  MasterUserPassword = NULL,
  DBSecurityGroups = NULL,
  VpcSecurityGroupIds = NULL,
  AvailabilityZone = NULL,
  DBSubnetGroupName = NULL,
  PreferredMaintenanceWindow = NULL,
  DBParameterGroupName = NULL,
  BackupRetentionPeriod = NULL,
  PreferredBackupWindow = NULL,
  Port = NULL,
  MultiAZ = NULL,
  EngineVersion = NULL,
  AutoMinorVersionUpgrade = NULL,
  LicenseModel = NULL,
  Iops = NULL,
  OptionGroupName = NULL,
  CharacterSetName = NULL,
  PubliclyAccessible = NULL,
  Tags = NULL,
  DBClusterIdentifier = NULL,
  StorageType = NULL,
  TdeCredentialArn = NULL,
  TdeCredentialPassword = NULL,
  StorageEncrypted = NULL,
  KmsKeyId = NULL,
  Domain = NULL,
  CopyTagsToSnapshot = NULL,
  MonitoringInterval = NULL,
  MonitoringRoleArn = NULL,
  DomainIAMRoleName = NULL,
  PromotionTier = NULL,
  Timezone = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  EnablePerformanceInsights = NULL,
  PerformanceInsightsKMSKeyId = NULL,
  EnableCloudwatchLogsExports = NULL,
  DeletionProtection = NULL
)
}
\arguments{
\item{DBName}{Not supported.}

\item{DBInstanceIdentifier}{[required] The DB instance identifier. This parameter is stored as a lowercase
string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{mydbinstance}}

\item{AllocatedStorage}{Not supported by Neptune.}

\item{DBInstanceClass}{[required] The compute and memory capacity of the DB instance, for example,
\code{db.m4.large}. Not all DB instance classes are available in all Amazon
Regions.}

\item{Engine}{[required] The name of the database engine to be used for this instance.

Valid Values: \code{neptune}}

\item{MasterUsername}{Not supported by Neptune.}

\item{MasterUserPassword}{Not supported by Neptune.}

\item{DBSecurityGroups}{A list of DB security groups to associate with this DB instance.

Default: The default DB security group for the database engine.}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB instance.

Not applicable. The associated list of EC2 VPC security groups is
managed by the DB cluster. For more information, see
\code{\link[=neptune_create_db_cluster]{create_db_cluster}}.

Default: The default EC2 VPC security group for the DB subnet group's
VPC.}

\item{AvailabilityZone}{The EC2 Availability Zone that the DB instance is created in

Default: A random, system-chosen Availability Zone in the endpoint's
Amazon Region.

Example: \verb{us-east-1d}

Constraint: The AvailabilityZone parameter can't be specified if the
MultiAZ parameter is set to \code{true}. The specified Availability Zone must
be in the same Amazon Region as the current endpoint.}

\item{DBSubnetGroupName}{A DB subnet group to associate with this DB instance.

If there is no DB subnet group, then it is a non-VPC DB instance.}

\item{PreferredMaintenanceWindow}{The time range each week during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Region, occurring on a random day of the
week.

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.
If this argument is omitted, the default DBParameterGroup for the
specified engine is used.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained.

Not applicable. The retention period for automated backups is managed by
the DB cluster. For more information, see
\code{\link[=neptune_create_db_cluster]{create_db_cluster}}.

Default: 1

Constraints:
\itemize{
\item Must be a value from 0 to 35
\item Cannot be set to 0 if the DB instance is a source to Read Replicas
}}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created.

Not applicable. The daily time range for creating automated backups is
managed by the DB cluster. For more information, see
\code{\link[=neptune_create_db_cluster]{create_db_cluster}}.}

\item{Port}{The port number on which the database accepts connections.

Not applicable. The port is managed by the DB cluster. For more
information, see \code{\link[=neptune_create_db_cluster]{create_db_cluster}}.

Default: \code{8182}

Type: Integer}

\item{MultiAZ}{Specifies if the DB instance is a Multi-AZ deployment. You can't set the
AvailabilityZone parameter if the MultiAZ parameter is set to true.}

\item{EngineVersion}{The version number of the database engine to use. Currently, setting
this parameter has no effect.}

\item{AutoMinorVersionUpgrade}{Indicates that minor engine upgrades are applied automatically to the DB
instance during the maintenance window.

Default: \code{true}}

\item{LicenseModel}{License model information for this DB instance.

Valid values: \code{license-included} | \code{bring-your-own-license} |
\code{general-public-license}}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for the DB instance.}

\item{OptionGroupName}{\emph{(Not supported by Neptune)}}

\item{CharacterSetName}{\emph{(Not supported by Neptune)}}

\item{PubliclyAccessible}{This flag should no longer be used.}

\item{Tags}{The tags to assign to the new instance.}

\item{DBClusterIdentifier}{The identifier of the DB cluster that the instance will belong to.

For information on creating a DB cluster, see
\code{\link[=neptune_create_db_cluster]{create_db_cluster}}.

Type: String}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Not applicable. Storage is managed by the DB Cluster.}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.}

\item{StorageEncrypted}{Specifies whether the DB instance is encrypted.

Not applicable. The encryption for DB instances is managed by the DB
cluster. For more information, see
\code{\link[=neptune_create_db_cluster]{create_db_cluster}}.

Default: false}

\item{KmsKeyId}{The Amazon KMS key identifier for an encrypted DB instance.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are creating a DB instance with the same Amazon
account that owns the KMS encryption key used to encrypt the new DB
instance, then you can use the KMS key alias instead of the ARN for the
KM encryption key.

Not applicable. The KMS key identifier is managed by the DB cluster. For
more information, see \code{\link[=neptune_create_db_cluster]{create_db_cluster}}.

If the \code{StorageEncrypted} parameter is true, and you do not specify a
value for the \code{KmsKeyId} parameter, then Amazon Neptune will use your
default encryption key. Amazon KMS creates the default encryption key
for your Amazon account. Your Amazon account has a different default
encryption key for each Amazon Region.}

\item{Domain}{Specify the Active Directory Domain to create the instance in.}

\item{CopyTagsToSnapshot}{True to copy all tags from the DB instance to snapshots of the DB
instance, and otherwise false. The default is false.}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the DB instance. To disable collecting
Enhanced Monitoring metrics, specify 0. The default is 0.

If \code{MonitoringRoleArn} is specified, then you must also set
\code{MonitoringInterval} to a value other than 0.

Valid Values: \verb{0, 1, 5, 10, 15, 30, 60}}

\item{MonitoringRoleArn}{The ARN for the IAM role that permits Neptune to send enhanced
monitoring metrics to Amazon CloudWatch Logs. For example,
\code{arn:aws:iam:123456789012:role/emaccess}.

If \code{MonitoringInterval} is set to a value other than 0, then you must
supply a \code{MonitoringRoleArn} value.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}

\item{PromotionTier}{A value that specifies the order in which an Read Replica is promoted to
the primary instance after a failure of the existing primary instance.

Default: 1

Valid Values: 0 - 15}

\item{Timezone}{The time zone of the DB instance.}

\item{EnableIAMDatabaseAuthentication}{Not supported by Neptune (ignored).}

\item{EnablePerformanceInsights}{\emph{(Not supported by Neptune)}}

\item{PerformanceInsightsKMSKeyId}{\emph{(Not supported by Neptune)}}

\item{EnableCloudwatchLogsExports}{The list of log types that need to be enabled for exporting to
CloudWatch Logs.}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled. See \href{https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html}{Deleting a DB Instance}.

DB instances in a DB cluster can be deleted even when deletion
protection is enabled in their parent DB cluster.}
}
\description{
Creates a new DB instance.

See \url{https://paws-r.github.io/docs/neptune/create_db_instance.html} for full documentation.
}
\keyword{internal}
