# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon DynamoDB Streams
#'
#' @description
#' Amazon DynamoDB
#' 
#' Amazon DynamoDB Streams provides API actions for accessing streams and
#' processing stream records. To learn more about application development
#' with Streams, see [Capturing Table Activity with DynamoDB
#' Streams](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Streams.html)
#' in the Amazon DynamoDB Developer Guide.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- dynamodbstreams(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- dynamodbstreams()
#' # The following example describes a stream with a given stream ARN.
#' svc$describe_stream(
#'   StreamArn = "arn:aws:dynamodb:us-west-2:111122223333:table/Forum/stream/2..."
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=dynamodbstreams_describe_stream]{describe_stream} \tab Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table\cr
#'  \link[=dynamodbstreams_get_records]{get_records} \tab Retrieves the stream records from a given shard\cr
#'  \link[=dynamodbstreams_get_shard_iterator]{get_shard_iterator} \tab Returns a shard iterator\cr
#'  \link[=dynamodbstreams_list_streams]{list_streams} \tab Returns an array of stream ARNs associated with the current account and endpoint
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname dynamodbstreams
#' @export
dynamodbstreams <- function(config = list()) {
  svc <- .dynamodbstreams$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.dynamodbstreams <- list()

.dynamodbstreams$operations <- list()

.dynamodbstreams$metadata <- list(
  service_name = "streams.dynamodb",
  endpoints = list("*" = list(endpoint = "streams.dynamodb.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "streams.dynamodb.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "streams.dynamodb.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "streams.dynamodb.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "DynamoDB Streams",
  api_version = "2012-08-10",
  signing_name = "dynamodb",
  json_version = "1.0",
  target_prefix = "DynamoDBStreams_20120810"
)

.dynamodbstreams$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.dynamodbstreams$metadata, handlers, config)
}
