% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_custom.R
\name{rds_build_auth_token}
\alias{rds_build_auth_token}
\title{Return an authentication token for a database connection}
\usage{
rds_build_auth_token(endpoint, region, user, creds)
}
\arguments{
\item{endpoint}{[required] Hostname and port needed to connect
to the database: \verb{<host>:<port>}.}

\item{region}{[required] AWS region the database is located in.}

\item{user}{[required] User account within the database to sign in
with.}

\item{creds}{Credentials to be signed with.}
}
\description{
Return an authentication token used as the password for a database connection.
}
\details{
See \href{http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{\emph{IAM Database Authentication for MySQL and PostgreSQL}}
for more information on using IAM database authentication with RDS.
}
\section{Request syntax}{
\preformatted{svc$build_auth_token(
  endpoint = "string",
  region = "string",
  user = "string",
  creds = list(
    access_key_id = "string",
    secret_access_key = "string",
    session_token = "string"
  )
)
}
}

\examples{
# This example gets an authentication token for an RDS database, then
# connects to the database using the token.
\dontrun{host <- "database-1.cluster-abcdef123456.us-east-1.rds.amazonaws.com"
port <- 3306
user <- "jane_doe"
token <- svc$build_auth_token(
  endpoint = sprintf("\%s:\%s", host, port),
  region = "us-east-1",
  user = user
)
conn <- DBI::dbConnect(
  drv = RMariaDB::MariaDB(),
  user = user,
  password = token,
  host = host,
  port = port,
  client.flag = RMariaDB::CLIENT_SSL
)}

}
\keyword{internal}
