% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_proxy_target_group}
\alias{rds_modify_db_proxy_target_group}
\title{Modifies the properties of a DBProxyTargetGroup}
\usage{
rds_modify_db_proxy_target_group(TargetGroupName, DBProxyName,
  ConnectionPoolConfig, NewName)
}
\arguments{
\item{TargetGroupName}{[required] The name of the new target group to assign to the proxy.}

\item{DBProxyName}{[required] The name of the new proxy to which to assign the target group.}

\item{ConnectionPoolConfig}{The settings that determine the size and behavior of the connection pool
for the target group.}

\item{NewName}{The new name for the modified \code{DBProxyTarget}. An identifier must begin
with a letter and must contain only ASCII letters, digits, and hyphens;
it can't end with a hyphen or contain two consecutive hyphens.}
}
\description{
Modifies the properties of a \code{DBProxyTargetGroup}.
}
\section{Request syntax}{
\preformatted{svc$modify_db_proxy_target_group(
  TargetGroupName = "string",
  DBProxyName = "string",
  ConnectionPoolConfig = list(
    MaxConnectionsPercent = 123,
    MaxIdleConnectionsPercent = 123,
    ConnectionBorrowTimeout = 123,
    SessionPinningFilters = list(
      "string"
    ),
    InitQuery = "string"
  ),
  NewName = "string"
)
}
}

\keyword{internal}
