% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_list_global_tables}
\alias{dynamodb_list_global_tables}
\title{Lists all global tables that have a replica in the specified Region}
\usage{
dynamodb_list_global_tables(ExclusiveStartGlobalTableName, Limit,
  RegionName)
}
\arguments{
\item{ExclusiveStartGlobalTableName}{The first global table name that this operation will evaluate.}

\item{Limit}{The maximum number of table names to return, if the parameter is not
specified DynamoDB defaults to 100.

If the number of global tables DynamoDB finds reaches this limit, it
stops the operation and returns the table names collected up to that
point, with a table name in the \code{LastEvaluatedGlobalTableName} to apply
in a subsequent operation to the \code{ExclusiveStartGlobalTableName}
parameter.}

\item{RegionName}{Lists the global tables in a specific Region.}
}
\description{
Lists all global tables that have a replica in the specified Region.

This operation only applies to \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html}{Version 2017.11.29}
of global tables.
}
\section{Request syntax}{
\preformatted{svc$list_global_tables(
  ExclusiveStartGlobalTableName = "string",
  Limit = 123,
  RegionName = "string"
)
}
}

\keyword{internal}
