% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_claim_phone_number}
\alias{connect_claim_phone_number}
\title{Claims an available phone number to your Amazon Connect instance or
traffic distribution group}
\usage{
connect_claim_phone_number(
  TargetArn = NULL,
  InstanceId = NULL,
  PhoneNumber,
  PhoneNumberDescription = NULL,
  Tags = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{TargetArn}{The Amazon Resource Name (ARN) for Amazon Connect instances or traffic
distribution groups that phone number inbound traffic is routed through.
You must enter \code{InstanceId} or \code{TargetArn}.}

\item{InstanceId}{The identifier of the Amazon Connect instance that phone numbers are
claimed to. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance. You must enter
\code{InstanceId} or \code{TargetArn}.}

\item{PhoneNumber}{[required] The phone number you want to claim. Phone numbers are formatted
\verb{[+] [country code] [subscriber number including area code]}.}

\item{PhoneNumberDescription}{The description of the phone number.}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.

Pattern:
\verb{^[a-f0-9]\{8\}-[a-f0-9]\{4\}-[a-f0-9]\{4\}-[a-f0-9]\{4\}-[a-f0-9]\{12\}$}}
}
\description{
Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group was created.

See \url{https://www.paws-r-sdk.com/docs/connect_claim_phone_number/} for full documentation.
}
\keyword{internal}
