% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesv2_operations.R
\name{sesv2_put_email_identity_feedback_attributes}
\alias{sesv2_put_email_identity_feedback_attributes}
\title{Used to enable or disable feedback forwarding for an identity}
\usage{
sesv2_put_email_identity_feedback_attributes(
  EmailIdentity,
  EmailForwardingEnabled = NULL
)
}
\arguments{
\item{EmailIdentity}{[required] The email identity.}

\item{EmailForwardingEnabled}{Sets the feedback forwarding configuration for the identity.

If the value is \code{true}, you receive email notifications when bounce or
complaint events occur. These notifications are sent to the address that
you specified in the \code{Return-Path} header of the original email.

You're required to have a method of tracking bounces and complaints. If
you haven't set up another mechanism for receiving bounce or complaint
notifications (for example, by setting up an event destination), you
receive an email notification when these events occur (even if this
setting is disabled).}
}
\description{
Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.

See \url{https://www.paws-r-sdk.com/docs/sesv2_put_email_identity_feedback_attributes/} for full documentation.
}
\keyword{internal}
