% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_tags_for_resource}
\alias{connect_list_tags_for_resource}
\title{Lists the tags for the specified resource}
\usage{
connect_list_tags_for_resource(resourceArn)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the resource.}
}
\value{
A list with the following syntax:\preformatted{list(
  tags = list(
    "string"
  )
)
}
}
\description{
Lists the tags for the specified resource.

For sample policies that use tags, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html}{Amazon Connect Identity-Based Policy Examples}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  resourceArn = "string"
)
}
}

\keyword{internal}
