% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_list_receipt_rule_sets}
\alias{ses_list_receipt_rule_sets}
\title{Lists the receipt rule sets that exist under your AWS account in the
current AWS Region}
\usage{
ses_list_receipt_rule_sets(NextToken)
}
\arguments{
\item{NextToken}{A token returned from a previous call to \code{ListReceiptRuleSets} to
indicate the position in the receipt rule set list.}
}
\description{
Lists the receipt rule sets that exist under your AWS account in the
current AWS Region. If there are additional receipt rule sets to be
retrieved, you will receive a \code{NextToken} that you can provide to the
next call to \code{ListReceiptRuleSets} to retrieve the additional entries.
}
\details{
For information about managing receipt rule sets, see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$list_receipt_rule_sets(
  NextToken = "string"
)
}
}

\examples{
# The following example lists the receipt rule sets that exist under an
# AWS account:
\donttest{svc$list_receipt_rule_sets(
  NextToken = ""
)}

}
\keyword{internal}
