% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_anomalies}
\alias{costexplorer_get_anomalies}
\title{Retrieves all of the cost anomalies detected on your account during the
time period that's specified by the DateInterval object}
\usage{
costexplorer_get_anomalies(
  MonitorArn = NULL,
  DateInterval,
  Feedback = NULL,
  TotalImpact = NULL,
  NextPageToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{MonitorArn}{Retrieves all of the cost anomalies detected for a specific cost anomaly
monitor Amazon Resource Name (ARN).}

\item{DateInterval}{[required] Assigns the start and end dates for retrieving cost anomalies. The
returned anomaly object will have an \code{AnomalyEndDate} in the specified
time range.}

\item{Feedback}{Filters anomaly results by the feedback field on the anomaly object.}

\item{TotalImpact}{Filters anomaly results by the total impact field on the anomaly object.
For example, you can filter anomalies \verb{GREATER_THAN 200.00} to retrieve
anomalies, with an estimated dollar impact greater than 200.}

\item{NextPageToken}{The token to retrieve the next set of results. Amazon Web Services
provides the token when the response from a previous call has more
results than the maximum page size.}

\item{MaxResults}{The number of entries a paginated response contains.}
}
\description{
Retrieves all of the cost anomalies detected on your account during the time period that's specified by the \code{DateInterval} object.

See \url{https://paws-r.github.io/docs/costexplorer/get_anomalies.html} for full documentation.
}
\keyword{internal}
