% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_export_ecs_service_recommendations}
\alias{computeoptimizer_export_ecs_service_recommendations}
\title{Exports optimization recommendations for Amazon ECS services on Fargate}
\usage{
computeoptimizer_export_ecs_service_recommendations(
  accountIds = NULL,
  filters = NULL,
  fieldsToExport = NULL,
  s3DestinationConfig,
  fileFormat = NULL,
  includeMemberAccounts = NULL
)
}
\arguments{
\item{accountIds}{The Amazon Web Services account IDs for the export Amazon ECS service
recommendations.

If your account is the management account or the delegated administrator
of an organization, use this parameter to specify the member account you
want to export recommendations to.

This parameter can't be specified together with the include member
accounts parameter. The parameters are mutually exclusive.

If this parameter or the include member accounts parameter is omitted,
the recommendations for member accounts aren't included in the export.

You can specify multiple account IDs per request.}

\item{filters}{An array of objects to specify a filter that exports a more specific set
of Amazon ECS service recommendations.}

\item{fieldsToExport}{The recommendations data to include in the export file. For more
information about the fields that can be exported, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files}{Exported files}
in the \emph{Compute Optimizer User Guide}.}

\item{s3DestinationConfig}{[required]}

\item{fileFormat}{The format of the export file.

The CSV file is the only export file format currently supported.}

\item{includeMemberAccounts}{If your account is the management account or the delegated administrator
of an organization, this parameter indicates whether to include
recommendations for resources in all member accounts of the
organization.

The member accounts must also be opted in to Compute Optimizer, and
trusted access for Compute Optimizer must be enabled in the organization
account. For more information, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access}{Compute Optimizer and Amazon Web Services Organizations trusted access}
in the \emph{Compute Optimizer User Guide}.

If this parameter is omitted, recommendations for member accounts of the
organization aren't included in the export file.

If this parameter or the account ID parameter is omitted,
recommendations for member accounts aren't included in the export.}
}
\description{
Exports optimization recommendations for Amazon ECS services on Fargate.

See \url{https://www.paws-r-sdk.com/docs/computeoptimizer_export_ecs_service_recommendations/} for full documentation.
}
\keyword{internal}
