# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include proton_service.R
NULL

#' In a management account, an environment account connection request is
#' accepted
#'
#' @description
#' In a management account, an environment account connection request is accepted. When the environment account connection request is accepted, Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_accept_environment_account_connection/](https://www.paws-r-sdk.com/docs/proton_accept_environment_account_connection/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the environment account connection.
#'
#' @keywords internal
#'
#' @rdname proton_accept_environment_account_connection
proton_accept_environment_account_connection <- function(id) {
  op <- new_operation(
    name = "AcceptEnvironmentAccountConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$accept_environment_account_connection_input(id = id)
  output <- .proton$accept_environment_account_connection_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$accept_environment_account_connection <- proton_accept_environment_account_connection

#' Attempts to cancel a component deployment (for a component that is in
#' the IN_PROGRESS deployment status)
#'
#' @description
#' Attempts to cancel a component deployment (for a component that is in the `IN_PROGRESS` deployment status).
#'
#' See [https://www.paws-r-sdk.com/docs/proton_cancel_component_deployment/](https://www.paws-r-sdk.com/docs/proton_cancel_component_deployment/) for full documentation.
#'
#' @param componentName &#91;required&#93; The name of the component with the deployment to cancel.
#'
#' @keywords internal
#'
#' @rdname proton_cancel_component_deployment
proton_cancel_component_deployment <- function(componentName) {
  op <- new_operation(
    name = "CancelComponentDeployment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$cancel_component_deployment_input(componentName = componentName)
  output <- .proton$cancel_component_deployment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$cancel_component_deployment <- proton_cancel_component_deployment

#' Attempts to cancel an environment deployment on an UpdateEnvironment
#' action, if the deployment is IN_PROGRESS
#'
#' @description
#' Attempts to cancel an environment deployment on an [`update_environment`][proton_update_environment] action, if the deployment is `IN_PROGRESS`. For more information, see [Update an environment](https://docs.aws.amazon.com/proton/latest/userguide/ag-env-update.html) in the *Proton User guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_cancel_environment_deployment/](https://www.paws-r-sdk.com/docs/proton_cancel_environment_deployment/) for full documentation.
#'
#' @param environmentName &#91;required&#93; The name of the environment with the deployment to cancel.
#'
#' @keywords internal
#'
#' @rdname proton_cancel_environment_deployment
proton_cancel_environment_deployment <- function(environmentName) {
  op <- new_operation(
    name = "CancelEnvironmentDeployment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$cancel_environment_deployment_input(environmentName = environmentName)
  output <- .proton$cancel_environment_deployment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$cancel_environment_deployment <- proton_cancel_environment_deployment

#' Attempts to cancel a service instance deployment on an
#' UpdateServiceInstance action, if the deployment is IN_PROGRESS
#'
#' @description
#' Attempts to cancel a service instance deployment on an [`update_service_instance`][proton_update_service_instance] action, if the deployment is `IN_PROGRESS`. For more information, see [Update a service instance](https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-instance-update.html) in the *Proton User guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_cancel_service_instance_deployment/](https://www.paws-r-sdk.com/docs/proton_cancel_service_instance_deployment/) for full documentation.
#'
#' @param serviceInstanceName &#91;required&#93; The name of the service instance with the deployment to cancel.
#' @param serviceName &#91;required&#93; The name of the service with the service instance deployment to cancel.
#'
#' @keywords internal
#'
#' @rdname proton_cancel_service_instance_deployment
proton_cancel_service_instance_deployment <- function(serviceInstanceName, serviceName) {
  op <- new_operation(
    name = "CancelServiceInstanceDeployment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$cancel_service_instance_deployment_input(serviceInstanceName = serviceInstanceName, serviceName = serviceName)
  output <- .proton$cancel_service_instance_deployment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$cancel_service_instance_deployment <- proton_cancel_service_instance_deployment

#' Attempts to cancel a service pipeline deployment on an
#' UpdateServicePipeline action, if the deployment is IN_PROGRESS
#'
#' @description
#' Attempts to cancel a service pipeline deployment on an [`update_service_pipeline`][proton_update_service_pipeline] action, if the deployment is `IN_PROGRESS`. For more information, see [Update a service pipeline](https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-pipeline-update.html) in the *Proton User guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_cancel_service_pipeline_deployment/](https://www.paws-r-sdk.com/docs/proton_cancel_service_pipeline_deployment/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the service with the service pipeline deployment to cancel.
#'
#' @keywords internal
#'
#' @rdname proton_cancel_service_pipeline_deployment
proton_cancel_service_pipeline_deployment <- function(serviceName) {
  op <- new_operation(
    name = "CancelServicePipelineDeployment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$cancel_service_pipeline_deployment_input(serviceName = serviceName)
  output <- .proton$cancel_service_pipeline_deployment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$cancel_service_pipeline_deployment <- proton_cancel_service_pipeline_deployment

#' Create an Proton component
#'
#' @description
#' Create an Proton component. A component is an infrastructure extension for a service instance.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_component/](https://www.paws-r-sdk.com/docs/proton_create_component/) for full documentation.
#'
#' @param clientToken The client token for the created component.
#' @param description An optional customer-provided description of the component.
#' @param environmentName The name of the Proton environment that you want to associate this
#' component with. You must specify this when you don't specify
#' `serviceInstanceName` and `serviceName`.
#' @param manifest &#91;required&#93; A path to a manifest file that lists the Infrastructure as Code (IaC)
#' file, template language, and rendering engine for infrastructure that a
#' custom component provisions.
#' @param name &#91;required&#93; The customer-provided name of the component.
#' @param serviceInstanceName The name of the service instance that you want to attach this component
#' to. If you don't specify this, the component isn't attached to any
#' service instance. Specify both `serviceInstanceName` and `serviceName`
#' or neither of them.
#' @param serviceName The name of the service that `serviceInstanceName` is associated with.
#' If you don't specify this, the component isn't attached to any service
#' instance. Specify both `serviceInstanceName` and `serviceName` or
#' neither of them.
#' @param serviceSpec The service spec that you want the component to use to access service
#' inputs. Set this only when you attach the component to a service
#' instance.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton component. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#' @param templateFile &#91;required&#93; A path to the Infrastructure as Code (IaC) file describing
#' infrastructure that a custom component provisions.
#' 
#' Components support a single IaC file, even if you use Terraform as your
#' template language.
#'
#' @keywords internal
#'
#' @rdname proton_create_component
proton_create_component <- function(clientToken = NULL, description = NULL, environmentName = NULL, manifest, name, serviceInstanceName = NULL, serviceName = NULL, serviceSpec = NULL, tags = NULL, templateFile) {
  op <- new_operation(
    name = "CreateComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_component_input(clientToken = clientToken, description = description, environmentName = environmentName, manifest = manifest, name = name, serviceInstanceName = serviceInstanceName, serviceName = serviceName, serviceSpec = serviceSpec, tags = tags, templateFile = templateFile)
  output <- .proton$create_component_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_component <- proton_create_component

#' Deploy a new environment
#'
#' @description
#' Deploy a new environment. An Proton environment is created from an environment template that defines infrastructure and resources that can be shared across services.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_environment/](https://www.paws-r-sdk.com/docs/proton_create_environment/) for full documentation.
#'
#' @param codebuildRoleArn The Amazon Resource Name (ARN) of the IAM service role that allows
#' Proton to provision infrastructure using CodeBuild-based provisioning on
#' your behalf.
#' 
#' To use CodeBuild-based provisioning for the environment or for any
#' service instance running in the environment, specify either the
#' `environmentAccountConnectionId` or `codebuildRoleArn` parameter.
#' @param componentRoleArn The Amazon Resource Name (ARN) of the IAM service role that Proton uses
#' when provisioning directly defined components in this environment. It
#' determines the scope of infrastructure that a component can provision.
#' 
#' You must specify `componentRoleArn` to allow directly defined components
#' to be associated with this environment.
#' 
#' For more information about components, see [Proton
#' components](https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
#' in the *Proton User Guide*.
#' @param description A description of the environment that's being created and deployed.
#' @param environmentAccountConnectionId The ID of the environment account connection that you provide if you're
#' provisioning your environment infrastructure resources to an environment
#' account. For more information, see [Environment account
#' connections](https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
#' in the *Proton User guide*.
#' 
#' To use Amazon Web Services-managed provisioning for the environment,
#' specify either the `environmentAccountConnectionId` or
#' `protonServiceRoleArn` parameter and omit the `provisioningRepository`
#' parameter.
#' @param name &#91;required&#93; The name of the environment.
#' @param protonServiceRoleArn The Amazon Resource Name (ARN) of the Proton service role that allows
#' Proton to make calls to other services on your behalf.
#' 
#' To use Amazon Web Services-managed provisioning for the environment,
#' specify either the `environmentAccountConnectionId` or
#' `protonServiceRoleArn` parameter and omit the `provisioningRepository`
#' parameter.
#' @param provisioningRepository The linked repository that you use to host your rendered infrastructure
#' templates for self-managed provisioning. A linked repository is a
#' repository that has been registered with Proton. For more information,
#' see [`create_repository`][proton_create_repository].
#' 
#' To use self-managed provisioning for the environment, specify this
#' parameter and omit the `environmentAccountConnectionId` and
#' `protonServiceRoleArn` parameters.
#' @param spec &#91;required&#93; A YAML formatted string that provides inputs as defined in the
#' environment template bundle schema file. For more information, see
#' [Environments](https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html)
#' in the *Proton User Guide*.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton environment. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#' @param templateMajorVersion &#91;required&#93; The major version of the environment template.
#' @param templateMinorVersion The minor version of the environment template.
#' @param templateName &#91;required&#93; The name of the environment template. For more information, see
#' [Environment
#' Templates](https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html)
#' in the *Proton User Guide*.
#'
#' @keywords internal
#'
#' @rdname proton_create_environment
proton_create_environment <- function(codebuildRoleArn = NULL, componentRoleArn = NULL, description = NULL, environmentAccountConnectionId = NULL, name, protonServiceRoleArn = NULL, provisioningRepository = NULL, spec, tags = NULL, templateMajorVersion, templateMinorVersion = NULL, templateName) {
  op <- new_operation(
    name = "CreateEnvironment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_environment_input(codebuildRoleArn = codebuildRoleArn, componentRoleArn = componentRoleArn, description = description, environmentAccountConnectionId = environmentAccountConnectionId, name = name, protonServiceRoleArn = protonServiceRoleArn, provisioningRepository = provisioningRepository, spec = spec, tags = tags, templateMajorVersion = templateMajorVersion, templateMinorVersion = templateMinorVersion, templateName = templateName)
  output <- .proton$create_environment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_environment <- proton_create_environment

#' Create an environment account connection in an environment account so
#' that environment infrastructure resources can be provisioned in the
#' environment account from a management account
#'
#' @description
#' Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the environment account from a management account.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_environment_account_connection/](https://www.paws-r-sdk.com/docs/proton_create_environment_account_connection/) for full documentation.
#'
#' @param clientToken When included, if two identical requests are made with the same client
#' token, Proton returns the environment account connection that the first
#' request created.
#' @param codebuildRoleArn The Amazon Resource Name (ARN) of an IAM service role in the environment
#' account. Proton uses this role to provision infrastructure resources
#' using CodeBuild-based provisioning in the associated environment
#' account.
#' @param componentRoleArn The Amazon Resource Name (ARN) of the IAM service role that Proton uses
#' when provisioning directly defined components in the associated
#' environment account. It determines the scope of infrastructure that a
#' component can provision in the account.
#' 
#' You must specify `componentRoleArn` to allow directly defined components
#' to be associated with any environments running in this account.
#' 
#' For more information about components, see [Proton
#' components](https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
#' in the *Proton User Guide*.
#' @param environmentName &#91;required&#93; The name of the Proton environment that's created in the associated
#' management account.
#' @param managementAccountId &#91;required&#93; The ID of the management account that accepts or rejects the environment
#' account connection. You create and manage the Proton environment in this
#' account. If the management account accepts the environment account
#' connection, Proton can use the associated IAM role to provision
#' environment infrastructure resources in the associated environment
#' account.
#' @param roleArn The Amazon Resource Name (ARN) of the IAM service role that's created in
#' the environment account. Proton uses this role to provision
#' infrastructure resources in the associated environment account.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton environment account connection. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#'
#' @keywords internal
#'
#' @rdname proton_create_environment_account_connection
proton_create_environment_account_connection <- function(clientToken = NULL, codebuildRoleArn = NULL, componentRoleArn = NULL, environmentName, managementAccountId, roleArn = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateEnvironmentAccountConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_environment_account_connection_input(clientToken = clientToken, codebuildRoleArn = codebuildRoleArn, componentRoleArn = componentRoleArn, environmentName = environmentName, managementAccountId = managementAccountId, roleArn = roleArn, tags = tags)
  output <- .proton$create_environment_account_connection_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_environment_account_connection <- proton_create_environment_account_connection

#' Create an environment template for Proton
#'
#' @description
#' Create an environment template for Proton. For more information, see [Environment Templates](https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html) in the *Proton User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_environment_template/](https://www.paws-r-sdk.com/docs/proton_create_environment_template/) for full documentation.
#'
#' @param description A description of the environment template.
#' @param displayName The environment template name as displayed in the developer interface.
#' @param encryptionKey A customer provided encryption key that Proton uses to encrypt data.
#' @param name &#91;required&#93; The name of the environment template.
#' @param provisioning When included, indicates that the environment template is for customer
#' provisioned and managed infrastructure.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton environment template. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#'
#' @keywords internal
#'
#' @rdname proton_create_environment_template
proton_create_environment_template <- function(description = NULL, displayName = NULL, encryptionKey = NULL, name, provisioning = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateEnvironmentTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_environment_template_input(description = description, displayName = displayName, encryptionKey = encryptionKey, name = name, provisioning = provisioning, tags = tags)
  output <- .proton$create_environment_template_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_environment_template <- proton_create_environment_template

#' Create a new major or minor version of an environment template
#'
#' @description
#' Create a new major or minor version of an environment template. A major version of an environment template is a version that *isn't* backwards compatible. A minor version of an environment template is a version that's backwards compatible within its major version.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_environment_template_version/](https://www.paws-r-sdk.com/docs/proton_create_environment_template_version/) for full documentation.
#'
#' @param clientToken When included, if two identical requests are made with the same client
#' token, Proton returns the environment template version that the first
#' request created.
#' @param description A description of the new version of an environment template.
#' @param majorVersion To create a new minor version of the environment template, include
#' `major Version`.
#' 
#' To create a new major and minor version of the environment template,
#' exclude `major Version`.
#' @param source &#91;required&#93; An object that includes the template bundle S3 bucket path and name for
#' the new version of an template.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton environment template version. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#' @param templateName &#91;required&#93; The name of the environment template.
#'
#' @keywords internal
#'
#' @rdname proton_create_environment_template_version
proton_create_environment_template_version <- function(clientToken = NULL, description = NULL, majorVersion = NULL, source, tags = NULL, templateName) {
  op <- new_operation(
    name = "CreateEnvironmentTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_environment_template_version_input(clientToken = clientToken, description = description, majorVersion = majorVersion, source = source, tags = tags, templateName = templateName)
  output <- .proton$create_environment_template_version_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_environment_template_version <- proton_create_environment_template_version

#' Create and register a link to a repository
#'
#' @description
#' Create and register a link to a repository. Proton uses the link to repeatedly access the repository, to either push to it (self-managed provisioning) or pull from it (template sync). You can share a linked repository across multiple resources (like environments using self-managed provisioning, or synced templates). When you create a repository link, Proton creates a [service-linked role](https://docs.aws.amazon.com/proton/latest/userguide/using-service-linked-roles.html) for you.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_repository/](https://www.paws-r-sdk.com/docs/proton_create_repository/) for full documentation.
#'
#' @param connectionArn &#91;required&#93; The Amazon Resource Name (ARN) of your AWS CodeStar connection that
#' connects Proton to your repository provider account. For more
#' information, see [Setting up for
#' Proton](https://docs.aws.amazon.com/proton/latest/userguide/setting-up-for-service.html)
#' in the *Proton User Guide*.
#' @param encryptionKey The ARN of your customer Amazon Web Services Key Management Service
#' (Amazon Web Services KMS) key.
#' @param name &#91;required&#93; The repository name (for example, `myrepos/myrepo`).
#' @param provider &#91;required&#93; The repository provider.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton repository. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#'
#' @keywords internal
#'
#' @rdname proton_create_repository
proton_create_repository <- function(connectionArn, encryptionKey = NULL, name, provider, tags = NULL) {
  op <- new_operation(
    name = "CreateRepository",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_repository_input(connectionArn = connectionArn, encryptionKey = encryptionKey, name = name, provider = provider, tags = tags)
  output <- .proton$create_repository_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_repository <- proton_create_repository

#' Create an Proton service
#'
#' @description
#' Create an Proton service. An Proton service is an instantiation of a service template and often includes several service instances and pipeline. For more information, see [Services](https://docs.aws.amazon.com/proton/latest/userguide/ag-services.html) in the *Proton User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_service/](https://www.paws-r-sdk.com/docs/proton_create_service/) for full documentation.
#'
#' @param branchName The name of the code repository branch that holds the code that's
#' deployed in Proton. *Don't* include this parameter if your service
#' template *doesn't* include a service pipeline.
#' @param description A description of the Proton service.
#' @param name &#91;required&#93; The service name.
#' @param repositoryConnectionArn The Amazon Resource Name (ARN) of the repository connection. For more
#' information, see [Setting up an AWS CodeStar
#' connection](https://docs.aws.amazon.com/proton/latest/userguide/setting-up-for-service.html#setting-up-vcontrol)
#' in the *Proton User Guide*. *Don't* include this parameter if your
#' service template *doesn't* include a service pipeline.
#' @param repositoryId The ID of the code repository. *Don't* include this parameter if your
#' service template *doesn't* include a service pipeline.
#' @param spec &#91;required&#93; A link to a spec file that provides inputs as defined in the service
#' template bundle schema file. The spec file is in YAML format. *Don’t*
#' include pipeline inputs in the spec if your service template *doesn’t*
#' include a service pipeline. For more information, see [Create a
#' service](https://docs.aws.amazon.com/proton/latest/userguide/ag-create-svc.html)
#' in the *Proton User Guide*.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton service. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#' @param templateMajorVersion &#91;required&#93; The major version of the service template that was used to create the
#' service.
#' @param templateMinorVersion The minor version of the service template that was used to create the
#' service.
#' @param templateName &#91;required&#93; The name of the service template that's used to create the service.
#'
#' @keywords internal
#'
#' @rdname proton_create_service
proton_create_service <- function(branchName = NULL, description = NULL, name, repositoryConnectionArn = NULL, repositoryId = NULL, spec, tags = NULL, templateMajorVersion, templateMinorVersion = NULL, templateName) {
  op <- new_operation(
    name = "CreateService",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_service_input(branchName = branchName, description = description, name = name, repositoryConnectionArn = repositoryConnectionArn, repositoryId = repositoryId, spec = spec, tags = tags, templateMajorVersion = templateMajorVersion, templateMinorVersion = templateMinorVersion, templateName = templateName)
  output <- .proton$create_service_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_service <- proton_create_service

#' Create a service instance
#'
#' @description
#' Create a service instance.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_service_instance/](https://www.paws-r-sdk.com/docs/proton_create_service_instance/) for full documentation.
#'
#' @param clientToken The client token of the service instance to create.
#' @param name &#91;required&#93; The name of the service instance to create.
#' @param serviceName &#91;required&#93; The name of the service the service instance is added to.
#' @param spec &#91;required&#93; The spec for the service instance you want to create.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton service instance. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#' @param templateMajorVersion To create a new major and minor version of the service template,
#' *exclude* `major Version`.
#' @param templateMinorVersion To create a new minor version of the service template, include a
#' `major Version`.
#'
#' @keywords internal
#'
#' @rdname proton_create_service_instance
proton_create_service_instance <- function(clientToken = NULL, name, serviceName, spec, tags = NULL, templateMajorVersion = NULL, templateMinorVersion = NULL) {
  op <- new_operation(
    name = "CreateServiceInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_service_instance_input(clientToken = clientToken, name = name, serviceName = serviceName, spec = spec, tags = tags, templateMajorVersion = templateMajorVersion, templateMinorVersion = templateMinorVersion)
  output <- .proton$create_service_instance_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_service_instance <- proton_create_service_instance

#' Create the Proton Ops configuration file
#'
#' @description
#' Create the Proton Ops configuration file.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_service_sync_config/](https://www.paws-r-sdk.com/docs/proton_create_service_sync_config/) for full documentation.
#'
#' @param branch &#91;required&#93; The repository branch for your Proton Ops file.
#' @param filePath &#91;required&#93; The path to the Proton Ops file.
#' @param repositoryName &#91;required&#93; The repository name.
#' @param repositoryProvider &#91;required&#93; The provider type for your repository.
#' @param serviceName &#91;required&#93; The name of the service the Proton Ops file is for.
#'
#' @keywords internal
#'
#' @rdname proton_create_service_sync_config
proton_create_service_sync_config <- function(branch, filePath, repositoryName, repositoryProvider, serviceName) {
  op <- new_operation(
    name = "CreateServiceSyncConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_service_sync_config_input(branch = branch, filePath = filePath, repositoryName = repositoryName, repositoryProvider = repositoryProvider, serviceName = serviceName)
  output <- .proton$create_service_sync_config_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_service_sync_config <- proton_create_service_sync_config

#' Create a service template
#'
#' @description
#' Create a service template. The administrator creates a service template to define standardized infrastructure and an optional CI/CD service pipeline. Developers, in turn, select the service template from Proton. If the selected service template includes a service pipeline definition, they provide a link to their source code repository. Proton then deploys and manages the infrastructure defined by the selected service template. For more information, see [Proton templates](https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html) in the *Proton User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_service_template/](https://www.paws-r-sdk.com/docs/proton_create_service_template/) for full documentation.
#'
#' @param description A description of the service template.
#' @param displayName The name of the service template as displayed in the developer
#' interface.
#' @param encryptionKey A customer provided encryption key that's used to encrypt data.
#' @param name &#91;required&#93; The name of the service template.
#' @param pipelineProvisioning By default, Proton provides a service pipeline for your service. When
#' this parameter is included, it indicates that an Proton service pipeline
#' *isn't* provided for your service. After it's included, it *can't* be
#' changed. For more information, see [Template
#' bundles](https://docs.aws.amazon.com/proton/latest/userguide/ag-template-authoring.html#ag-template-bundles)
#' in the *Proton User Guide*.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton service template. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#'
#' @keywords internal
#'
#' @rdname proton_create_service_template
proton_create_service_template <- function(description = NULL, displayName = NULL, encryptionKey = NULL, name, pipelineProvisioning = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateServiceTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_service_template_input(description = description, displayName = displayName, encryptionKey = encryptionKey, name = name, pipelineProvisioning = pipelineProvisioning, tags = tags)
  output <- .proton$create_service_template_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_service_template <- proton_create_service_template

#' Create a new major or minor version of a service template
#'
#' @description
#' Create a new major or minor version of a service template. A major version of a service template is a version that *isn't* backward compatible. A minor version of a service template is a version that's backward compatible within its major version.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_service_template_version/](https://www.paws-r-sdk.com/docs/proton_create_service_template_version/) for full documentation.
#'
#' @param clientToken When included, if two identical requests are made with the same client
#' token, Proton returns the service template version that the first
#' request created.
#' @param compatibleEnvironmentTemplates &#91;required&#93; An array of environment template objects that are compatible with the
#' new service template version. A service instance based on this service
#' template version can run in environments based on compatible templates.
#' @param description A description of the new version of a service template.
#' @param majorVersion To create a new minor version of the service template, include a
#' `major Version`.
#' 
#' To create a new major and minor version of the service template,
#' *exclude* `major Version`.
#' @param source &#91;required&#93; An object that includes the template bundle S3 bucket path and name for
#' the new version of a service template.
#' @param supportedComponentSources An array of supported component sources. Components with supported
#' sources can be attached to service instances based on this service
#' template version.
#' 
#' For more information about components, see [Proton
#' components](https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
#' in the *Proton User Guide*.
#' @param tags An optional list of metadata items that you can associate with the
#' Proton service template version. A tag is a key-value pair.
#' 
#' For more information, see [Proton resources and
#' tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
#' in the *Proton User Guide*.
#' @param templateName &#91;required&#93; The name of the service template.
#'
#' @keywords internal
#'
#' @rdname proton_create_service_template_version
proton_create_service_template_version <- function(clientToken = NULL, compatibleEnvironmentTemplates, description = NULL, majorVersion = NULL, source, supportedComponentSources = NULL, tags = NULL, templateName) {
  op <- new_operation(
    name = "CreateServiceTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_service_template_version_input(clientToken = clientToken, compatibleEnvironmentTemplates = compatibleEnvironmentTemplates, description = description, majorVersion = majorVersion, source = source, supportedComponentSources = supportedComponentSources, tags = tags, templateName = templateName)
  output <- .proton$create_service_template_version_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_service_template_version <- proton_create_service_template_version

#' Set up a template to create new template versions automatically by
#' tracking a linked repository
#'
#' @description
#' Set up a template to create new template versions automatically by tracking a linked repository. A linked repository is a repository that has been registered with Proton. For more information, see [`create_repository`][proton_create_repository].
#'
#' See [https://www.paws-r-sdk.com/docs/proton_create_template_sync_config/](https://www.paws-r-sdk.com/docs/proton_create_template_sync_config/) for full documentation.
#'
#' @param branch &#91;required&#93; The repository branch for your template.
#' @param repositoryName &#91;required&#93; The repository name (for example, `myrepos/myrepo`).
#' @param repositoryProvider &#91;required&#93; The provider type for your repository.
#' @param subdirectory A repository subdirectory path to your template bundle directory. When
#' included, Proton limits the template bundle search to this repository
#' directory.
#' @param templateName &#91;required&#93; The name of your registered template.
#' @param templateType &#91;required&#93; The type of the registered template.
#'
#' @keywords internal
#'
#' @rdname proton_create_template_sync_config
proton_create_template_sync_config <- function(branch, repositoryName, repositoryProvider, subdirectory = NULL, templateName, templateType) {
  op <- new_operation(
    name = "CreateTemplateSyncConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$create_template_sync_config_input(branch = branch, repositoryName = repositoryName, repositoryProvider = repositoryProvider, subdirectory = subdirectory, templateName = templateName, templateType = templateType)
  output <- .proton$create_template_sync_config_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$create_template_sync_config <- proton_create_template_sync_config

#' Delete an Proton component resource
#'
#' @description
#' Delete an Proton component resource.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_component/](https://www.paws-r-sdk.com/docs/proton_delete_component/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the component to delete.
#'
#' @keywords internal
#'
#' @rdname proton_delete_component
proton_delete_component <- function(name) {
  op <- new_operation(
    name = "DeleteComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_component_input(name = name)
  output <- .proton$delete_component_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_component <- proton_delete_component

#' Delete the deployment
#'
#' @description
#' Delete the deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_deployment/](https://www.paws-r-sdk.com/docs/proton_delete_deployment/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the deployment to delete.
#'
#' @keywords internal
#'
#' @rdname proton_delete_deployment
proton_delete_deployment <- function(id) {
  op <- new_operation(
    name = "DeleteDeployment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_deployment_input(id = id)
  output <- .proton$delete_deployment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_deployment <- proton_delete_deployment

#' Delete an environment
#'
#' @description
#' Delete an environment.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_environment/](https://www.paws-r-sdk.com/docs/proton_delete_environment/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the environment to delete.
#'
#' @keywords internal
#'
#' @rdname proton_delete_environment
proton_delete_environment <- function(name) {
  op <- new_operation(
    name = "DeleteEnvironment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_environment_input(name = name)
  output <- .proton$delete_environment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_environment <- proton_delete_environment

#' In an environment account, delete an environment account connection
#'
#' @description
#' In an environment account, delete an environment account connection.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_environment_account_connection/](https://www.paws-r-sdk.com/docs/proton_delete_environment_account_connection/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the environment account connection to delete.
#'
#' @keywords internal
#'
#' @rdname proton_delete_environment_account_connection
proton_delete_environment_account_connection <- function(id) {
  op <- new_operation(
    name = "DeleteEnvironmentAccountConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_environment_account_connection_input(id = id)
  output <- .proton$delete_environment_account_connection_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_environment_account_connection <- proton_delete_environment_account_connection

#' If no other major or minor versions of an environment template exist,
#' delete the environment template
#'
#' @description
#' If no other major or minor versions of an environment template exist, delete the environment template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_environment_template/](https://www.paws-r-sdk.com/docs/proton_delete_environment_template/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the environment template to delete.
#'
#' @keywords internal
#'
#' @rdname proton_delete_environment_template
proton_delete_environment_template <- function(name) {
  op <- new_operation(
    name = "DeleteEnvironmentTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_environment_template_input(name = name)
  output <- .proton$delete_environment_template_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_environment_template <- proton_delete_environment_template

#' If no other minor versions of an environment template exist, delete a
#' major version of the environment template if it's not the Recommended
#' version
#'
#' @description
#' If no other minor versions of an environment template exist, delete a major version of the environment template if it's not the `Recommended` version. Delete the `Recommended` version of the environment template if no other major versions or minor versions of the environment template exist. A major version of an environment template is a version that's not backward compatible.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_environment_template_version/](https://www.paws-r-sdk.com/docs/proton_delete_environment_template_version/) for full documentation.
#'
#' @param majorVersion &#91;required&#93; The environment template major version to delete.
#' @param minorVersion &#91;required&#93; The environment template minor version to delete.
#' @param templateName &#91;required&#93; The name of the environment template.
#'
#' @keywords internal
#'
#' @rdname proton_delete_environment_template_version
proton_delete_environment_template_version <- function(majorVersion, minorVersion, templateName) {
  op <- new_operation(
    name = "DeleteEnvironmentTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_environment_template_version_input(majorVersion = majorVersion, minorVersion = minorVersion, templateName = templateName)
  output <- .proton$delete_environment_template_version_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_environment_template_version <- proton_delete_environment_template_version

#' De-register and unlink your repository
#'
#' @description
#' De-register and unlink your repository.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_repository/](https://www.paws-r-sdk.com/docs/proton_delete_repository/) for full documentation.
#'
#' @param name &#91;required&#93; The repository name.
#' @param provider &#91;required&#93; The repository provider.
#'
#' @keywords internal
#'
#' @rdname proton_delete_repository
proton_delete_repository <- function(name, provider) {
  op <- new_operation(
    name = "DeleteRepository",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_repository_input(name = name, provider = provider)
  output <- .proton$delete_repository_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_repository <- proton_delete_repository

#' Delete a service, with its instances and pipeline
#'
#' @description
#' Delete a service, with its instances and pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_service/](https://www.paws-r-sdk.com/docs/proton_delete_service/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the service to delete.
#'
#' @keywords internal
#'
#' @rdname proton_delete_service
proton_delete_service <- function(name) {
  op <- new_operation(
    name = "DeleteService",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_service_input(name = name)
  output <- .proton$delete_service_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_service <- proton_delete_service

#' Delete the Proton Ops file
#'
#' @description
#' Delete the Proton Ops file.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_service_sync_config/](https://www.paws-r-sdk.com/docs/proton_delete_service_sync_config/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the service that you want to delete the service sync
#' configuration for.
#'
#' @keywords internal
#'
#' @rdname proton_delete_service_sync_config
proton_delete_service_sync_config <- function(serviceName) {
  op <- new_operation(
    name = "DeleteServiceSyncConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_service_sync_config_input(serviceName = serviceName)
  output <- .proton$delete_service_sync_config_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_service_sync_config <- proton_delete_service_sync_config

#' If no other major or minor versions of the service template exist,
#' delete the service template
#'
#' @description
#' If no other major or minor versions of the service template exist, delete the service template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_service_template/](https://www.paws-r-sdk.com/docs/proton_delete_service_template/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the service template to delete.
#'
#' @keywords internal
#'
#' @rdname proton_delete_service_template
proton_delete_service_template <- function(name) {
  op <- new_operation(
    name = "DeleteServiceTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_service_template_input(name = name)
  output <- .proton$delete_service_template_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_service_template <- proton_delete_service_template

#' If no other minor versions of a service template exist, delete a major
#' version of the service template if it's not the Recommended version
#'
#' @description
#' If no other minor versions of a service template exist, delete a major version of the service template if it's not the `Recommended` version. Delete the `Recommended` version of the service template if no other major versions or minor versions of the service template exist. A major version of a service template is a version that *isn't* backwards compatible.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_service_template_version/](https://www.paws-r-sdk.com/docs/proton_delete_service_template_version/) for full documentation.
#'
#' @param majorVersion &#91;required&#93; The service template major version to delete.
#' @param minorVersion &#91;required&#93; The service template minor version to delete.
#' @param templateName &#91;required&#93; The name of the service template.
#'
#' @keywords internal
#'
#' @rdname proton_delete_service_template_version
proton_delete_service_template_version <- function(majorVersion, minorVersion, templateName) {
  op <- new_operation(
    name = "DeleteServiceTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_service_template_version_input(majorVersion = majorVersion, minorVersion = minorVersion, templateName = templateName)
  output <- .proton$delete_service_template_version_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_service_template_version <- proton_delete_service_template_version

#' Delete a template sync configuration
#'
#' @description
#' Delete a template sync configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_delete_template_sync_config/](https://www.paws-r-sdk.com/docs/proton_delete_template_sync_config/) for full documentation.
#'
#' @param templateName &#91;required&#93; The template name.
#' @param templateType &#91;required&#93; The template type.
#'
#' @keywords internal
#'
#' @rdname proton_delete_template_sync_config
proton_delete_template_sync_config <- function(templateName, templateType) {
  op <- new_operation(
    name = "DeleteTemplateSyncConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$delete_template_sync_config_input(templateName = templateName, templateType = templateType)
  output <- .proton$delete_template_sync_config_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$delete_template_sync_config <- proton_delete_template_sync_config

#' Get detail data for Proton account-wide settings
#'
#' @description
#' Get detail data for Proton account-wide settings.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_account_settings/](https://www.paws-r-sdk.com/docs/proton_get_account_settings/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname proton_get_account_settings
proton_get_account_settings <- function() {
  op <- new_operation(
    name = "GetAccountSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_account_settings_input()
  output <- .proton$get_account_settings_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_account_settings <- proton_get_account_settings

#' Get detailed data for a component
#'
#' @description
#' Get detailed data for a component.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_component/](https://www.paws-r-sdk.com/docs/proton_get_component/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the component that you want to get the detailed data for.
#'
#' @keywords internal
#'
#' @rdname proton_get_component
proton_get_component <- function(name) {
  op <- new_operation(
    name = "GetComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_component_input(name = name)
  output <- .proton$get_component_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_component <- proton_get_component

#' Get detailed data for a deployment
#'
#' @description
#' Get detailed data for a deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_deployment/](https://www.paws-r-sdk.com/docs/proton_get_deployment/) for full documentation.
#'
#' @param componentName The name of a component that you want to get the detailed data for.
#' @param environmentName The name of a environment that you want to get the detailed data for.
#' @param id &#91;required&#93; The ID of the deployment that you want to get the detailed data for.
#' @param serviceInstanceName The name of the service instance associated with the given deployment
#' ID. `serviceName` must be specified to identify the service instance.
#' @param serviceName The name of the service associated with the given deployment ID.
#'
#' @keywords internal
#'
#' @rdname proton_get_deployment
proton_get_deployment <- function(componentName = NULL, environmentName = NULL, id, serviceInstanceName = NULL, serviceName = NULL) {
  op <- new_operation(
    name = "GetDeployment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_deployment_input(componentName = componentName, environmentName = environmentName, id = id, serviceInstanceName = serviceInstanceName, serviceName = serviceName)
  output <- .proton$get_deployment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_deployment <- proton_get_deployment

#' Get detailed data for an environment
#'
#' @description
#' Get detailed data for an environment.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_environment/](https://www.paws-r-sdk.com/docs/proton_get_environment/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the environment that you want to get the detailed data for.
#'
#' @keywords internal
#'
#' @rdname proton_get_environment
proton_get_environment <- function(name) {
  op <- new_operation(
    name = "GetEnvironment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_environment_input(name = name)
  output <- .proton$get_environment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_environment <- proton_get_environment

#' In an environment account, get the detailed data for an environment
#' account connection
#'
#' @description
#' In an environment account, get the detailed data for an environment account connection.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_environment_account_connection/](https://www.paws-r-sdk.com/docs/proton_get_environment_account_connection/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the environment account connection that you want to get the
#' detailed data for.
#'
#' @keywords internal
#'
#' @rdname proton_get_environment_account_connection
proton_get_environment_account_connection <- function(id) {
  op <- new_operation(
    name = "GetEnvironmentAccountConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_environment_account_connection_input(id = id)
  output <- .proton$get_environment_account_connection_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_environment_account_connection <- proton_get_environment_account_connection

#' Get detailed data for an environment template
#'
#' @description
#' Get detailed data for an environment template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_environment_template/](https://www.paws-r-sdk.com/docs/proton_get_environment_template/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the environment template that you want to get the detailed
#' data for.
#'
#' @keywords internal
#'
#' @rdname proton_get_environment_template
proton_get_environment_template <- function(name) {
  op <- new_operation(
    name = "GetEnvironmentTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_environment_template_input(name = name)
  output <- .proton$get_environment_template_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_environment_template <- proton_get_environment_template

#' Get detailed data for a major or minor version of an environment
#' template
#'
#' @description
#' Get detailed data for a major or minor version of an environment template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_environment_template_version/](https://www.paws-r-sdk.com/docs/proton_get_environment_template_version/) for full documentation.
#'
#' @param majorVersion &#91;required&#93; To get environment template major version detail data, include
#' `major Version`.
#' @param minorVersion &#91;required&#93; To get environment template minor version detail data, include
#' `minorVersion`.
#' @param templateName &#91;required&#93; The name of the environment template a version of which you want to get
#' detailed data for.
#'
#' @keywords internal
#'
#' @rdname proton_get_environment_template_version
proton_get_environment_template_version <- function(majorVersion, minorVersion, templateName) {
  op <- new_operation(
    name = "GetEnvironmentTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_environment_template_version_input(majorVersion = majorVersion, minorVersion = minorVersion, templateName = templateName)
  output <- .proton$get_environment_template_version_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_environment_template_version <- proton_get_environment_template_version

#' Get detail data for a linked repository
#'
#' @description
#' Get detail data for a linked repository.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_repository/](https://www.paws-r-sdk.com/docs/proton_get_repository/) for full documentation.
#'
#' @param name &#91;required&#93; The repository name, for example `myrepos/myrepo`.
#' @param provider &#91;required&#93; The repository provider.
#'
#' @keywords internal
#'
#' @rdname proton_get_repository
proton_get_repository <- function(name, provider) {
  op <- new_operation(
    name = "GetRepository",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_repository_input(name = name, provider = provider)
  output <- .proton$get_repository_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_repository <- proton_get_repository

#' Get the sync status of a repository used for Proton template sync
#'
#' @description
#' Get the sync status of a repository used for Proton template sync. For more information about template sync, see .
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_repository_sync_status/](https://www.paws-r-sdk.com/docs/proton_get_repository_sync_status/) for full documentation.
#'
#' @param branch &#91;required&#93; The repository branch.
#' @param repositoryName &#91;required&#93; The repository name.
#' @param repositoryProvider &#91;required&#93; The repository provider.
#' @param syncType &#91;required&#93; The repository sync type.
#'
#' @keywords internal
#'
#' @rdname proton_get_repository_sync_status
proton_get_repository_sync_status <- function(branch, repositoryName, repositoryProvider, syncType) {
  op <- new_operation(
    name = "GetRepositorySyncStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_repository_sync_status_input(branch = branch, repositoryName = repositoryName, repositoryProvider = repositoryProvider, syncType = syncType)
  output <- .proton$get_repository_sync_status_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_repository_sync_status <- proton_get_repository_sync_status

#' Get counts of Proton resources
#'
#' @description
#' Get counts of Proton resources.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_resources_summary/](https://www.paws-r-sdk.com/docs/proton_get_resources_summary/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname proton_get_resources_summary
proton_get_resources_summary <- function() {
  op <- new_operation(
    name = "GetResourcesSummary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_resources_summary_input()
  output <- .proton$get_resources_summary_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_resources_summary <- proton_get_resources_summary

#' Get detailed data for a service
#'
#' @description
#' Get detailed data for a service.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_service/](https://www.paws-r-sdk.com/docs/proton_get_service/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the service that you want to get the detailed data for.
#'
#' @keywords internal
#'
#' @rdname proton_get_service
proton_get_service <- function(name) {
  op <- new_operation(
    name = "GetService",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_service_input(name = name)
  output <- .proton$get_service_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_service <- proton_get_service

#' Get detailed data for a service instance
#'
#' @description
#' Get detailed data for a service instance. A service instance is an instantiation of service template and it runs in a specific environment.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_service_instance/](https://www.paws-r-sdk.com/docs/proton_get_service_instance/) for full documentation.
#'
#' @param name &#91;required&#93; The name of a service instance that you want to get the detailed data
#' for.
#' @param serviceName &#91;required&#93; The name of the service that you want the service instance input for.
#'
#' @keywords internal
#'
#' @rdname proton_get_service_instance
proton_get_service_instance <- function(name, serviceName) {
  op <- new_operation(
    name = "GetServiceInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_service_instance_input(name = name, serviceName = serviceName)
  output <- .proton$get_service_instance_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_service_instance <- proton_get_service_instance

#' Get the status of the synced service instance
#'
#' @description
#' Get the status of the synced service instance.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_service_instance_sync_status/](https://www.paws-r-sdk.com/docs/proton_get_service_instance_sync_status/) for full documentation.
#'
#' @param serviceInstanceName &#91;required&#93; The name of the service instance that you want the sync status input
#' for.
#' @param serviceName &#91;required&#93; The name of the service that the service instance belongs to.
#'
#' @keywords internal
#'
#' @rdname proton_get_service_instance_sync_status
proton_get_service_instance_sync_status <- function(serviceInstanceName, serviceName) {
  op <- new_operation(
    name = "GetServiceInstanceSyncStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_service_instance_sync_status_input(serviceInstanceName = serviceInstanceName, serviceName = serviceName)
  output <- .proton$get_service_instance_sync_status_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_service_instance_sync_status <- proton_get_service_instance_sync_status

#' Get detailed data for the service sync blocker summary
#'
#' @description
#' Get detailed data for the service sync blocker summary.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_service_sync_blocker_summary/](https://www.paws-r-sdk.com/docs/proton_get_service_sync_blocker_summary/) for full documentation.
#'
#' @param serviceInstanceName The name of the service instance that you want to get the service sync
#' blocker summary for. If given bothe the instance name and the service
#' name, only the instance is blocked.
#' @param serviceName &#91;required&#93; The name of the service that you want to get the service sync blocker
#' summary for. If given only the service name, all instances are blocked.
#'
#' @keywords internal
#'
#' @rdname proton_get_service_sync_blocker_summary
proton_get_service_sync_blocker_summary <- function(serviceInstanceName = NULL, serviceName) {
  op <- new_operation(
    name = "GetServiceSyncBlockerSummary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_service_sync_blocker_summary_input(serviceInstanceName = serviceInstanceName, serviceName = serviceName)
  output <- .proton$get_service_sync_blocker_summary_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_service_sync_blocker_summary <- proton_get_service_sync_blocker_summary

#' Get detailed information for the service sync configuration
#'
#' @description
#' Get detailed information for the service sync configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_service_sync_config/](https://www.paws-r-sdk.com/docs/proton_get_service_sync_config/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the service that you want to get the service sync
#' configuration for.
#'
#' @keywords internal
#'
#' @rdname proton_get_service_sync_config
proton_get_service_sync_config <- function(serviceName) {
  op <- new_operation(
    name = "GetServiceSyncConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_service_sync_config_input(serviceName = serviceName)
  output <- .proton$get_service_sync_config_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_service_sync_config <- proton_get_service_sync_config

#' Get detailed data for a service template
#'
#' @description
#' Get detailed data for a service template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_service_template/](https://www.paws-r-sdk.com/docs/proton_get_service_template/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the service template that you want to get detailed data for.
#'
#' @keywords internal
#'
#' @rdname proton_get_service_template
proton_get_service_template <- function(name) {
  op <- new_operation(
    name = "GetServiceTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_service_template_input(name = name)
  output <- .proton$get_service_template_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_service_template <- proton_get_service_template

#' Get detailed data for a major or minor version of a service template
#'
#' @description
#' Get detailed data for a major or minor version of a service template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_service_template_version/](https://www.paws-r-sdk.com/docs/proton_get_service_template_version/) for full documentation.
#'
#' @param majorVersion &#91;required&#93; To get service template major version detail data, include
#' `major Version`.
#' @param minorVersion &#91;required&#93; To get service template minor version detail data, include
#' `minorVersion`.
#' @param templateName &#91;required&#93; The name of the service template a version of which you want to get
#' detailed data for.
#'
#' @keywords internal
#'
#' @rdname proton_get_service_template_version
proton_get_service_template_version <- function(majorVersion, minorVersion, templateName) {
  op <- new_operation(
    name = "GetServiceTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_service_template_version_input(majorVersion = majorVersion, minorVersion = minorVersion, templateName = templateName)
  output <- .proton$get_service_template_version_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_service_template_version <- proton_get_service_template_version

#' Get detail data for a template sync configuration
#'
#' @description
#' Get detail data for a template sync configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_template_sync_config/](https://www.paws-r-sdk.com/docs/proton_get_template_sync_config/) for full documentation.
#'
#' @param templateName &#91;required&#93; The template name.
#' @param templateType &#91;required&#93; The template type.
#'
#' @keywords internal
#'
#' @rdname proton_get_template_sync_config
proton_get_template_sync_config <- function(templateName, templateType) {
  op <- new_operation(
    name = "GetTemplateSyncConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_template_sync_config_input(templateName = templateName, templateType = templateType)
  output <- .proton$get_template_sync_config_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_template_sync_config <- proton_get_template_sync_config

#' Get the status of a template sync
#'
#' @description
#' Get the status of a template sync.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_get_template_sync_status/](https://www.paws-r-sdk.com/docs/proton_get_template_sync_status/) for full documentation.
#'
#' @param templateName &#91;required&#93; The template name.
#' @param templateType &#91;required&#93; The template type.
#' @param templateVersion &#91;required&#93; The template major version.
#'
#' @keywords internal
#'
#' @rdname proton_get_template_sync_status
proton_get_template_sync_status <- function(templateName, templateType, templateVersion) {
  op <- new_operation(
    name = "GetTemplateSyncStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$get_template_sync_status_input(templateName = templateName, templateType = templateType, templateVersion = templateVersion)
  output <- .proton$get_template_sync_status_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$get_template_sync_status <- proton_get_template_sync_status

#' Get a list of component Infrastructure as Code (IaC) outputs
#'
#' @description
#' Get a list of component Infrastructure as Code (IaC) outputs.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_component_outputs/](https://www.paws-r-sdk.com/docs/proton_list_component_outputs/) for full documentation.
#'
#' @param componentName &#91;required&#93; The name of the component whose outputs you want.
#' @param deploymentId The ID of the deployment whose outputs you want.
#' @param nextToken A token that indicates the location of the next output in the array of
#' outputs, after the list of outputs that was previously requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_component_outputs
proton_list_component_outputs <- function(componentName, deploymentId = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListComponentOutputs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "outputs")
  )
  input <- .proton$list_component_outputs_input(componentName = componentName, deploymentId = deploymentId, nextToken = nextToken)
  output <- .proton$list_component_outputs_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_component_outputs <- proton_list_component_outputs

#' List provisioned resources for a component with details
#'
#' @description
#' List provisioned resources for a component with details.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_component_provisioned_resources/](https://www.paws-r-sdk.com/docs/proton_list_component_provisioned_resources/) for full documentation.
#'
#' @param componentName &#91;required&#93; The name of the component whose provisioned resources you want.
#' @param nextToken A token that indicates the location of the next provisioned resource in
#' the array of provisioned resources, after the list of provisioned
#' resources that was previously requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_component_provisioned_resources
proton_list_component_provisioned_resources <- function(componentName, nextToken = NULL) {
  op <- new_operation(
    name = "ListComponentProvisionedResources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "provisionedResources")
  )
  input <- .proton$list_component_provisioned_resources_input(componentName = componentName, nextToken = nextToken)
  output <- .proton$list_component_provisioned_resources_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_component_provisioned_resources <- proton_list_component_provisioned_resources

#' List components with summary data
#'
#' @description
#' List components with summary data. You can filter the result list by environment, service, or a single service instance.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_components/](https://www.paws-r-sdk.com/docs/proton_list_components/) for full documentation.
#'
#' @param environmentName The name of an environment for result list filtering. Proton returns
#' components associated with the environment or attached to service
#' instances running in it.
#' @param maxResults The maximum number of components to list.
#' @param nextToken A token that indicates the location of the next component in the array
#' of components, after the list of components that was previously
#' requested.
#' @param serviceInstanceName The name of a service instance for result list filtering. Proton returns
#' the component attached to the service instance, if any.
#' @param serviceName The name of a service for result list filtering. Proton returns
#' components attached to service instances of the service.
#'
#' @keywords internal
#'
#' @rdname proton_list_components
proton_list_components <- function(environmentName = NULL, maxResults = NULL, nextToken = NULL, serviceInstanceName = NULL, serviceName = NULL) {
  op <- new_operation(
    name = "ListComponents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "components")
  )
  input <- .proton$list_components_input(environmentName = environmentName, maxResults = maxResults, nextToken = nextToken, serviceInstanceName = serviceInstanceName, serviceName = serviceName)
  output <- .proton$list_components_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_components <- proton_list_components

#' List deployments
#'
#' @description
#' List deployments. You can filter the result list by environment, service, or a single service instance.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_deployments/](https://www.paws-r-sdk.com/docs/proton_list_deployments/) for full documentation.
#'
#' @param componentName The name of a component for result list filtering. Proton returns
#' deployments associated with that component.
#' @param environmentName The name of an environment for result list filtering. Proton returns
#' deployments associated with the environment.
#' @param maxResults The maximum number of deployments to list.
#' @param nextToken A token that indicates the location of the next deployment in the array
#' of deployment, after the list of deployment that was previously
#' requested.
#' @param serviceInstanceName The name of a service instance for result list filtering. Proton returns
#' the deployments associated with the service instance.
#' @param serviceName The name of a service for result list filtering. Proton returns
#' deployments associated with service instances of the service.
#'
#' @keywords internal
#'
#' @rdname proton_list_deployments
proton_list_deployments <- function(componentName = NULL, environmentName = NULL, maxResults = NULL, nextToken = NULL, serviceInstanceName = NULL, serviceName = NULL) {
  op <- new_operation(
    name = "ListDeployments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "deployments")
  )
  input <- .proton$list_deployments_input(componentName = componentName, environmentName = environmentName, maxResults = maxResults, nextToken = nextToken, serviceInstanceName = serviceInstanceName, serviceName = serviceName)
  output <- .proton$list_deployments_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_deployments <- proton_list_deployments

#' View a list of environment account connections
#'
#' @description
#' View a list of environment account connections.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_environment_account_connections/](https://www.paws-r-sdk.com/docs/proton_list_environment_account_connections/) for full documentation.
#'
#' @param environmentName The environment name that's associated with each listed environment
#' account connection.
#' @param maxResults The maximum number of environment account connections to list.
#' @param nextToken A token that indicates the location of the next environment account
#' connection in the array of environment account connections, after the
#' list of environment account connections that was previously requested.
#' @param requestedBy &#91;required&#93; The type of account making the
#' [`list_environment_account_connections`][proton_list_environment_account_connections]
#' request.
#' @param statuses The status details for each listed environment account connection.
#'
#' @keywords internal
#'
#' @rdname proton_list_environment_account_connections
proton_list_environment_account_connections <- function(environmentName = NULL, maxResults = NULL, nextToken = NULL, requestedBy, statuses = NULL) {
  op <- new_operation(
    name = "ListEnvironmentAccountConnections",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "environmentAccountConnections")
  )
  input <- .proton$list_environment_account_connections_input(environmentName = environmentName, maxResults = maxResults, nextToken = nextToken, requestedBy = requestedBy, statuses = statuses)
  output <- .proton$list_environment_account_connections_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_environment_account_connections <- proton_list_environment_account_connections

#' List the infrastructure as code outputs for your environment
#'
#' @description
#' List the infrastructure as code outputs for your environment.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_environment_outputs/](https://www.paws-r-sdk.com/docs/proton_list_environment_outputs/) for full documentation.
#'
#' @param deploymentId The ID of the deployment whose outputs you want.
#' @param environmentName &#91;required&#93; The environment name.
#' @param nextToken A token that indicates the location of the next environment output in
#' the array of environment outputs, after the list of environment outputs
#' that was previously requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_environment_outputs
proton_list_environment_outputs <- function(deploymentId = NULL, environmentName, nextToken = NULL) {
  op <- new_operation(
    name = "ListEnvironmentOutputs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "outputs")
  )
  input <- .proton$list_environment_outputs_input(deploymentId = deploymentId, environmentName = environmentName, nextToken = nextToken)
  output <- .proton$list_environment_outputs_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_environment_outputs <- proton_list_environment_outputs

#' List the provisioned resources for your environment
#'
#' @description
#' List the provisioned resources for your environment.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_environment_provisioned_resources/](https://www.paws-r-sdk.com/docs/proton_list_environment_provisioned_resources/) for full documentation.
#'
#' @param environmentName &#91;required&#93; The environment name.
#' @param nextToken A token that indicates the location of the next environment provisioned
#' resource in the array of environment provisioned resources, after the
#' list of environment provisioned resources that was previously requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_environment_provisioned_resources
proton_list_environment_provisioned_resources <- function(environmentName, nextToken = NULL) {
  op <- new_operation(
    name = "ListEnvironmentProvisionedResources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "provisionedResources")
  )
  input <- .proton$list_environment_provisioned_resources_input(environmentName = environmentName, nextToken = nextToken)
  output <- .proton$list_environment_provisioned_resources_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_environment_provisioned_resources <- proton_list_environment_provisioned_resources

#' List major or minor versions of an environment template with detail data
#'
#' @description
#' List major or minor versions of an environment template with detail data.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_environment_template_versions/](https://www.paws-r-sdk.com/docs/proton_list_environment_template_versions/) for full documentation.
#'
#' @param majorVersion To view a list of minor of versions under a major version of an
#' environment template, include `major Version`.
#' 
#' To view a list of major versions of an environment template, *exclude*
#' `major Version`.
#' @param maxResults The maximum number of major or minor versions of an environment template
#' to list.
#' @param nextToken A token that indicates the location of the next major or minor version
#' in the array of major or minor versions of an environment template,
#' after the list of major or minor versions that was previously requested.
#' @param templateName &#91;required&#93; The name of the environment template.
#'
#' @keywords internal
#'
#' @rdname proton_list_environment_template_versions
proton_list_environment_template_versions <- function(majorVersion = NULL, maxResults = NULL, nextToken = NULL, templateName) {
  op <- new_operation(
    name = "ListEnvironmentTemplateVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "templateVersions")
  )
  input <- .proton$list_environment_template_versions_input(majorVersion = majorVersion, maxResults = maxResults, nextToken = nextToken, templateName = templateName)
  output <- .proton$list_environment_template_versions_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_environment_template_versions <- proton_list_environment_template_versions

#' List environment templates
#'
#' @description
#' List environment templates.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_environment_templates/](https://www.paws-r-sdk.com/docs/proton_list_environment_templates/) for full documentation.
#'
#' @param maxResults The maximum number of environment templates to list.
#' @param nextToken A token that indicates the location of the next environment template in
#' the array of environment templates, after the list of environment
#' templates that was previously requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_environment_templates
proton_list_environment_templates <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListEnvironmentTemplates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "templates")
  )
  input <- .proton$list_environment_templates_input(maxResults = maxResults, nextToken = nextToken)
  output <- .proton$list_environment_templates_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_environment_templates <- proton_list_environment_templates

#' List environments with detail data summaries
#'
#' @description
#' List environments with detail data summaries.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_environments/](https://www.paws-r-sdk.com/docs/proton_list_environments/) for full documentation.
#'
#' @param environmentTemplates An array of the versions of the environment template.
#' @param maxResults The maximum number of environments to list.
#' @param nextToken A token that indicates the location of the next environment in the array
#' of environments, after the list of environments that was previously
#' requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_environments
proton_list_environments <- function(environmentTemplates = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListEnvironments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "environments")
  )
  input <- .proton$list_environments_input(environmentTemplates = environmentTemplates, maxResults = maxResults, nextToken = nextToken)
  output <- .proton$list_environments_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_environments <- proton_list_environments

#' List linked repositories with detail data
#'
#' @description
#' List linked repositories with detail data.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_repositories/](https://www.paws-r-sdk.com/docs/proton_list_repositories/) for full documentation.
#'
#' @param maxResults The maximum number of repositories to list.
#' @param nextToken A token that indicates the location of the next repository in the array
#' of repositories, after the list of repositories previously requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_repositories
proton_list_repositories <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListRepositories",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "repositories")
  )
  input <- .proton$list_repositories_input(maxResults = maxResults, nextToken = nextToken)
  output <- .proton$list_repositories_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_repositories <- proton_list_repositories

#' List repository sync definitions with detail data
#'
#' @description
#' List repository sync definitions with detail data.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_repository_sync_definitions/](https://www.paws-r-sdk.com/docs/proton_list_repository_sync_definitions/) for full documentation.
#'
#' @param nextToken A token that indicates the location of the next repository sync
#' definition in the array of repository sync definitions, after the list
#' of repository sync definitions previously requested.
#' @param repositoryName &#91;required&#93; The repository name.
#' @param repositoryProvider &#91;required&#93; The repository provider.
#' @param syncType &#91;required&#93; The sync type. The only supported value is `TEMPLATE_SYNC`.
#'
#' @keywords internal
#'
#' @rdname proton_list_repository_sync_definitions
proton_list_repository_sync_definitions <- function(nextToken = NULL, repositoryName, repositoryProvider, syncType) {
  op <- new_operation(
    name = "ListRepositorySyncDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "syncDefinitions")
  )
  input <- .proton$list_repository_sync_definitions_input(nextToken = nextToken, repositoryName = repositoryName, repositoryProvider = repositoryProvider, syncType = syncType)
  output <- .proton$list_repository_sync_definitions_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_repository_sync_definitions <- proton_list_repository_sync_definitions

#' Get a list service of instance Infrastructure as Code (IaC) outputs
#'
#' @description
#' Get a list service of instance Infrastructure as Code (IaC) outputs.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_service_instance_outputs/](https://www.paws-r-sdk.com/docs/proton_list_service_instance_outputs/) for full documentation.
#'
#' @param deploymentId The ID of the deployment whose outputs you want.
#' @param nextToken A token that indicates the location of the next output in the array of
#' outputs, after the list of outputs that was previously requested.
#' @param serviceInstanceName &#91;required&#93; The name of the service instance whose outputs you want.
#' @param serviceName &#91;required&#93; The name of the service that `serviceInstanceName` is associated to.
#'
#' @keywords internal
#'
#' @rdname proton_list_service_instance_outputs
proton_list_service_instance_outputs <- function(deploymentId = NULL, nextToken = NULL, serviceInstanceName, serviceName) {
  op <- new_operation(
    name = "ListServiceInstanceOutputs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "outputs")
  )
  input <- .proton$list_service_instance_outputs_input(deploymentId = deploymentId, nextToken = nextToken, serviceInstanceName = serviceInstanceName, serviceName = serviceName)
  output <- .proton$list_service_instance_outputs_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_service_instance_outputs <- proton_list_service_instance_outputs

#' List provisioned resources for a service instance with details
#'
#' @description
#' List provisioned resources for a service instance with details.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_service_instance_provisioned_resources/](https://www.paws-r-sdk.com/docs/proton_list_service_instance_provisioned_resources/) for full documentation.
#'
#' @param nextToken A token that indicates the location of the next provisioned resource in
#' the array of provisioned resources, after the list of provisioned
#' resources that was previously requested.
#' @param serviceInstanceName &#91;required&#93; The name of the service instance whose provisioned resources you want.
#' @param serviceName &#91;required&#93; The name of the service that `serviceInstanceName` is associated to.
#'
#' @keywords internal
#'
#' @rdname proton_list_service_instance_provisioned_resources
proton_list_service_instance_provisioned_resources <- function(nextToken = NULL, serviceInstanceName, serviceName) {
  op <- new_operation(
    name = "ListServiceInstanceProvisionedResources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "provisionedResources")
  )
  input <- .proton$list_service_instance_provisioned_resources_input(nextToken = nextToken, serviceInstanceName = serviceInstanceName, serviceName = serviceName)
  output <- .proton$list_service_instance_provisioned_resources_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_service_instance_provisioned_resources <- proton_list_service_instance_provisioned_resources

#' List service instances with summary data
#'
#' @description
#' List service instances with summary data. This action lists service instances of all services in the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_service_instances/](https://www.paws-r-sdk.com/docs/proton_list_service_instances/) for full documentation.
#'
#' @param filters An array of filtering criteria that scope down the result list. By
#' default, all service instances in the Amazon Web Services account are
#' returned.
#' @param maxResults The maximum number of service instances to list.
#' @param nextToken A token that indicates the location of the next service in the array of
#' service instances, after the list of service instances that was
#' previously requested.
#' @param serviceName The name of the service that the service instance belongs to.
#' @param sortBy The field that the result list is sorted by.
#' 
#' When you choose to sort by `serviceName`, service instances within each
#' service are sorted by service instance name.
#' 
#' Default: `serviceName`
#' @param sortOrder Result list sort order.
#' 
#' Default: `ASCENDING`
#'
#' @keywords internal
#'
#' @rdname proton_list_service_instances
proton_list_service_instances <- function(filters = NULL, maxResults = NULL, nextToken = NULL, serviceName = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListServiceInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "serviceInstances")
  )
  input <- .proton$list_service_instances_input(filters = filters, maxResults = maxResults, nextToken = nextToken, serviceName = serviceName, sortBy = sortBy, sortOrder = sortOrder)
  output <- .proton$list_service_instances_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_service_instances <- proton_list_service_instances

#' Get a list of service pipeline Infrastructure as Code (IaC) outputs
#'
#' @description
#' Get a list of service pipeline Infrastructure as Code (IaC) outputs.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_service_pipeline_outputs/](https://www.paws-r-sdk.com/docs/proton_list_service_pipeline_outputs/) for full documentation.
#'
#' @param deploymentId The ID of the deployment you want the outputs for.
#' @param nextToken A token that indicates the location of the next output in the array of
#' outputs, after the list of outputs that was previously requested.
#' @param serviceName &#91;required&#93; The name of the service whose pipeline's outputs you want.
#'
#' @keywords internal
#'
#' @rdname proton_list_service_pipeline_outputs
proton_list_service_pipeline_outputs <- function(deploymentId = NULL, nextToken = NULL, serviceName) {
  op <- new_operation(
    name = "ListServicePipelineOutputs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "outputs")
  )
  input <- .proton$list_service_pipeline_outputs_input(deploymentId = deploymentId, nextToken = nextToken, serviceName = serviceName)
  output <- .proton$list_service_pipeline_outputs_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_service_pipeline_outputs <- proton_list_service_pipeline_outputs

#' List provisioned resources for a service and pipeline with details
#'
#' @description
#' List provisioned resources for a service and pipeline with details.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_service_pipeline_provisioned_resources/](https://www.paws-r-sdk.com/docs/proton_list_service_pipeline_provisioned_resources/) for full documentation.
#'
#' @param nextToken A token that indicates the location of the next provisioned resource in
#' the array of provisioned resources, after the list of provisioned
#' resources that was previously requested.
#' @param serviceName &#91;required&#93; The name of the service whose pipeline's provisioned resources you want.
#'
#' @keywords internal
#'
#' @rdname proton_list_service_pipeline_provisioned_resources
proton_list_service_pipeline_provisioned_resources <- function(nextToken = NULL, serviceName) {
  op <- new_operation(
    name = "ListServicePipelineProvisionedResources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "provisionedResources")
  )
  input <- .proton$list_service_pipeline_provisioned_resources_input(nextToken = nextToken, serviceName = serviceName)
  output <- .proton$list_service_pipeline_provisioned_resources_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_service_pipeline_provisioned_resources <- proton_list_service_pipeline_provisioned_resources

#' List major or minor versions of a service template with detail data
#'
#' @description
#' List major or minor versions of a service template with detail data.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_service_template_versions/](https://www.paws-r-sdk.com/docs/proton_list_service_template_versions/) for full documentation.
#'
#' @param majorVersion To view a list of minor of versions under a major version of a service
#' template, include `major Version`.
#' 
#' To view a list of major versions of a service template, *exclude*
#' `major Version`.
#' @param maxResults The maximum number of major or minor versions of a service template to
#' list.
#' @param nextToken A token that indicates the location of the next major or minor version
#' in the array of major or minor versions of a service template, after the
#' list of major or minor versions that was previously requested.
#' @param templateName &#91;required&#93; The name of the service template.
#'
#' @keywords internal
#'
#' @rdname proton_list_service_template_versions
proton_list_service_template_versions <- function(majorVersion = NULL, maxResults = NULL, nextToken = NULL, templateName) {
  op <- new_operation(
    name = "ListServiceTemplateVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "templateVersions")
  )
  input <- .proton$list_service_template_versions_input(majorVersion = majorVersion, maxResults = maxResults, nextToken = nextToken, templateName = templateName)
  output <- .proton$list_service_template_versions_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_service_template_versions <- proton_list_service_template_versions

#' List service templates with detail data
#'
#' @description
#' List service templates with detail data.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_service_templates/](https://www.paws-r-sdk.com/docs/proton_list_service_templates/) for full documentation.
#'
#' @param maxResults The maximum number of service templates to list.
#' @param nextToken A token that indicates the location of the next service template in the
#' array of service templates, after the list of service templates
#' previously requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_service_templates
proton_list_service_templates <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListServiceTemplates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "templates")
  )
  input <- .proton$list_service_templates_input(maxResults = maxResults, nextToken = nextToken)
  output <- .proton$list_service_templates_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_service_templates <- proton_list_service_templates

#' List services with summaries of detail data
#'
#' @description
#' List services with summaries of detail data.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_services/](https://www.paws-r-sdk.com/docs/proton_list_services/) for full documentation.
#'
#' @param maxResults The maximum number of services to list.
#' @param nextToken A token that indicates the location of the next service in the array of
#' services, after the list of services that was previously requested.
#'
#' @keywords internal
#'
#' @rdname proton_list_services
proton_list_services <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "services")
  )
  input <- .proton$list_services_input(maxResults = maxResults, nextToken = nextToken)
  output <- .proton$list_services_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_services <- proton_list_services

#' List tags for a resource
#'
#' @description
#' List tags for a resource. For more information, see [Proton resources and tagging](https://docs.aws.amazon.com/proton/latest/userguide/resources.html) in the *Proton User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/proton_list_tags_for_resource/) for full documentation.
#'
#' @param maxResults The maximum number of tags to list.
#' @param nextToken A token that indicates the location of the next resource tag in the
#' array of resource tags, after the list of resource tags that was
#' previously requested.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for the listed tags.
#'
#' @keywords internal
#'
#' @rdname proton_list_tags_for_resource
proton_list_tags_for_resource <- function(maxResults = NULL, nextToken = NULL, resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "tags")
  )
  input <- .proton$list_tags_for_resource_input(maxResults = maxResults, nextToken = nextToken, resourceArn = resourceArn)
  output <- .proton$list_tags_for_resource_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$list_tags_for_resource <- proton_list_tags_for_resource

#' Notify Proton of status changes to a provisioned resource when you use
#' self-managed provisioning
#'
#' @description
#' Notify Proton of status changes to a provisioned resource when you use self-managed provisioning.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_notify_resource_deployment_status_change/](https://www.paws-r-sdk.com/docs/proton_notify_resource_deployment_status_change/) for full documentation.
#'
#' @param deploymentId The deployment ID for your provisioned resource.
#' @param outputs The provisioned resource state change detail data that's returned by
#' Proton.
#' @param resourceArn &#91;required&#93; The provisioned resource Amazon Resource Name (ARN).
#' @param status The status of your provisioned resource.
#' @param statusMessage The deployment status message for your provisioned resource.
#'
#' @keywords internal
#'
#' @rdname proton_notify_resource_deployment_status_change
proton_notify_resource_deployment_status_change <- function(deploymentId = NULL, outputs = NULL, resourceArn, status = NULL, statusMessage = NULL) {
  op <- new_operation(
    name = "NotifyResourceDeploymentStatusChange",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$notify_resource_deployment_status_change_input(deploymentId = deploymentId, outputs = outputs, resourceArn = resourceArn, status = status, statusMessage = statusMessage)
  output <- .proton$notify_resource_deployment_status_change_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$notify_resource_deployment_status_change <- proton_notify_resource_deployment_status_change

#' In a management account, reject an environment account connection from
#' another environment account
#'
#' @description
#' In a management account, reject an environment account connection from another environment account.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_reject_environment_account_connection/](https://www.paws-r-sdk.com/docs/proton_reject_environment_account_connection/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the environment account connection to reject.
#'
#' @keywords internal
#'
#' @rdname proton_reject_environment_account_connection
proton_reject_environment_account_connection <- function(id) {
  op <- new_operation(
    name = "RejectEnvironmentAccountConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$reject_environment_account_connection_input(id = id)
  output <- .proton$reject_environment_account_connection_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$reject_environment_account_connection <- proton_reject_environment_account_connection

#' Tag a resource
#'
#' @description
#' Tag a resource. A tag is a key-value pair of metadata that you associate with an Proton resource.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_tag_resource/](https://www.paws-r-sdk.com/docs/proton_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Proton resource to apply customer
#' tags to.
#' @param tags &#91;required&#93; A list of customer tags to apply to the Proton resource.
#'
#' @keywords internal
#'
#' @rdname proton_tag_resource
proton_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .proton$tag_resource_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$tag_resource <- proton_tag_resource

#' Remove a customer tag from a resource
#'
#' @description
#' Remove a customer tag from a resource. A tag is a key-value pair of metadata associated with an Proton resource.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_untag_resource/](https://www.paws-r-sdk.com/docs/proton_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove customer tags
#' from.
#' @param tagKeys &#91;required&#93; A list of customer tag keys that indicate the customer tags to be
#' removed from the resource.
#'
#' @keywords internal
#'
#' @rdname proton_untag_resource
proton_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .proton$untag_resource_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$untag_resource <- proton_untag_resource

#' Update Proton settings that are used for multiple services in the Amazon
#' Web Services account
#'
#' @description
#' Update Proton settings that are used for multiple services in the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_account_settings/](https://www.paws-r-sdk.com/docs/proton_update_account_settings/) for full documentation.
#'
#' @param deletePipelineProvisioningRepository Set to `true` to remove a configured pipeline repository from the
#' account settings. Don't set this field if you are updating the
#' configured pipeline repository.
#' @param pipelineCodebuildRoleArn The Amazon Resource Name (ARN) of the service role you want to use for
#' provisioning pipelines. Proton assumes this role for CodeBuild-based
#' provisioning.
#' @param pipelineProvisioningRepository A linked repository for pipeline provisioning. Specify it if you have
#' environments configured for self-managed provisioning with services that
#' include pipelines. A linked repository is a repository that has been
#' registered with Proton. For more information, see
#' [`create_repository`][proton_create_repository].
#' 
#' To remove a previously configured repository, set
#' `deletePipelineProvisioningRepository` to `true`, and don't set
#' `pipelineProvisioningRepository`.
#' @param pipelineServiceRoleArn The Amazon Resource Name (ARN) of the service role you want to use for
#' provisioning pipelines. Assumed by Proton for Amazon Web
#' Services-managed provisioning, and by customer-owned automation for
#' self-managed provisioning.
#' 
#' To remove a previously configured ARN, specify an empty string.
#'
#' @keywords internal
#'
#' @rdname proton_update_account_settings
proton_update_account_settings <- function(deletePipelineProvisioningRepository = NULL, pipelineCodebuildRoleArn = NULL, pipelineProvisioningRepository = NULL, pipelineServiceRoleArn = NULL) {
  op <- new_operation(
    name = "UpdateAccountSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_account_settings_input(deletePipelineProvisioningRepository = deletePipelineProvisioningRepository, pipelineCodebuildRoleArn = pipelineCodebuildRoleArn, pipelineProvisioningRepository = pipelineProvisioningRepository, pipelineServiceRoleArn = pipelineServiceRoleArn)
  output <- .proton$update_account_settings_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_account_settings <- proton_update_account_settings

#' Update a component
#'
#' @description
#' Update a component.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_component/](https://www.paws-r-sdk.com/docs/proton_update_component/) for full documentation.
#'
#' @param clientToken The client token for the updated component.
#' @param deploymentType &#91;required&#93; The deployment type. It defines the mode for updating a component, as
#' follows:
#' 
#' ****
#' 
#' `NONE`
#' 
#' In this mode, a deployment *doesn't* occur. Only the requested metadata
#' parameters are updated. You can only specify `description` in this mode.
#' 
#' ****
#' 
#' `CURRENT_VERSION`
#' 
#' In this mode, the component is deployed and updated with the new
#' `serviceSpec`, `templateSource`, and/or `type` that you provide. Only
#' requested parameters are updated.
#' @param description An optional customer-provided description of the component.
#' @param name &#91;required&#93; The name of the component to update.
#' @param serviceInstanceName The name of the service instance that you want to attach this component
#' to. Don't specify to keep the component's current service instance
#' attachment. Specify an empty string to detach the component from the
#' service instance it's attached to. Specify non-empty values for both
#' `serviceInstanceName` and `serviceName` or for neither of them.
#' @param serviceName The name of the service that `serviceInstanceName` is associated with.
#' Don't specify to keep the component's current service instance
#' attachment. Specify an empty string to detach the component from the
#' service instance it's attached to. Specify non-empty values for both
#' `serviceInstanceName` and `serviceName` or for neither of them.
#' @param serviceSpec The service spec that you want the component to use to access service
#' inputs. Set this only when the component is attached to a service
#' instance.
#' @param templateFile A path to the Infrastructure as Code (IaC) file describing
#' infrastructure that a custom component provisions.
#' 
#' Components support a single IaC file, even if you use Terraform as your
#' template language.
#'
#' @keywords internal
#'
#' @rdname proton_update_component
proton_update_component <- function(clientToken = NULL, deploymentType, description = NULL, name, serviceInstanceName = NULL, serviceName = NULL, serviceSpec = NULL, templateFile = NULL) {
  op <- new_operation(
    name = "UpdateComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_component_input(clientToken = clientToken, deploymentType = deploymentType, description = description, name = name, serviceInstanceName = serviceInstanceName, serviceName = serviceName, serviceSpec = serviceSpec, templateFile = templateFile)
  output <- .proton$update_component_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_component <- proton_update_component

#' Update an environment
#'
#' @description
#' Update an environment.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_environment/](https://www.paws-r-sdk.com/docs/proton_update_environment/) for full documentation.
#'
#' @param codebuildRoleArn The Amazon Resource Name (ARN) of the IAM service role that allows
#' Proton to provision infrastructure using CodeBuild-based provisioning on
#' your behalf.
#' @param componentRoleArn The Amazon Resource Name (ARN) of the IAM service role that Proton uses
#' when provisioning directly defined components in this environment. It
#' determines the scope of infrastructure that a component can provision.
#' 
#' The environment must have a `componentRoleArn` to allow directly defined
#' components to be associated with the environment.
#' 
#' For more information about components, see [Proton
#' components](https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
#' in the *Proton User Guide*.
#' @param deploymentType &#91;required&#93; There are four modes for updating an environment. The `deploymentType`
#' field defines the mode.
#' 
#' ****
#' 
#' `NONE`
#' 
#' In this mode, a deployment *doesn't* occur. Only the requested metadata
#' parameters are updated.
#' 
#' ****
#' 
#' `CURRENT_VERSION`
#' 
#' In this mode, the environment is deployed and updated with the new spec
#' that you provide. Only requested parameters are updated. *Don’t* include
#' major or minor version parameters when you use this `deployment-type`.
#' 
#' ****
#' 
#' `MINOR_VERSION`
#' 
#' In this mode, the environment is deployed and updated with the
#' published, recommended (latest) minor version of the current major
#' version in use, by default. You can also specify a different minor
#' version of the current major version in use.
#' 
#' ****
#' 
#' `MAJOR_VERSION`
#' 
#' In this mode, the environment is deployed and updated with the
#' published, recommended (latest) major and minor version of the current
#' template, by default. You can also specify a different major version
#' that is higher than the major version in use and a minor version
#' (optional).
#' @param description A description of the environment update.
#' @param environmentAccountConnectionId The ID of the environment account connection.
#' 
#' You can only update to a new environment account connection if it was
#' created in the same environment account that the current environment
#' account connection was created in and is associated with the current
#' environment.
#' @param name &#91;required&#93; The name of the environment to update.
#' @param protonServiceRoleArn The Amazon Resource Name (ARN) of the Proton service role that allows
#' Proton to make API calls to other services your behalf.
#' @param provisioningRepository The linked repository that you use to host your rendered infrastructure
#' templates for self-managed provisioning. A linked repository is a
#' repository that has been registered with Proton. For more information,
#' see [`create_repository`][proton_create_repository].
#' @param spec The formatted specification that defines the update.
#' @param templateMajorVersion The major version of the environment to update.
#' @param templateMinorVersion The minor version of the environment to update.
#'
#' @keywords internal
#'
#' @rdname proton_update_environment
proton_update_environment <- function(codebuildRoleArn = NULL, componentRoleArn = NULL, deploymentType, description = NULL, environmentAccountConnectionId = NULL, name, protonServiceRoleArn = NULL, provisioningRepository = NULL, spec = NULL, templateMajorVersion = NULL, templateMinorVersion = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_environment_input(codebuildRoleArn = codebuildRoleArn, componentRoleArn = componentRoleArn, deploymentType = deploymentType, description = description, environmentAccountConnectionId = environmentAccountConnectionId, name = name, protonServiceRoleArn = protonServiceRoleArn, provisioningRepository = provisioningRepository, spec = spec, templateMajorVersion = templateMajorVersion, templateMinorVersion = templateMinorVersion)
  output <- .proton$update_environment_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_environment <- proton_update_environment

#' In an environment account, update an environment account connection to
#' use a new IAM role
#'
#' @description
#' In an environment account, update an environment account connection to use a new IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_environment_account_connection/](https://www.paws-r-sdk.com/docs/proton_update_environment_account_connection/) for full documentation.
#'
#' @param codebuildRoleArn The Amazon Resource Name (ARN) of an IAM service role in the environment
#' account. Proton uses this role to provision infrastructure resources
#' using CodeBuild-based provisioning in the associated environment
#' account.
#' @param componentRoleArn The Amazon Resource Name (ARN) of the IAM service role that Proton uses
#' when provisioning directly defined components in the associated
#' environment account. It determines the scope of infrastructure that a
#' component can provision in the account.
#' 
#' The environment account connection must have a `componentRoleArn` to
#' allow directly defined components to be associated with any environments
#' running in the account.
#' 
#' For more information about components, see [Proton
#' components](https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
#' in the *Proton User Guide*.
#' @param id &#91;required&#93; The ID of the environment account connection to update.
#' @param roleArn The Amazon Resource Name (ARN) of the IAM service role that's associated
#' with the environment account connection to update.
#'
#' @keywords internal
#'
#' @rdname proton_update_environment_account_connection
proton_update_environment_account_connection <- function(codebuildRoleArn = NULL, componentRoleArn = NULL, id, roleArn = NULL) {
  op <- new_operation(
    name = "UpdateEnvironmentAccountConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_environment_account_connection_input(codebuildRoleArn = codebuildRoleArn, componentRoleArn = componentRoleArn, id = id, roleArn = roleArn)
  output <- .proton$update_environment_account_connection_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_environment_account_connection <- proton_update_environment_account_connection

#' Update an environment template
#'
#' @description
#' Update an environment template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_environment_template/](https://www.paws-r-sdk.com/docs/proton_update_environment_template/) for full documentation.
#'
#' @param description A description of the environment template update.
#' @param displayName The name of the environment template to update as displayed in the
#' developer interface.
#' @param name &#91;required&#93; The name of the environment template to update.
#'
#' @keywords internal
#'
#' @rdname proton_update_environment_template
proton_update_environment_template <- function(description = NULL, displayName = NULL, name) {
  op <- new_operation(
    name = "UpdateEnvironmentTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_environment_template_input(description = description, displayName = displayName, name = name)
  output <- .proton$update_environment_template_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_environment_template <- proton_update_environment_template

#' Update a major or minor version of an environment template
#'
#' @description
#' Update a major or minor version of an environment template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_environment_template_version/](https://www.paws-r-sdk.com/docs/proton_update_environment_template_version/) for full documentation.
#'
#' @param description A description of environment template version to update.
#' @param majorVersion &#91;required&#93; To update a major version of an environment template, include
#' `major Version`.
#' @param minorVersion &#91;required&#93; To update a minor version of an environment template, include
#' `minorVersion`.
#' @param status The status of the environment template minor version to update.
#' @param templateName &#91;required&#93; The name of the environment template.
#'
#' @keywords internal
#'
#' @rdname proton_update_environment_template_version
proton_update_environment_template_version <- function(description = NULL, majorVersion, minorVersion, status = NULL, templateName) {
  op <- new_operation(
    name = "UpdateEnvironmentTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_environment_template_version_input(description = description, majorVersion = majorVersion, minorVersion = minorVersion, status = status, templateName = templateName)
  output <- .proton$update_environment_template_version_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_environment_template_version <- proton_update_environment_template_version

#' Edit a service description or use a spec to add and delete service
#' instances
#'
#' @description
#' Edit a service description or use a spec to add and delete service instances.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_service/](https://www.paws-r-sdk.com/docs/proton_update_service/) for full documentation.
#'
#' @param description The edited service description.
#' @param name &#91;required&#93; The name of the service to edit.
#' @param spec Lists the service instances to add and the existing service instances to
#' remain. Omit the existing service instances to delete from the list.
#' *Don't* include edits to the existing service instances or pipeline. For
#' more information, see [Edit a
#' service](https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-update.html)
#' in the *Proton User Guide*.
#'
#' @keywords internal
#'
#' @rdname proton_update_service
proton_update_service <- function(description = NULL, name, spec = NULL) {
  op <- new_operation(
    name = "UpdateService",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_service_input(description = description, name = name, spec = spec)
  output <- .proton$update_service_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_service <- proton_update_service

#' Update a service instance
#'
#' @description
#' Update a service instance.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_service_instance/](https://www.paws-r-sdk.com/docs/proton_update_service_instance/) for full documentation.
#'
#' @param clientToken The client token of the service instance to update.
#' @param deploymentType &#91;required&#93; The deployment type. It defines the mode for updating a service
#' instance, as follows:
#' 
#' ****
#' 
#' `NONE`
#' 
#' In this mode, a deployment *doesn't* occur. Only the requested metadata
#' parameters are updated.
#' 
#' ****
#' 
#' `CURRENT_VERSION`
#' 
#' In this mode, the service instance is deployed and updated with the new
#' spec that you provide. Only requested parameters are updated. *Don’t*
#' include major or minor version parameters when you use this deployment
#' type.
#' 
#' ****
#' 
#' `MINOR_VERSION`
#' 
#' In this mode, the service instance is deployed and updated with the
#' published, recommended (latest) minor version of the current major
#' version in use, by default. You can also specify a different minor
#' version of the current major version in use.
#' 
#' ****
#' 
#' `MAJOR_VERSION`
#' 
#' In this mode, the service instance is deployed and updated with the
#' published, recommended (latest) major and minor version of the current
#' template, by default. You can specify a different major version that's
#' higher than the major version in use and a minor version.
#' @param name &#91;required&#93; The name of the service instance to update.
#' @param serviceName &#91;required&#93; The name of the service that the service instance belongs to.
#' @param spec The formatted specification that defines the service instance update.
#' @param templateMajorVersion The major version of the service template to update.
#' @param templateMinorVersion The minor version of the service template to update.
#'
#' @keywords internal
#'
#' @rdname proton_update_service_instance
proton_update_service_instance <- function(clientToken = NULL, deploymentType, name, serviceName, spec = NULL, templateMajorVersion = NULL, templateMinorVersion = NULL) {
  op <- new_operation(
    name = "UpdateServiceInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_service_instance_input(clientToken = clientToken, deploymentType = deploymentType, name = name, serviceName = serviceName, spec = spec, templateMajorVersion = templateMajorVersion, templateMinorVersion = templateMinorVersion)
  output <- .proton$update_service_instance_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_service_instance <- proton_update_service_instance

#' Update the service pipeline
#'
#' @description
#' Update the service pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_service_pipeline/](https://www.paws-r-sdk.com/docs/proton_update_service_pipeline/) for full documentation.
#'
#' @param deploymentType &#91;required&#93; The deployment type.
#' 
#' There are four modes for updating a service pipeline. The
#' `deploymentType` field defines the mode.
#' 
#' ****
#' 
#' `NONE`
#' 
#' In this mode, a deployment *doesn't* occur. Only the requested metadata
#' parameters are updated.
#' 
#' ****
#' 
#' `CURRENT_VERSION`
#' 
#' In this mode, the service pipeline is deployed and updated with the new
#' spec that you provide. Only requested parameters are updated. *Don’t*
#' include major or minor version parameters when you use this
#' `deployment-type`.
#' 
#' ****
#' 
#' `MINOR_VERSION`
#' 
#' In this mode, the service pipeline is deployed and updated with the
#' published, recommended (latest) minor version of the current major
#' version in use, by default. You can specify a different minor version of
#' the current major version in use.
#' 
#' ****
#' 
#' `MAJOR_VERSION`
#' 
#' In this mode, the service pipeline is deployed and updated with the
#' published, recommended (latest) major and minor version of the current
#' template, by default. You can specify a different major version that's
#' higher than the major version in use and a minor version.
#' @param serviceName &#91;required&#93; The name of the service to that the pipeline is associated with.
#' @param spec &#91;required&#93; The spec for the service pipeline to update.
#' @param templateMajorVersion The major version of the service template that was used to create the
#' service that the pipeline is associated with.
#' @param templateMinorVersion The minor version of the service template that was used to create the
#' service that the pipeline is associated with.
#'
#' @keywords internal
#'
#' @rdname proton_update_service_pipeline
proton_update_service_pipeline <- function(deploymentType, serviceName, spec, templateMajorVersion = NULL, templateMinorVersion = NULL) {
  op <- new_operation(
    name = "UpdateServicePipeline",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_service_pipeline_input(deploymentType = deploymentType, serviceName = serviceName, spec = spec, templateMajorVersion = templateMajorVersion, templateMinorVersion = templateMinorVersion)
  output <- .proton$update_service_pipeline_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_service_pipeline <- proton_update_service_pipeline

#' Update the service sync blocker by resolving it
#'
#' @description
#' Update the service sync blocker by resolving it.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_service_sync_blocker/](https://www.paws-r-sdk.com/docs/proton_update_service_sync_blocker/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the service sync blocker.
#' @param resolvedReason &#91;required&#93; The reason the service sync blocker was resolved.
#'
#' @keywords internal
#'
#' @rdname proton_update_service_sync_blocker
proton_update_service_sync_blocker <- function(id, resolvedReason) {
  op <- new_operation(
    name = "UpdateServiceSyncBlocker",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_service_sync_blocker_input(id = id, resolvedReason = resolvedReason)
  output <- .proton$update_service_sync_blocker_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_service_sync_blocker <- proton_update_service_sync_blocker

#' Update the Proton Ops config file
#'
#' @description
#' Update the Proton Ops config file.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_service_sync_config/](https://www.paws-r-sdk.com/docs/proton_update_service_sync_config/) for full documentation.
#'
#' @param branch &#91;required&#93; The name of the code repository branch where the Proton Ops file is
#' found.
#' @param filePath &#91;required&#93; The path to the Proton Ops file.
#' @param repositoryName &#91;required&#93; The name of the repository where the Proton Ops file is found.
#' @param repositoryProvider &#91;required&#93; The name of the repository provider where the Proton Ops file is found.
#' @param serviceName &#91;required&#93; The name of the service the Proton Ops file is for.
#'
#' @keywords internal
#'
#' @rdname proton_update_service_sync_config
proton_update_service_sync_config <- function(branch, filePath, repositoryName, repositoryProvider, serviceName) {
  op <- new_operation(
    name = "UpdateServiceSyncConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_service_sync_config_input(branch = branch, filePath = filePath, repositoryName = repositoryName, repositoryProvider = repositoryProvider, serviceName = serviceName)
  output <- .proton$update_service_sync_config_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_service_sync_config <- proton_update_service_sync_config

#' Update a service template
#'
#' @description
#' Update a service template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_service_template/](https://www.paws-r-sdk.com/docs/proton_update_service_template/) for full documentation.
#'
#' @param description A description of the service template update.
#' @param displayName The name of the service template to update that's displayed in the
#' developer interface.
#' @param name &#91;required&#93; The name of the service template to update.
#'
#' @keywords internal
#'
#' @rdname proton_update_service_template
proton_update_service_template <- function(description = NULL, displayName = NULL, name) {
  op <- new_operation(
    name = "UpdateServiceTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_service_template_input(description = description, displayName = displayName, name = name)
  output <- .proton$update_service_template_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_service_template <- proton_update_service_template

#' Update a major or minor version of a service template
#'
#' @description
#' Update a major or minor version of a service template.
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_service_template_version/](https://www.paws-r-sdk.com/docs/proton_update_service_template_version/) for full documentation.
#'
#' @param compatibleEnvironmentTemplates An array of environment template objects that are compatible with this
#' service template version. A service instance based on this service
#' template version can run in environments based on compatible templates.
#' @param description A description of a service template version to update.
#' @param majorVersion &#91;required&#93; To update a major version of a service template, include
#' `major Version`.
#' @param minorVersion &#91;required&#93; To update a minor version of a service template, include `minorVersion`.
#' @param status The status of the service template minor version to update.
#' @param supportedComponentSources An array of supported component sources. Components with supported
#' sources can be attached to service instances based on this service
#' template version.
#' 
#' A change to `supportedComponentSources` doesn't impact existing
#' component attachments to instances based on this template version. A
#' change only affects later associations.
#' 
#' For more information about components, see [Proton
#' components](https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
#' in the *Proton User Guide*.
#' @param templateName &#91;required&#93; The name of the service template.
#'
#' @keywords internal
#'
#' @rdname proton_update_service_template_version
proton_update_service_template_version <- function(compatibleEnvironmentTemplates = NULL, description = NULL, majorVersion, minorVersion, status = NULL, supportedComponentSources = NULL, templateName) {
  op <- new_operation(
    name = "UpdateServiceTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_service_template_version_input(compatibleEnvironmentTemplates = compatibleEnvironmentTemplates, description = description, majorVersion = majorVersion, minorVersion = minorVersion, status = status, supportedComponentSources = supportedComponentSources, templateName = templateName)
  output <- .proton$update_service_template_version_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_service_template_version <- proton_update_service_template_version

#' Update template sync configuration parameters, except for the
#' templateName and templateType
#'
#' @description
#' Update template sync configuration parameters, except for the `templateName` and `templateType`. Repository details (branch, name, and provider) should be of a linked repository. A linked repository is a repository that has been registered with Proton. For more information, see [`create_repository`][proton_create_repository].
#'
#' See [https://www.paws-r-sdk.com/docs/proton_update_template_sync_config/](https://www.paws-r-sdk.com/docs/proton_update_template_sync_config/) for full documentation.
#'
#' @param branch &#91;required&#93; The repository branch for your template.
#' @param repositoryName &#91;required&#93; The repository name (for example, `myrepos/myrepo`).
#' @param repositoryProvider &#91;required&#93; The repository provider.
#' @param subdirectory A subdirectory path to your template bundle version. When included,
#' limits the template bundle search to this repository directory.
#' @param templateName &#91;required&#93; The synced template name.
#' @param templateType &#91;required&#93; The synced template type.
#'
#' @keywords internal
#'
#' @rdname proton_update_template_sync_config
proton_update_template_sync_config <- function(branch, repositoryName, repositoryProvider, subdirectory = NULL, templateName, templateType) {
  op <- new_operation(
    name = "UpdateTemplateSyncConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .proton$update_template_sync_config_input(branch = branch, repositoryName = repositoryName, repositoryProvider = repositoryProvider, subdirectory = subdirectory, templateName = templateName, templateType = templateType)
  output <- .proton$update_template_sync_config_output()
  config <- get_config()
  svc <- .proton$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.proton$operations$update_template_sync_config <- proton_update_template_sync_config
