% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_request_environment_info}
\alias{elasticbeanstalk_request_environment_info}
\title{Initiates a request to compile the specified type of information of the
deployed environment}
\usage{
elasticbeanstalk_request_environment_info(
  EnvironmentId = NULL,
  EnvironmentName = NULL,
  InfoType
)
}
\arguments{
\item{EnvironmentId}{The ID of the environment of the requested data.

If no such environment is found,
\code{\link[=elasticbeanstalk_request_environment_info]{request_environment_info}}
returns an \code{InvalidParameterValue} error.

Condition: You must specify either this or an EnvironmentName, or both.
If you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{EnvironmentName}{The name of the environment of the requested data.

If no such environment is found,
\code{\link[=elasticbeanstalk_request_environment_info]{request_environment_info}}
returns an \code{InvalidParameterValue} error.

Condition: You must specify either this or an EnvironmentId, or both. If
you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{InfoType}{[required] The type of information to request.}
}
\description{
Initiates a request to compile the specified type of information of the deployed environment.

See \url{https://www.paws-r-sdk.com/docs/elasticbeanstalk_request_environment_info/} for full documentation.
}
\keyword{internal}
