% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_endpoint_connection_notifications}
\alias{ec2_describe_vpc_endpoint_connection_notifications}
\title{Describes the connection notifications for VPC endpoints and VPC
endpoint services}
\usage{
ec2_describe_vpc_endpoint_connection_notifications(
  DryRun = NULL,
  ConnectionNotificationId = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ConnectionNotificationId}{The ID of the notification.}

\item{Filters}{The filters.
\itemize{
\item \code{connection-notification-arn} - The ARN of the SNS topic for the
notification.
\item \code{connection-notification-id} - The ID of the notification.
\item \code{connection-notification-state} - The state of the notification
(\code{Enabled} | \code{Disabled}).
\item \code{connection-notification-type} - The type of notification (\code{Topic}).
\item \code{service-id} - The ID of the endpoint service.
\item \code{vpc-endpoint-id} - The ID of the VPC endpoint.
}}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another request with the returned
\code{NextToken} value.}

\item{NextToken}{The token to request the next page of results.}
}
\description{
Describes the connection notifications for VPC endpoints and VPC endpoint services.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_connection_notifications/} for full documentation.
}
\keyword{internal}
