# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include imagebuilder_service.R
NULL

#' CancelImageCreation cancels the creation of Image
#'
#' @description
#' CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_cancel_image_creation/](https://www.paws-r-sdk.com/docs/imagebuilder_cancel_image_creation/) for full documentation.
#'
#' @param imageBuildVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the image that you want to cancel
#' creation for.
#' @param clientToken &#91;required&#93; Unique, case-sensitive identifier you provide to ensure idempotency of
#' the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
#' in the *Amazon EC2 API Reference*.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_cancel_image_creation
imagebuilder_cancel_image_creation <- function(imageBuildVersionArn, clientToken) {
  op <- new_operation(
    name = "CancelImageCreation",
    http_method = "PUT",
    http_path = "/CancelImageCreation",
    paginator = list()
  )
  input <- .imagebuilder$cancel_image_creation_input(imageBuildVersionArn = imageBuildVersionArn, clientToken = clientToken)
  output <- .imagebuilder$cancel_image_creation_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$cancel_image_creation <- imagebuilder_cancel_image_creation

#' Creates a new component that can be used to build, validate, test, and
#' assess your image
#'
#' @description
#' Creates a new component that can be used to build, validate, test, and assess your image. The component is based on a YAML document that you specify using exactly one of the following methods:
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_create_component/](https://www.paws-r-sdk.com/docs/imagebuilder_create_component/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the component.
#' @param semanticVersion &#91;required&#93; The semantic version of the component. This version follows the semantic
#' version syntax.
#' 
#' The semantic version has four nodes:
#' \<major\>.\<minor\>.\<patch\>/\<build\>. You can assign values for the
#' first three, and can filter on all of them.
#' 
#' **Assignment:** For the first three nodes you can assign any positive
#' integer value, including zero, with an upper limit of 2^30-1, or
#' 1073741823 for each node. Image Builder automatically assigns the build
#' number to the fourth node.
#' 
#' **Patterns:** You can use any numeric pattern that adheres to the
#' assignment requirements for the nodes that you can assign. For example,
#' you might choose a software version pattern, such as 1.0.0, or a date,
#' such as 2021.01.01.
#' @param description Describes the contents of the component.
#' @param changeDescription The change description of the component. Describes what change has been
#' made in this version, or what makes this version different from other
#' versions of this component.
#' @param platform &#91;required&#93; The operating system platform of the component.
#' @param supportedOsVersions The operating system (OS) version supported by the component. If the OS
#' information is available, a prefix match is performed against the base
#' image OS version during image recipe creation.
#' @param data Component `data` contains inline YAML document content for the
#' component. Alternatively, you can specify the `uri` of a YAML document
#' file stored in Amazon S3. However, you cannot specify both properties.
#' @param uri The `uri` of a YAML component document file. This must be an S3 URL
#' (`s3://bucket/key`), and the requester must have permission to access
#' the S3 bucket it points to. If you use Amazon S3, you can specify
#' component content up to your service quota.
#' 
#' Alternatively, you can specify the YAML document inline, using the
#' component `data` property. You cannot specify both properties.
#' @param kmsKeyId The ID of the KMS key that is used to encrypt this component.
#' @param tags The tags that apply to the component.
#' @param clientToken &#91;required&#93; The idempotency token of the component.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_create_component
imagebuilder_create_component <- function(name, semanticVersion, description = NULL, changeDescription = NULL, platform, supportedOsVersions = NULL, data = NULL, uri = NULL, kmsKeyId = NULL, tags = NULL, clientToken) {
  op <- new_operation(
    name = "CreateComponent",
    http_method = "PUT",
    http_path = "/CreateComponent",
    paginator = list()
  )
  input <- .imagebuilder$create_component_input(name = name, semanticVersion = semanticVersion, description = description, changeDescription = changeDescription, platform = platform, supportedOsVersions = supportedOsVersions, data = data, uri = uri, kmsKeyId = kmsKeyId, tags = tags, clientToken = clientToken)
  output <- .imagebuilder$create_component_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$create_component <- imagebuilder_create_component

#' Creates a new container recipe
#'
#' @description
#' Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_create_container_recipe/](https://www.paws-r-sdk.com/docs/imagebuilder_create_container_recipe/) for full documentation.
#'
#' @param containerType &#91;required&#93; The type of container to create.
#' @param name &#91;required&#93; The name of the container recipe.
#' @param description The description of the container recipe.
#' @param semanticVersion &#91;required&#93; The semantic version of the container recipe. This version follows the
#' semantic version syntax.
#' 
#' The semantic version has four nodes:
#' \<major\>.\<minor\>.\<patch\>/\<build\>. You can assign values for the
#' first three, and can filter on all of them.
#' 
#' **Assignment:** For the first three nodes you can assign any positive
#' integer value, including zero, with an upper limit of 2^30-1, or
#' 1073741823 for each node. Image Builder automatically assigns the build
#' number to the fourth node.
#' 
#' **Patterns:** You can use any numeric pattern that adheres to the
#' assignment requirements for the nodes that you can assign. For example,
#' you might choose a software version pattern, such as 1.0.0, or a date,
#' such as 2021.01.01.
#' @param components &#91;required&#93; Components for build and test that are included in the container recipe.
#' Recipes require a minimum of one build component, and can have a maximum
#' of 20 build and test components in any combination.
#' @param instanceConfiguration A group of options that can be used to configure an instance for
#' building and testing container images.
#' @param dockerfileTemplateData The Dockerfile template used to build your image as an inline data blob.
#' @param dockerfileTemplateUri The Amazon S3 URI for the Dockerfile that will be used to build your
#' container image.
#' @param platformOverride Specifies the operating system platform when you use a custom base
#' image.
#' @param imageOsVersionOverride Specifies the operating system version for the base image.
#' @param parentImage &#91;required&#93; The base image for the container recipe.
#' @param tags Tags that are attached to the container recipe.
#' @param workingDirectory The working directory for use during build and test workflows.
#' @param targetRepository &#91;required&#93; The destination repository for the container image.
#' @param kmsKeyId Identifies which KMS key is used to encrypt the container image.
#' @param clientToken &#91;required&#93; The client token used to make this request idempotent.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_create_container_recipe
imagebuilder_create_container_recipe <- function(containerType, name, description = NULL, semanticVersion, components, instanceConfiguration = NULL, dockerfileTemplateData = NULL, dockerfileTemplateUri = NULL, platformOverride = NULL, imageOsVersionOverride = NULL, parentImage, tags = NULL, workingDirectory = NULL, targetRepository, kmsKeyId = NULL, clientToken) {
  op <- new_operation(
    name = "CreateContainerRecipe",
    http_method = "PUT",
    http_path = "/CreateContainerRecipe",
    paginator = list()
  )
  input <- .imagebuilder$create_container_recipe_input(containerType = containerType, name = name, description = description, semanticVersion = semanticVersion, components = components, instanceConfiguration = instanceConfiguration, dockerfileTemplateData = dockerfileTemplateData, dockerfileTemplateUri = dockerfileTemplateUri, platformOverride = platformOverride, imageOsVersionOverride = imageOsVersionOverride, parentImage = parentImage, tags = tags, workingDirectory = workingDirectory, targetRepository = targetRepository, kmsKeyId = kmsKeyId, clientToken = clientToken)
  output <- .imagebuilder$create_container_recipe_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$create_container_recipe <- imagebuilder_create_container_recipe

#' Creates a new distribution configuration
#'
#' @description
#' Creates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_create_distribution_configuration/](https://www.paws-r-sdk.com/docs/imagebuilder_create_distribution_configuration/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the distribution configuration.
#' @param description The description of the distribution configuration.
#' @param distributions &#91;required&#93; The distributions of the distribution configuration.
#' @param tags The tags of the distribution configuration.
#' @param clientToken &#91;required&#93; The idempotency token of the distribution configuration.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_create_distribution_configuration
imagebuilder_create_distribution_configuration <- function(name, description = NULL, distributions, tags = NULL, clientToken) {
  op <- new_operation(
    name = "CreateDistributionConfiguration",
    http_method = "PUT",
    http_path = "/CreateDistributionConfiguration",
    paginator = list()
  )
  input <- .imagebuilder$create_distribution_configuration_input(name = name, description = description, distributions = distributions, tags = tags, clientToken = clientToken)
  output <- .imagebuilder$create_distribution_configuration_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$create_distribution_configuration <- imagebuilder_create_distribution_configuration

#' Creates a new image
#'
#' @description
#' Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_create_image/](https://www.paws-r-sdk.com/docs/imagebuilder_create_image/) for full documentation.
#'
#' @param imageRecipeArn The Amazon Resource Name (ARN) of the image recipe that defines how
#' images are configured, tested, and assessed.
#' @param containerRecipeArn The Amazon Resource Name (ARN) of the container recipe that defines how
#' images are configured and tested.
#' @param distributionConfigurationArn The Amazon Resource Name (ARN) of the distribution configuration that
#' defines and configures the outputs of your pipeline.
#' @param infrastructureConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the infrastructure configuration that
#' defines the environment in which your image will be built and tested.
#' @param imageTestsConfiguration The image tests configuration of the image.
#' @param enhancedImageMetadataEnabled Collects additional information about the image being created, including
#' the operating system (OS) version and package list. This information is
#' used to enhance the overall experience of using EC2 Image Builder.
#' Enabled by default.
#' @param tags The tags of the image.
#' @param clientToken &#91;required&#93; The idempotency token used to make this request idempotent.
#' @param imageScanningConfiguration Contains settings for vulnerability scans.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_create_image
imagebuilder_create_image <- function(imageRecipeArn = NULL, containerRecipeArn = NULL, distributionConfigurationArn = NULL, infrastructureConfigurationArn, imageTestsConfiguration = NULL, enhancedImageMetadataEnabled = NULL, tags = NULL, clientToken, imageScanningConfiguration = NULL) {
  op <- new_operation(
    name = "CreateImage",
    http_method = "PUT",
    http_path = "/CreateImage",
    paginator = list()
  )
  input <- .imagebuilder$create_image_input(imageRecipeArn = imageRecipeArn, containerRecipeArn = containerRecipeArn, distributionConfigurationArn = distributionConfigurationArn, infrastructureConfigurationArn = infrastructureConfigurationArn, imageTestsConfiguration = imageTestsConfiguration, enhancedImageMetadataEnabled = enhancedImageMetadataEnabled, tags = tags, clientToken = clientToken, imageScanningConfiguration = imageScanningConfiguration)
  output <- .imagebuilder$create_image_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$create_image <- imagebuilder_create_image

#' Creates a new image pipeline
#'
#' @description
#' Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_create_image_pipeline/](https://www.paws-r-sdk.com/docs/imagebuilder_create_image_pipeline/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the image pipeline.
#' @param description The description of the image pipeline.
#' @param imageRecipeArn The Amazon Resource Name (ARN) of the image recipe that will be used to
#' configure images created by this image pipeline.
#' @param containerRecipeArn The Amazon Resource Name (ARN) of the container recipe that is used to
#' configure images created by this container pipeline.
#' @param infrastructureConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the infrastructure configuration that
#' will be used to build images created by this image pipeline.
#' @param distributionConfigurationArn The Amazon Resource Name (ARN) of the distribution configuration that
#' will be used to configure and distribute images created by this image
#' pipeline.
#' @param imageTestsConfiguration The image test configuration of the image pipeline.
#' @param enhancedImageMetadataEnabled Collects additional information about the image being created, including
#' the operating system (OS) version and package list. This information is
#' used to enhance the overall experience of using EC2 Image Builder.
#' Enabled by default.
#' @param schedule The schedule of the image pipeline.
#' @param status The status of the image pipeline.
#' @param tags The tags of the image pipeline.
#' @param clientToken &#91;required&#93; The idempotency token used to make this request idempotent.
#' @param imageScanningConfiguration Contains settings for vulnerability scans.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_create_image_pipeline
imagebuilder_create_image_pipeline <- function(name, description = NULL, imageRecipeArn = NULL, containerRecipeArn = NULL, infrastructureConfigurationArn, distributionConfigurationArn = NULL, imageTestsConfiguration = NULL, enhancedImageMetadataEnabled = NULL, schedule = NULL, status = NULL, tags = NULL, clientToken, imageScanningConfiguration = NULL) {
  op <- new_operation(
    name = "CreateImagePipeline",
    http_method = "PUT",
    http_path = "/CreateImagePipeline",
    paginator = list()
  )
  input <- .imagebuilder$create_image_pipeline_input(name = name, description = description, imageRecipeArn = imageRecipeArn, containerRecipeArn = containerRecipeArn, infrastructureConfigurationArn = infrastructureConfigurationArn, distributionConfigurationArn = distributionConfigurationArn, imageTestsConfiguration = imageTestsConfiguration, enhancedImageMetadataEnabled = enhancedImageMetadataEnabled, schedule = schedule, status = status, tags = tags, clientToken = clientToken, imageScanningConfiguration = imageScanningConfiguration)
  output <- .imagebuilder$create_image_pipeline_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$create_image_pipeline <- imagebuilder_create_image_pipeline

#' Creates a new image recipe
#'
#' @description
#' Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_create_image_recipe/](https://www.paws-r-sdk.com/docs/imagebuilder_create_image_recipe/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the image recipe.
#' @param description The description of the image recipe.
#' @param semanticVersion &#91;required&#93; The semantic version of the image recipe. This version follows the
#' semantic version syntax.
#' 
#' The semantic version has four nodes:
#' \<major\>.\<minor\>.\<patch\>/\<build\>. You can assign values for the
#' first three, and can filter on all of them.
#' 
#' **Assignment:** For the first three nodes you can assign any positive
#' integer value, including zero, with an upper limit of 2^30-1, or
#' 1073741823 for each node. Image Builder automatically assigns the build
#' number to the fourth node.
#' 
#' **Patterns:** You can use any numeric pattern that adheres to the
#' assignment requirements for the nodes that you can assign. For example,
#' you might choose a software version pattern, such as 1.0.0, or a date,
#' such as 2021.01.01.
#' @param components &#91;required&#93; The components included in the image recipe.
#' @param parentImage &#91;required&#93; The base image of the image recipe. The value of the string can be the
#' ARN of the base image or an AMI ID. The format for the ARN follows this
#' example:
#' `arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x`.
#' You can provide the specific version that you want to use, or you can
#' use a wildcard in all of the fields. If you enter an AMI ID for the
#' string value, you must have access to the AMI, and the AMI must be in
#' the same Region in which you are using Image Builder.
#' @param blockDeviceMappings The block device mappings of the image recipe.
#' @param tags The tags of the image recipe.
#' @param workingDirectory The working directory used during build and test workflows.
#' @param additionalInstanceConfiguration Specify additional settings and launch scripts for your build instances.
#' @param clientToken &#91;required&#93; The idempotency token used to make this request idempotent.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_create_image_recipe
imagebuilder_create_image_recipe <- function(name, description = NULL, semanticVersion, components, parentImage, blockDeviceMappings = NULL, tags = NULL, workingDirectory = NULL, additionalInstanceConfiguration = NULL, clientToken) {
  op <- new_operation(
    name = "CreateImageRecipe",
    http_method = "PUT",
    http_path = "/CreateImageRecipe",
    paginator = list()
  )
  input <- .imagebuilder$create_image_recipe_input(name = name, description = description, semanticVersion = semanticVersion, components = components, parentImage = parentImage, blockDeviceMappings = blockDeviceMappings, tags = tags, workingDirectory = workingDirectory, additionalInstanceConfiguration = additionalInstanceConfiguration, clientToken = clientToken)
  output <- .imagebuilder$create_image_recipe_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$create_image_recipe <- imagebuilder_create_image_recipe

#' Creates a new infrastructure configuration
#'
#' @description
#' Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_create_infrastructure_configuration/](https://www.paws-r-sdk.com/docs/imagebuilder_create_infrastructure_configuration/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the infrastructure configuration.
#' @param description The description of the infrastructure configuration.
#' @param instanceTypes The instance types of the infrastructure configuration. You can specify
#' one or more instance types to use for this build. The service will pick
#' one of these instance types based on availability.
#' @param instanceProfileName &#91;required&#93; The instance profile to associate with the instance used to customize
#' your Amazon EC2 AMI.
#' @param securityGroupIds The security group IDs to associate with the instance used to customize
#' your Amazon EC2 AMI.
#' @param subnetId The subnet ID in which to place the instance used to customize your
#' Amazon EC2 AMI.
#' @param logging The logging configuration of the infrastructure configuration.
#' @param keyPair The key pair of the infrastructure configuration. You can use this to
#' log on to and debug the instance used to create your image.
#' @param terminateInstanceOnFailure The terminate instance on failure setting of the infrastructure
#' configuration. Set to false if you want Image Builder to retain the
#' instance used to configure your AMI if the build or test phase of your
#' workflow fails.
#' @param snsTopicArn The Amazon Resource Name (ARN) for the SNS topic to which we send image
#' build event notifications.
#' 
#' EC2 Image Builder is unable to send notifications to SNS topics that are
#' encrypted using keys from other accounts. The key that is used to
#' encrypt the SNS topic must reside in the account that the Image Builder
#' service runs under.
#' @param resourceTags The tags attached to the resource created by Image Builder.
#' @param instanceMetadataOptions The instance metadata options that you can set for the HTTP requests
#' that pipeline builds use to launch EC2 build and test instances.
#' @param tags The tags of the infrastructure configuration.
#' @param clientToken &#91;required&#93; The idempotency token used to make this request idempotent.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_create_infrastructure_configuration
imagebuilder_create_infrastructure_configuration <- function(name, description = NULL, instanceTypes = NULL, instanceProfileName, securityGroupIds = NULL, subnetId = NULL, logging = NULL, keyPair = NULL, terminateInstanceOnFailure = NULL, snsTopicArn = NULL, resourceTags = NULL, instanceMetadataOptions = NULL, tags = NULL, clientToken) {
  op <- new_operation(
    name = "CreateInfrastructureConfiguration",
    http_method = "PUT",
    http_path = "/CreateInfrastructureConfiguration",
    paginator = list()
  )
  input <- .imagebuilder$create_infrastructure_configuration_input(name = name, description = description, instanceTypes = instanceTypes, instanceProfileName = instanceProfileName, securityGroupIds = securityGroupIds, subnetId = subnetId, logging = logging, keyPair = keyPair, terminateInstanceOnFailure = terminateInstanceOnFailure, snsTopicArn = snsTopicArn, resourceTags = resourceTags, instanceMetadataOptions = instanceMetadataOptions, tags = tags, clientToken = clientToken)
  output <- .imagebuilder$create_infrastructure_configuration_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$create_infrastructure_configuration <- imagebuilder_create_infrastructure_configuration

#' Deletes a component build version
#'
#' @description
#' Deletes a component build version.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_delete_component/](https://www.paws-r-sdk.com/docs/imagebuilder_delete_component/) for full documentation.
#'
#' @param componentBuildVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the component build version to delete.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_delete_component
imagebuilder_delete_component <- function(componentBuildVersionArn) {
  op <- new_operation(
    name = "DeleteComponent",
    http_method = "DELETE",
    http_path = "/DeleteComponent",
    paginator = list()
  )
  input <- .imagebuilder$delete_component_input(componentBuildVersionArn = componentBuildVersionArn)
  output <- .imagebuilder$delete_component_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$delete_component <- imagebuilder_delete_component

#' Deletes a container recipe
#'
#' @description
#' Deletes a container recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_delete_container_recipe/](https://www.paws-r-sdk.com/docs/imagebuilder_delete_container_recipe/) for full documentation.
#'
#' @param containerRecipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the container recipe to delete.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_delete_container_recipe
imagebuilder_delete_container_recipe <- function(containerRecipeArn) {
  op <- new_operation(
    name = "DeleteContainerRecipe",
    http_method = "DELETE",
    http_path = "/DeleteContainerRecipe",
    paginator = list()
  )
  input <- .imagebuilder$delete_container_recipe_input(containerRecipeArn = containerRecipeArn)
  output <- .imagebuilder$delete_container_recipe_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$delete_container_recipe <- imagebuilder_delete_container_recipe

#' Deletes a distribution configuration
#'
#' @description
#' Deletes a distribution configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_delete_distribution_configuration/](https://www.paws-r-sdk.com/docs/imagebuilder_delete_distribution_configuration/) for full documentation.
#'
#' @param distributionConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the distribution configuration to
#' delete.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_delete_distribution_configuration
imagebuilder_delete_distribution_configuration <- function(distributionConfigurationArn) {
  op <- new_operation(
    name = "DeleteDistributionConfiguration",
    http_method = "DELETE",
    http_path = "/DeleteDistributionConfiguration",
    paginator = list()
  )
  input <- .imagebuilder$delete_distribution_configuration_input(distributionConfigurationArn = distributionConfigurationArn)
  output <- .imagebuilder$delete_distribution_configuration_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$delete_distribution_configuration <- imagebuilder_delete_distribution_configuration

#' Deletes an Image Builder image resource
#'
#' @description
#' Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_delete_image/](https://www.paws-r-sdk.com/docs/imagebuilder_delete_image/) for full documentation.
#'
#' @param imageBuildVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the Image Builder image resource to
#' delete.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_delete_image
imagebuilder_delete_image <- function(imageBuildVersionArn) {
  op <- new_operation(
    name = "DeleteImage",
    http_method = "DELETE",
    http_path = "/DeleteImage",
    paginator = list()
  )
  input <- .imagebuilder$delete_image_input(imageBuildVersionArn = imageBuildVersionArn)
  output <- .imagebuilder$delete_image_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$delete_image <- imagebuilder_delete_image

#' Deletes an image pipeline
#'
#' @description
#' Deletes an image pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_delete_image_pipeline/](https://www.paws-r-sdk.com/docs/imagebuilder_delete_image_pipeline/) for full documentation.
#'
#' @param imagePipelineArn &#91;required&#93; The Amazon Resource Name (ARN) of the image pipeline to delete.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_delete_image_pipeline
imagebuilder_delete_image_pipeline <- function(imagePipelineArn) {
  op <- new_operation(
    name = "DeleteImagePipeline",
    http_method = "DELETE",
    http_path = "/DeleteImagePipeline",
    paginator = list()
  )
  input <- .imagebuilder$delete_image_pipeline_input(imagePipelineArn = imagePipelineArn)
  output <- .imagebuilder$delete_image_pipeline_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$delete_image_pipeline <- imagebuilder_delete_image_pipeline

#' Deletes an image recipe
#'
#' @description
#' Deletes an image recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_delete_image_recipe/](https://www.paws-r-sdk.com/docs/imagebuilder_delete_image_recipe/) for full documentation.
#'
#' @param imageRecipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the image recipe to delete.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_delete_image_recipe
imagebuilder_delete_image_recipe <- function(imageRecipeArn) {
  op <- new_operation(
    name = "DeleteImageRecipe",
    http_method = "DELETE",
    http_path = "/DeleteImageRecipe",
    paginator = list()
  )
  input <- .imagebuilder$delete_image_recipe_input(imageRecipeArn = imageRecipeArn)
  output <- .imagebuilder$delete_image_recipe_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$delete_image_recipe <- imagebuilder_delete_image_recipe

#' Deletes an infrastructure configuration
#'
#' @description
#' Deletes an infrastructure configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_delete_infrastructure_configuration/](https://www.paws-r-sdk.com/docs/imagebuilder_delete_infrastructure_configuration/) for full documentation.
#'
#' @param infrastructureConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the infrastructure configuration to
#' delete.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_delete_infrastructure_configuration
imagebuilder_delete_infrastructure_configuration <- function(infrastructureConfigurationArn) {
  op <- new_operation(
    name = "DeleteInfrastructureConfiguration",
    http_method = "DELETE",
    http_path = "/DeleteInfrastructureConfiguration",
    paginator = list()
  )
  input <- .imagebuilder$delete_infrastructure_configuration_input(infrastructureConfigurationArn = infrastructureConfigurationArn)
  output <- .imagebuilder$delete_infrastructure_configuration_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$delete_infrastructure_configuration <- imagebuilder_delete_infrastructure_configuration

#' Gets a component object
#'
#' @description
#' Gets a component object.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_component/](https://www.paws-r-sdk.com/docs/imagebuilder_get_component/) for full documentation.
#'
#' @param componentBuildVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the component that you want to get.
#' Regex requires the suffix `/\\d+$`.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_component
imagebuilder_get_component <- function(componentBuildVersionArn) {
  op <- new_operation(
    name = "GetComponent",
    http_method = "GET",
    http_path = "/GetComponent",
    paginator = list()
  )
  input <- .imagebuilder$get_component_input(componentBuildVersionArn = componentBuildVersionArn)
  output <- .imagebuilder$get_component_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_component <- imagebuilder_get_component

#' Gets a component policy
#'
#' @description
#' Gets a component policy.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_component_policy/](https://www.paws-r-sdk.com/docs/imagebuilder_get_component_policy/) for full documentation.
#'
#' @param componentArn &#91;required&#93; The Amazon Resource Name (ARN) of the component whose policy you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_component_policy
imagebuilder_get_component_policy <- function(componentArn) {
  op <- new_operation(
    name = "GetComponentPolicy",
    http_method = "GET",
    http_path = "/GetComponentPolicy",
    paginator = list()
  )
  input <- .imagebuilder$get_component_policy_input(componentArn = componentArn)
  output <- .imagebuilder$get_component_policy_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_component_policy <- imagebuilder_get_component_policy

#' Retrieves a container recipe
#'
#' @description
#' Retrieves a container recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_container_recipe/](https://www.paws-r-sdk.com/docs/imagebuilder_get_container_recipe/) for full documentation.
#'
#' @param containerRecipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the container recipe to retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_container_recipe
imagebuilder_get_container_recipe <- function(containerRecipeArn) {
  op <- new_operation(
    name = "GetContainerRecipe",
    http_method = "GET",
    http_path = "/GetContainerRecipe",
    paginator = list()
  )
  input <- .imagebuilder$get_container_recipe_input(containerRecipeArn = containerRecipeArn)
  output <- .imagebuilder$get_container_recipe_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_container_recipe <- imagebuilder_get_container_recipe

#' Retrieves the policy for a container recipe
#'
#' @description
#' Retrieves the policy for a container recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_container_recipe_policy/](https://www.paws-r-sdk.com/docs/imagebuilder_get_container_recipe_policy/) for full documentation.
#'
#' @param containerRecipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the container recipe for the policy
#' being requested.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_container_recipe_policy
imagebuilder_get_container_recipe_policy <- function(containerRecipeArn) {
  op <- new_operation(
    name = "GetContainerRecipePolicy",
    http_method = "GET",
    http_path = "/GetContainerRecipePolicy",
    paginator = list()
  )
  input <- .imagebuilder$get_container_recipe_policy_input(containerRecipeArn = containerRecipeArn)
  output <- .imagebuilder$get_container_recipe_policy_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_container_recipe_policy <- imagebuilder_get_container_recipe_policy

#' Gets a distribution configuration
#'
#' @description
#' Gets a distribution configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_distribution_configuration/](https://www.paws-r-sdk.com/docs/imagebuilder_get_distribution_configuration/) for full documentation.
#'
#' @param distributionConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the distribution configuration that
#' you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_distribution_configuration
imagebuilder_get_distribution_configuration <- function(distributionConfigurationArn) {
  op <- new_operation(
    name = "GetDistributionConfiguration",
    http_method = "GET",
    http_path = "/GetDistributionConfiguration",
    paginator = list()
  )
  input <- .imagebuilder$get_distribution_configuration_input(distributionConfigurationArn = distributionConfigurationArn)
  output <- .imagebuilder$get_distribution_configuration_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_distribution_configuration <- imagebuilder_get_distribution_configuration

#' Gets an image
#'
#' @description
#' Gets an image.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_image/](https://www.paws-r-sdk.com/docs/imagebuilder_get_image/) for full documentation.
#'
#' @param imageBuildVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the image that you want to get.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_image
imagebuilder_get_image <- function(imageBuildVersionArn) {
  op <- new_operation(
    name = "GetImage",
    http_method = "GET",
    http_path = "/GetImage",
    paginator = list()
  )
  input <- .imagebuilder$get_image_input(imageBuildVersionArn = imageBuildVersionArn)
  output <- .imagebuilder$get_image_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_image <- imagebuilder_get_image

#' Gets an image pipeline
#'
#' @description
#' Gets an image pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_image_pipeline/](https://www.paws-r-sdk.com/docs/imagebuilder_get_image_pipeline/) for full documentation.
#'
#' @param imagePipelineArn &#91;required&#93; The Amazon Resource Name (ARN) of the image pipeline that you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_image_pipeline
imagebuilder_get_image_pipeline <- function(imagePipelineArn) {
  op <- new_operation(
    name = "GetImagePipeline",
    http_method = "GET",
    http_path = "/GetImagePipeline",
    paginator = list()
  )
  input <- .imagebuilder$get_image_pipeline_input(imagePipelineArn = imagePipelineArn)
  output <- .imagebuilder$get_image_pipeline_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_image_pipeline <- imagebuilder_get_image_pipeline

#' Gets an image policy
#'
#' @description
#' Gets an image policy.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_image_policy/](https://www.paws-r-sdk.com/docs/imagebuilder_get_image_policy/) for full documentation.
#'
#' @param imageArn &#91;required&#93; The Amazon Resource Name (ARN) of the image whose policy you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_image_policy
imagebuilder_get_image_policy <- function(imageArn) {
  op <- new_operation(
    name = "GetImagePolicy",
    http_method = "GET",
    http_path = "/GetImagePolicy",
    paginator = list()
  )
  input <- .imagebuilder$get_image_policy_input(imageArn = imageArn)
  output <- .imagebuilder$get_image_policy_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_image_policy <- imagebuilder_get_image_policy

#' Gets an image recipe
#'
#' @description
#' Gets an image recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_image_recipe/](https://www.paws-r-sdk.com/docs/imagebuilder_get_image_recipe/) for full documentation.
#'
#' @param imageRecipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the image recipe that you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_image_recipe
imagebuilder_get_image_recipe <- function(imageRecipeArn) {
  op <- new_operation(
    name = "GetImageRecipe",
    http_method = "GET",
    http_path = "/GetImageRecipe",
    paginator = list()
  )
  input <- .imagebuilder$get_image_recipe_input(imageRecipeArn = imageRecipeArn)
  output <- .imagebuilder$get_image_recipe_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_image_recipe <- imagebuilder_get_image_recipe

#' Gets an image recipe policy
#'
#' @description
#' Gets an image recipe policy.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_image_recipe_policy/](https://www.paws-r-sdk.com/docs/imagebuilder_get_image_recipe_policy/) for full documentation.
#'
#' @param imageRecipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the image recipe whose policy you want
#' to retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_image_recipe_policy
imagebuilder_get_image_recipe_policy <- function(imageRecipeArn) {
  op <- new_operation(
    name = "GetImageRecipePolicy",
    http_method = "GET",
    http_path = "/GetImageRecipePolicy",
    paginator = list()
  )
  input <- .imagebuilder$get_image_recipe_policy_input(imageRecipeArn = imageRecipeArn)
  output <- .imagebuilder$get_image_recipe_policy_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_image_recipe_policy <- imagebuilder_get_image_recipe_policy

#' Gets an infrastructure configuration
#'
#' @description
#' Gets an infrastructure configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_infrastructure_configuration/](https://www.paws-r-sdk.com/docs/imagebuilder_get_infrastructure_configuration/) for full documentation.
#'
#' @param infrastructureConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the infrastructure configuration that
#' you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_infrastructure_configuration
imagebuilder_get_infrastructure_configuration <- function(infrastructureConfigurationArn) {
  op <- new_operation(
    name = "GetInfrastructureConfiguration",
    http_method = "GET",
    http_path = "/GetInfrastructureConfiguration",
    paginator = list()
  )
  input <- .imagebuilder$get_infrastructure_configuration_input(infrastructureConfigurationArn = infrastructureConfigurationArn)
  output <- .imagebuilder$get_infrastructure_configuration_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_infrastructure_configuration <- imagebuilder_get_infrastructure_configuration

#' Get the runtime information that was logged for a specific runtime
#' instance of the workflow
#'
#' @description
#' Get the runtime information that was logged for a specific runtime instance of the workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_workflow_execution/](https://www.paws-r-sdk.com/docs/imagebuilder_get_workflow_execution/) for full documentation.
#'
#' @param workflowExecutionId &#91;required&#93; Use the unique identifier for a runtime instance of the workflow to get
#' runtime details.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_workflow_execution
imagebuilder_get_workflow_execution <- function(workflowExecutionId) {
  op <- new_operation(
    name = "GetWorkflowExecution",
    http_method = "GET",
    http_path = "/GetWorkflowExecution",
    paginator = list()
  )
  input <- .imagebuilder$get_workflow_execution_input(workflowExecutionId = workflowExecutionId)
  output <- .imagebuilder$get_workflow_execution_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_workflow_execution <- imagebuilder_get_workflow_execution

#' Get the runtime information that was logged for a specific runtime
#' instance of the workflow step
#'
#' @description
#' Get the runtime information that was logged for a specific runtime instance of the workflow step.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_get_workflow_step_execution/](https://www.paws-r-sdk.com/docs/imagebuilder_get_workflow_step_execution/) for full documentation.
#'
#' @param stepExecutionId &#91;required&#93; Use the unique identifier for a specific runtime instance of the
#' workflow step to get runtime details for that step.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_get_workflow_step_execution
imagebuilder_get_workflow_step_execution <- function(stepExecutionId) {
  op <- new_operation(
    name = "GetWorkflowStepExecution",
    http_method = "GET",
    http_path = "/GetWorkflowStepExecution",
    paginator = list()
  )
  input <- .imagebuilder$get_workflow_step_execution_input(stepExecutionId = stepExecutionId)
  output <- .imagebuilder$get_workflow_step_execution_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$get_workflow_step_execution <- imagebuilder_get_workflow_step_execution

#' Imports a component and transforms its data into a component document
#'
#' @description
#' Imports a component and transforms its data into a component document.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_import_component/](https://www.paws-r-sdk.com/docs/imagebuilder_import_component/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the component.
#' @param semanticVersion &#91;required&#93; The semantic version of the component. This version follows the semantic
#' version syntax.
#' 
#' The semantic version has four nodes:
#' \<major\>.\<minor\>.\<patch\>/\<build\>. You can assign values for the
#' first three, and can filter on all of them.
#' 
#' **Filtering:** With semantic versioning, you have the flexibility to use
#' wildcards (x) to specify the most recent versions or nodes when
#' selecting the base image or components for your recipe. When you use a
#' wildcard in any node, all nodes to the right of the first wildcard must
#' also be wildcards.
#' @param description The description of the component. Describes the contents of the
#' component.
#' @param changeDescription The change description of the component. This description indicates the
#' change that has been made in this version, or what makes this version
#' different from other versions of this component.
#' @param type &#91;required&#93; The type of the component denotes whether the component is used to build
#' the image, or only to test it.
#' @param format &#91;required&#93; The format of the resource that you want to import as a component.
#' @param platform &#91;required&#93; The platform of the component.
#' @param data The data of the component. Used to specify the data inline. Either
#' `data` or `uri` can be used to specify the data within the component.
#' @param uri The uri of the component. Must be an Amazon S3 URL and the requester
#' must have permission to access the Amazon S3 bucket. If you use Amazon
#' S3, you can specify component content up to your service quota. Either
#' `data` or `uri` can be used to specify the data within the component.
#' @param kmsKeyId The ID of the KMS key that should be used to encrypt this component.
#' @param tags The tags of the component.
#' @param clientToken &#91;required&#93; The idempotency token of the component.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_import_component
imagebuilder_import_component <- function(name, semanticVersion, description = NULL, changeDescription = NULL, type, format, platform, data = NULL, uri = NULL, kmsKeyId = NULL, tags = NULL, clientToken) {
  op <- new_operation(
    name = "ImportComponent",
    http_method = "PUT",
    http_path = "/ImportComponent",
    paginator = list()
  )
  input <- .imagebuilder$import_component_input(name = name, semanticVersion = semanticVersion, description = description, changeDescription = changeDescription, type = type, format = format, platform = platform, data = data, uri = uri, kmsKeyId = kmsKeyId, tags = tags, clientToken = clientToken)
  output <- .imagebuilder$import_component_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$import_component <- imagebuilder_import_component

#' When you export your virtual machine (VM) from its virtualization
#' environment, that process creates a set of one or more disk container
#' files that act as snapshots of your VM’s environment, settings, and data
#'
#' @description
#' When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2 API [ImportImage](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html) action uses those files to import your VM and create an AMI. To import using the CLI command, see [import-image](https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html)
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_import_vm_image/](https://www.paws-r-sdk.com/docs/imagebuilder_import_vm_image/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the base image that is created by the import process.
#' @param semanticVersion &#91;required&#93; The semantic version to attach to the base image that was created during
#' the import process. This version follows the semantic version syntax.
#' 
#' The semantic version has four nodes:
#' \<major\>.\<minor\>.\<patch\>/\<build\>. You can assign values for the
#' first three, and can filter on all of them.
#' 
#' **Assignment:** For the first three nodes you can assign any positive
#' integer value, including zero, with an upper limit of 2^30-1, or
#' 1073741823 for each node. Image Builder automatically assigns the build
#' number to the fourth node.
#' 
#' **Patterns:** You can use any numeric pattern that adheres to the
#' assignment requirements for the nodes that you can assign. For example,
#' you might choose a software version pattern, such as 1.0.0, or a date,
#' such as 2021.01.01.
#' @param description The description for the base image that is created by the import
#' process.
#' @param platform &#91;required&#93; The operating system platform for the imported VM.
#' @param osVersion The operating system version for the imported VM.
#' @param vmImportTaskId &#91;required&#93; The `importTaskId` (API) or `ImportTaskId` (CLI) from the Amazon EC2 VM
#' import process. Image Builder retrieves information from the import
#' process to pull in the AMI that is created from the VM source as the
#' base image for your recipe.
#' @param tags Tags that are attached to the import resources.
#' @param clientToken &#91;required&#93; Unique, case-sensitive identifier you provide to ensure idempotency of
#' the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
#' in the *Amazon EC2 API Reference*.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_import_vm_image
imagebuilder_import_vm_image <- function(name, semanticVersion, description = NULL, platform, osVersion = NULL, vmImportTaskId, tags = NULL, clientToken) {
  op <- new_operation(
    name = "ImportVmImage",
    http_method = "PUT",
    http_path = "/ImportVmImage",
    paginator = list()
  )
  input <- .imagebuilder$import_vm_image_input(name = name, semanticVersion = semanticVersion, description = description, platform = platform, osVersion = osVersion, vmImportTaskId = vmImportTaskId, tags = tags, clientToken = clientToken)
  output <- .imagebuilder$import_vm_image_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$import_vm_image <- imagebuilder_import_vm_image

#' Returns the list of component build versions for the specified semantic
#' version
#'
#' @description
#' Returns the list of component build versions for the specified semantic version.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_component_build_versions/](https://www.paws-r-sdk.com/docs/imagebuilder_list_component_build_versions/) for full documentation.
#'
#' @param componentVersionArn &#91;required&#93; The component version Amazon Resource Name (ARN) whose versions you want
#' to list.
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_component_build_versions
imagebuilder_list_component_build_versions <- function(componentVersionArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListComponentBuildVersions",
    http_method = "POST",
    http_path = "/ListComponentBuildVersions",
    paginator = list()
  )
  input <- .imagebuilder$list_component_build_versions_input(componentVersionArn = componentVersionArn, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_component_build_versions_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_component_build_versions <- imagebuilder_list_component_build_versions

#' Returns the list of components that can be filtered by name, or by using
#' the listed filters to streamline results
#'
#' @description
#' Returns the list of components that can be filtered by name, or by using the listed `filters` to streamline results. Newly created components can take up to two minutes to appear in the ListComponents API Results.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_components/](https://www.paws-r-sdk.com/docs/imagebuilder_list_components/) for full documentation.
#'
#' @param owner Filters results based on the type of owner for the component. By
#' default, this request returns a list of components that your account
#' owns. To see results for other types of owners, you can specify
#' components that Amazon manages, third party components, or components
#' that other accounts have shared with you.
#' @param filters Use the following filters to streamline results:
#' 
#' -   `description`
#' 
#' -   `name`
#' 
#' -   `platform`
#' 
#' -   `supportedOsVersion`
#' 
#' -   `type`
#' 
#' -   `version`
#' @param byName Returns the list of components for the specified name.
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_components
imagebuilder_list_components <- function(owner = NULL, filters = NULL, byName = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListComponents",
    http_method = "POST",
    http_path = "/ListComponents",
    paginator = list()
  )
  input <- .imagebuilder$list_components_input(owner = owner, filters = filters, byName = byName, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_components_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_components <- imagebuilder_list_components

#' Returns a list of container recipes
#'
#' @description
#' Returns a list of container recipes.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_container_recipes/](https://www.paws-r-sdk.com/docs/imagebuilder_list_container_recipes/) for full documentation.
#'
#' @param owner Returns container recipes belonging to the specified owner, that have
#' been shared with you. You can omit this field to return container
#' recipes belonging to your account.
#' @param filters Use the following filters to streamline results:
#' 
#' -   `containerType`
#' 
#' -   `name`
#' 
#' -   `parentImage`
#' 
#' -   `platform`
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_container_recipes
imagebuilder_list_container_recipes <- function(owner = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListContainerRecipes",
    http_method = "POST",
    http_path = "/ListContainerRecipes",
    paginator = list()
  )
  input <- .imagebuilder$list_container_recipes_input(owner = owner, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_container_recipes_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_container_recipes <- imagebuilder_list_container_recipes

#' Returns a list of distribution configurations
#'
#' @description
#' Returns a list of distribution configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_distribution_configurations/](https://www.paws-r-sdk.com/docs/imagebuilder_list_distribution_configurations/) for full documentation.
#'
#' @param filters You can filter on `name` to streamline results.
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_distribution_configurations
imagebuilder_list_distribution_configurations <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDistributionConfigurations",
    http_method = "POST",
    http_path = "/ListDistributionConfigurations",
    paginator = list()
  )
  input <- .imagebuilder$list_distribution_configurations_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_distribution_configurations_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_distribution_configurations <- imagebuilder_list_distribution_configurations

#' Returns a list of image build versions
#'
#' @description
#' Returns a list of image build versions.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_image_build_versions/](https://www.paws-r-sdk.com/docs/imagebuilder_list_image_build_versions/) for full documentation.
#'
#' @param imageVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the image whose build versions you
#' want to retrieve.
#' @param filters Use the following filters to streamline results:
#' 
#' -   `name`
#' 
#' -   `osVersion`
#' 
#' -   `platform`
#' 
#' -   `type`
#' 
#' -   `version`
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_image_build_versions
imagebuilder_list_image_build_versions <- function(imageVersionArn, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListImageBuildVersions",
    http_method = "POST",
    http_path = "/ListImageBuildVersions",
    paginator = list()
  )
  input <- .imagebuilder$list_image_build_versions_input(imageVersionArn = imageVersionArn, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_image_build_versions_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_image_build_versions <- imagebuilder_list_image_build_versions

#' List the Packages that are associated with an Image Build Version, as
#' determined by Amazon Web Services Systems Manager Inventory at build
#' time
#'
#' @description
#' List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_image_packages/](https://www.paws-r-sdk.com/docs/imagebuilder_list_image_packages/) for full documentation.
#'
#' @param imageBuildVersionArn &#91;required&#93; Filter results for the ListImagePackages request by the Image Build
#' Version ARN
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_image_packages
imagebuilder_list_image_packages <- function(imageBuildVersionArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListImagePackages",
    http_method = "POST",
    http_path = "/ListImagePackages",
    paginator = list()
  )
  input <- .imagebuilder$list_image_packages_input(imageBuildVersionArn = imageBuildVersionArn, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_image_packages_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_image_packages <- imagebuilder_list_image_packages

#' Returns a list of images created by the specified pipeline
#'
#' @description
#' Returns a list of images created by the specified pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_image_pipeline_images/](https://www.paws-r-sdk.com/docs/imagebuilder_list_image_pipeline_images/) for full documentation.
#'
#' @param imagePipelineArn &#91;required&#93; The Amazon Resource Name (ARN) of the image pipeline whose images you
#' want to view.
#' @param filters Use the following filters to streamline results:
#' 
#' -   `name`
#' 
#' -   `version`
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_image_pipeline_images
imagebuilder_list_image_pipeline_images <- function(imagePipelineArn, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListImagePipelineImages",
    http_method = "POST",
    http_path = "/ListImagePipelineImages",
    paginator = list()
  )
  input <- .imagebuilder$list_image_pipeline_images_input(imagePipelineArn = imagePipelineArn, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_image_pipeline_images_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_image_pipeline_images <- imagebuilder_list_image_pipeline_images

#' Returns a list of image pipelines
#'
#' @description
#' Returns a list of image pipelines.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_image_pipelines/](https://www.paws-r-sdk.com/docs/imagebuilder_list_image_pipelines/) for full documentation.
#'
#' @param filters Use the following filters to streamline results:
#' 
#' -   `description`
#' 
#' -   `distributionConfigurationArn`
#' 
#' -   `imageRecipeArn`
#' 
#' -   `infrastructureConfigurationArn`
#' 
#' -   `name`
#' 
#' -   `status`
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_image_pipelines
imagebuilder_list_image_pipelines <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListImagePipelines",
    http_method = "POST",
    http_path = "/ListImagePipelines",
    paginator = list()
  )
  input <- .imagebuilder$list_image_pipelines_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_image_pipelines_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_image_pipelines <- imagebuilder_list_image_pipelines

#' Returns a list of image recipes
#'
#' @description
#' Returns a list of image recipes.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_image_recipes/](https://www.paws-r-sdk.com/docs/imagebuilder_list_image_recipes/) for full documentation.
#'
#' @param owner The owner defines which image recipes you want to list. By default, this
#' request will only show image recipes owned by your account. You can use
#' this field to specify if you want to view image recipes owned by
#' yourself, by Amazon, or those image recipes that have been shared with
#' you by other customers.
#' @param filters Use the following filters to streamline results:
#' 
#' -   `name`
#' 
#' -   `parentImage`
#' 
#' -   `platform`
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_image_recipes
imagebuilder_list_image_recipes <- function(owner = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListImageRecipes",
    http_method = "POST",
    http_path = "/ListImageRecipes",
    paginator = list()
  )
  input <- .imagebuilder$list_image_recipes_input(owner = owner, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_image_recipes_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_image_recipes <- imagebuilder_list_image_recipes

#' Returns a list of image scan aggregations for your account
#'
#' @description
#' Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder uses to group results. For example, if you want to get a list of findings by severity level for one of your pipelines, you might specify your pipeline with the `imagePipelineArn` filter. If you don't specify a filter, Image Builder returns an aggregation for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_image_scan_finding_aggregations/](https://www.paws-r-sdk.com/docs/imagebuilder_list_image_scan_finding_aggregations/) for full documentation.
#'
#' @param filter 
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_image_scan_finding_aggregations
imagebuilder_list_image_scan_finding_aggregations <- function(filter = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListImageScanFindingAggregations",
    http_method = "POST",
    http_path = "/ListImageScanFindingAggregations",
    paginator = list()
  )
  input <- .imagebuilder$list_image_scan_finding_aggregations_input(filter = filter, nextToken = nextToken)
  output <- .imagebuilder$list_image_scan_finding_aggregations_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_image_scan_finding_aggregations <- imagebuilder_list_image_scan_finding_aggregations

#' Returns a list of image scan findings for your account
#'
#' @description
#' Returns a list of image scan findings for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_image_scan_findings/](https://www.paws-r-sdk.com/docs/imagebuilder_list_image_scan_findings/) for full documentation.
#'
#' @param filters An array of name value pairs that you can use to filter your results.
#' You can use the following filters to streamline results:
#' 
#' -   `imageBuildVersionArn`
#' 
#' -   `imagePipelineArn`
#' 
#' -   `vulnerabilityId`
#' 
#' -   `severity`
#' 
#' If you don't request a filter, then all findings in your account are
#' listed.
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_image_scan_findings
imagebuilder_list_image_scan_findings <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListImageScanFindings",
    http_method = "POST",
    http_path = "/ListImageScanFindings",
    paginator = list()
  )
  input <- .imagebuilder$list_image_scan_findings_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_image_scan_findings_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_image_scan_findings <- imagebuilder_list_image_scan_findings

#' Returns the list of images that you have access to
#'
#' @description
#' Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in the ListImages API Results.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_images/](https://www.paws-r-sdk.com/docs/imagebuilder_list_images/) for full documentation.
#'
#' @param owner The owner defines which images you want to list. By default, this
#' request will only show images owned by your account. You can use this
#' field to specify if you want to view images owned by yourself, by
#' Amazon, or those images that have been shared with you by other
#' customers.
#' @param filters Use the following filters to streamline results:
#' 
#' -   `name`
#' 
#' -   `osVersion`
#' 
#' -   `platform`
#' 
#' -   `type`
#' 
#' -   `version`
#' @param byName Requests a list of images with a specific recipe name.
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#' @param includeDeprecated Includes deprecated images in the response list.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_images
imagebuilder_list_images <- function(owner = NULL, filters = NULL, byName = NULL, maxResults = NULL, nextToken = NULL, includeDeprecated = NULL) {
  op <- new_operation(
    name = "ListImages",
    http_method = "POST",
    http_path = "/ListImages",
    paginator = list()
  )
  input <- .imagebuilder$list_images_input(owner = owner, filters = filters, byName = byName, maxResults = maxResults, nextToken = nextToken, includeDeprecated = includeDeprecated)
  output <- .imagebuilder$list_images_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_images <- imagebuilder_list_images

#' Returns a list of infrastructure configurations
#'
#' @description
#' Returns a list of infrastructure configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_infrastructure_configurations/](https://www.paws-r-sdk.com/docs/imagebuilder_list_infrastructure_configurations/) for full documentation.
#'
#' @param filters You can filter on `name` to streamline results.
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_infrastructure_configurations
imagebuilder_list_infrastructure_configurations <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListInfrastructureConfigurations",
    http_method = "POST",
    http_path = "/ListInfrastructureConfigurations",
    paginator = list()
  )
  input <- .imagebuilder$list_infrastructure_configurations_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .imagebuilder$list_infrastructure_configurations_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_infrastructure_configurations <- imagebuilder_list_infrastructure_configurations

#' Returns the list of tags for the specified resource
#'
#' @description
#' Returns the list of tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/imagebuilder_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_tags_for_resource
imagebuilder_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .imagebuilder$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .imagebuilder$list_tags_for_resource_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_tags_for_resource <- imagebuilder_list_tags_for_resource

#' Returns a list of workflow runtime instance metadata objects for a
#' specific image build version
#'
#' @description
#' Returns a list of workflow runtime instance metadata objects for a specific image build version.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_workflow_executions/](https://www.paws-r-sdk.com/docs/imagebuilder_list_workflow_executions/) for full documentation.
#'
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#' @param imageBuildVersionArn &#91;required&#93; List all workflow runtime instances for the specified image build
#' version resource ARN.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_workflow_executions
imagebuilder_list_workflow_executions <- function(maxResults = NULL, nextToken = NULL, imageBuildVersionArn) {
  op <- new_operation(
    name = "ListWorkflowExecutions",
    http_method = "POST",
    http_path = "/ListWorkflowExecutions",
    paginator = list()
  )
  input <- .imagebuilder$list_workflow_executions_input(maxResults = maxResults, nextToken = nextToken, imageBuildVersionArn = imageBuildVersionArn)
  output <- .imagebuilder$list_workflow_executions_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_workflow_executions <- imagebuilder_list_workflow_executions

#' Shows runtime data for each step in a runtime instance of the workflow
#' that you specify in the request
#'
#' @description
#' Shows runtime data for each step in a runtime instance of the workflow that you specify in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_list_workflow_step_executions/](https://www.paws-r-sdk.com/docs/imagebuilder_list_workflow_step_executions/) for full documentation.
#'
#' @param maxResults The maximum items to return in a request.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#' @param workflowExecutionId &#91;required&#93; The unique identifier that Image Builder assigned to keep track of
#' runtime details when it ran the workflow.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_list_workflow_step_executions
imagebuilder_list_workflow_step_executions <- function(maxResults = NULL, nextToken = NULL, workflowExecutionId) {
  op <- new_operation(
    name = "ListWorkflowStepExecutions",
    http_method = "POST",
    http_path = "/ListWorkflowStepExecutions",
    paginator = list()
  )
  input <- .imagebuilder$list_workflow_step_executions_input(maxResults = maxResults, nextToken = nextToken, workflowExecutionId = workflowExecutionId)
  output <- .imagebuilder$list_workflow_step_executions_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$list_workflow_step_executions <- imagebuilder_list_workflow_step_executions

#' Applies a policy to a component
#'
#' @description
#' Applies a policy to a component. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API [`put_component_policy`][imagebuilder_put_component_policy], you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_put_component_policy/](https://www.paws-r-sdk.com/docs/imagebuilder_put_component_policy/) for full documentation.
#'
#' @param componentArn &#91;required&#93; The Amazon Resource Name (ARN) of the component that this policy should
#' be applied to.
#' @param policy &#91;required&#93; The policy to apply.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_put_component_policy
imagebuilder_put_component_policy <- function(componentArn, policy) {
  op <- new_operation(
    name = "PutComponentPolicy",
    http_method = "PUT",
    http_path = "/PutComponentPolicy",
    paginator = list()
  )
  input <- .imagebuilder$put_component_policy_input(componentArn = componentArn, policy = policy)
  output <- .imagebuilder$put_component_policy_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$put_component_policy <- imagebuilder_put_component_policy

#' Applies a policy to a container image
#'
#' @description
#' Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutContainerImagePolicy`, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_put_container_recipe_policy/](https://www.paws-r-sdk.com/docs/imagebuilder_put_container_recipe_policy/) for full documentation.
#'
#' @param containerRecipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the container recipe that this policy
#' should be applied to.
#' @param policy &#91;required&#93; The policy to apply to the container recipe.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_put_container_recipe_policy
imagebuilder_put_container_recipe_policy <- function(containerRecipeArn, policy) {
  op <- new_operation(
    name = "PutContainerRecipePolicy",
    http_method = "PUT",
    http_path = "/PutContainerRecipePolicy",
    paginator = list()
  )
  input <- .imagebuilder$put_container_recipe_policy_input(containerRecipeArn = containerRecipeArn, policy = policy)
  output <- .imagebuilder$put_container_recipe_policy_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$put_container_recipe_policy <- imagebuilder_put_container_recipe_policy

#' Applies a policy to an image
#'
#' @description
#' Applies a policy to an image. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API [`put_image_policy`][imagebuilder_put_image_policy], you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_put_image_policy/](https://www.paws-r-sdk.com/docs/imagebuilder_put_image_policy/) for full documentation.
#'
#' @param imageArn &#91;required&#93; The Amazon Resource Name (ARN) of the image that this policy should be
#' applied to.
#' @param policy &#91;required&#93; The policy to apply.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_put_image_policy
imagebuilder_put_image_policy <- function(imageArn, policy) {
  op <- new_operation(
    name = "PutImagePolicy",
    http_method = "PUT",
    http_path = "/PutImagePolicy",
    paginator = list()
  )
  input <- .imagebuilder$put_image_policy_input(imageArn = imageArn, policy = policy)
  output <- .imagebuilder$put_image_policy_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$put_image_policy <- imagebuilder_put_image_policy

#' Applies a policy to an image recipe
#'
#' @description
#' Applies a policy to an image recipe. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API [`put_image_recipe_policy`][imagebuilder_put_image_recipe_policy], you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_put_image_recipe_policy/](https://www.paws-r-sdk.com/docs/imagebuilder_put_image_recipe_policy/) for full documentation.
#'
#' @param imageRecipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the image recipe that this policy
#' should be applied to.
#' @param policy &#91;required&#93; The policy to apply.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_put_image_recipe_policy
imagebuilder_put_image_recipe_policy <- function(imageRecipeArn, policy) {
  op <- new_operation(
    name = "PutImageRecipePolicy",
    http_method = "PUT",
    http_path = "/PutImageRecipePolicy",
    paginator = list()
  )
  input <- .imagebuilder$put_image_recipe_policy_input(imageRecipeArn = imageRecipeArn, policy = policy)
  output <- .imagebuilder$put_image_recipe_policy_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$put_image_recipe_policy <- imagebuilder_put_image_recipe_policy

#' Manually triggers a pipeline to create an image
#'
#' @description
#' Manually triggers a pipeline to create an image.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_start_image_pipeline_execution/](https://www.paws-r-sdk.com/docs/imagebuilder_start_image_pipeline_execution/) for full documentation.
#'
#' @param imagePipelineArn &#91;required&#93; The Amazon Resource Name (ARN) of the image pipeline that you want to
#' manually invoke.
#' @param clientToken &#91;required&#93; The idempotency token used to make this request idempotent.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_start_image_pipeline_execution
imagebuilder_start_image_pipeline_execution <- function(imagePipelineArn, clientToken) {
  op <- new_operation(
    name = "StartImagePipelineExecution",
    http_method = "PUT",
    http_path = "/StartImagePipelineExecution",
    paginator = list()
  )
  input <- .imagebuilder$start_image_pipeline_execution_input(imagePipelineArn = imagePipelineArn, clientToken = clientToken)
  output <- .imagebuilder$start_image_pipeline_execution_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$start_image_pipeline_execution <- imagebuilder_start_image_pipeline_execution

#' Adds a tag to a resource
#'
#' @description
#' Adds a tag to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_tag_resource/](https://www.paws-r-sdk.com/docs/imagebuilder_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to tag.
#' @param tags &#91;required&#93; The tags to apply to the resource.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_tag_resource
imagebuilder_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .imagebuilder$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .imagebuilder$tag_resource_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$tag_resource <- imagebuilder_tag_resource

#' Removes a tag from a resource
#'
#' @description
#' Removes a tag from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_untag_resource/](https://www.paws-r-sdk.com/docs/imagebuilder_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to untag.
#' @param tagKeys &#91;required&#93; The tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_untag_resource
imagebuilder_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .imagebuilder$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .imagebuilder$untag_resource_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$untag_resource <- imagebuilder_untag_resource

#' Updates a new distribution configuration
#'
#' @description
#' Updates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_update_distribution_configuration/](https://www.paws-r-sdk.com/docs/imagebuilder_update_distribution_configuration/) for full documentation.
#'
#' @param distributionConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the distribution configuration that
#' you want to update.
#' @param description The description of the distribution configuration.
#' @param distributions &#91;required&#93; The distributions of the distribution configuration.
#' @param clientToken &#91;required&#93; The idempotency token of the distribution configuration.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_update_distribution_configuration
imagebuilder_update_distribution_configuration <- function(distributionConfigurationArn, description = NULL, distributions, clientToken) {
  op <- new_operation(
    name = "UpdateDistributionConfiguration",
    http_method = "PUT",
    http_path = "/UpdateDistributionConfiguration",
    paginator = list()
  )
  input <- .imagebuilder$update_distribution_configuration_input(distributionConfigurationArn = distributionConfigurationArn, description = description, distributions = distributions, clientToken = clientToken)
  output <- .imagebuilder$update_distribution_configuration_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$update_distribution_configuration <- imagebuilder_update_distribution_configuration

#' Updates an image pipeline
#'
#' @description
#' Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_update_image_pipeline/](https://www.paws-r-sdk.com/docs/imagebuilder_update_image_pipeline/) for full documentation.
#'
#' @param imagePipelineArn &#91;required&#93; The Amazon Resource Name (ARN) of the image pipeline that you want to
#' update.
#' @param description The description of the image pipeline.
#' @param imageRecipeArn The Amazon Resource Name (ARN) of the image recipe that will be used to
#' configure images updated by this image pipeline.
#' @param containerRecipeArn The Amazon Resource Name (ARN) of the container pipeline to update.
#' @param infrastructureConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the infrastructure configuration that
#' Image Builder uses to build images that this image pipeline has updated.
#' @param distributionConfigurationArn The Amazon Resource Name (ARN) of the distribution configuration that
#' Image Builder uses to configure and distribute images that this image
#' pipeline has updated.
#' @param imageTestsConfiguration The image test configuration of the image pipeline.
#' @param enhancedImageMetadataEnabled Collects additional information about the image being created, including
#' the operating system (OS) version and package list. This information is
#' used to enhance the overall experience of using EC2 Image Builder.
#' Enabled by default.
#' @param schedule The schedule of the image pipeline.
#' @param status The status of the image pipeline.
#' @param clientToken &#91;required&#93; The idempotency token used to make this request idempotent.
#' @param imageScanningConfiguration Contains settings for vulnerability scans.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_update_image_pipeline
imagebuilder_update_image_pipeline <- function(imagePipelineArn, description = NULL, imageRecipeArn = NULL, containerRecipeArn = NULL, infrastructureConfigurationArn, distributionConfigurationArn = NULL, imageTestsConfiguration = NULL, enhancedImageMetadataEnabled = NULL, schedule = NULL, status = NULL, clientToken, imageScanningConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateImagePipeline",
    http_method = "PUT",
    http_path = "/UpdateImagePipeline",
    paginator = list()
  )
  input <- .imagebuilder$update_image_pipeline_input(imagePipelineArn = imagePipelineArn, description = description, imageRecipeArn = imageRecipeArn, containerRecipeArn = containerRecipeArn, infrastructureConfigurationArn = infrastructureConfigurationArn, distributionConfigurationArn = distributionConfigurationArn, imageTestsConfiguration = imageTestsConfiguration, enhancedImageMetadataEnabled = enhancedImageMetadataEnabled, schedule = schedule, status = status, clientToken = clientToken, imageScanningConfiguration = imageScanningConfiguration)
  output <- .imagebuilder$update_image_pipeline_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$update_image_pipeline <- imagebuilder_update_image_pipeline

#' Updates a new infrastructure configuration
#'
#' @description
#' Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
#'
#' See [https://www.paws-r-sdk.com/docs/imagebuilder_update_infrastructure_configuration/](https://www.paws-r-sdk.com/docs/imagebuilder_update_infrastructure_configuration/) for full documentation.
#'
#' @param infrastructureConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the infrastructure configuration that
#' you want to update.
#' @param description The description of the infrastructure configuration.
#' @param instanceTypes The instance types of the infrastructure configuration. You can specify
#' one or more instance types to use for this build. The service will pick
#' one of these instance types based on availability.
#' @param instanceProfileName &#91;required&#93; The instance profile to associate with the instance used to customize
#' your Amazon EC2 AMI.
#' @param securityGroupIds The security group IDs to associate with the instance used to customize
#' your Amazon EC2 AMI.
#' @param subnetId The subnet ID to place the instance used to customize your Amazon EC2
#' AMI in.
#' @param logging The logging configuration of the infrastructure configuration.
#' @param keyPair The key pair of the infrastructure configuration. You can use this to
#' log on to and debug the instance used to create your image.
#' @param terminateInstanceOnFailure The terminate instance on failure setting of the infrastructure
#' configuration. Set to false if you want Image Builder to retain the
#' instance used to configure your AMI if the build or test phase of your
#' workflow fails.
#' @param snsTopicArn The Amazon Resource Name (ARN) for the SNS topic to which we send image
#' build event notifications.
#' 
#' EC2 Image Builder is unable to send notifications to SNS topics that are
#' encrypted using keys from other accounts. The key that is used to
#' encrypt the SNS topic must reside in the account that the Image Builder
#' service runs under.
#' @param clientToken &#91;required&#93; The idempotency token used to make this request idempotent.
#' @param resourceTags The tags attached to the resource created by Image Builder.
#' @param instanceMetadataOptions The instance metadata options that you can set for the HTTP requests
#' that pipeline builds use to launch EC2 build and test instances. For
#' more information about instance metadata options, see one of the
#' following links:
#' 
#' -   [Configure the instance metadata
#'     options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html)
#'     in the *Amazon EC2 User Guide* for Linux instances.
#' 
#' -   [Configure the instance metadata
#'     options](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html)
#'     in the *Amazon EC2 Windows Guide* for Windows instances.
#'
#' @keywords internal
#'
#' @rdname imagebuilder_update_infrastructure_configuration
imagebuilder_update_infrastructure_configuration <- function(infrastructureConfigurationArn, description = NULL, instanceTypes = NULL, instanceProfileName, securityGroupIds = NULL, subnetId = NULL, logging = NULL, keyPair = NULL, terminateInstanceOnFailure = NULL, snsTopicArn = NULL, clientToken, resourceTags = NULL, instanceMetadataOptions = NULL) {
  op <- new_operation(
    name = "UpdateInfrastructureConfiguration",
    http_method = "PUT",
    http_path = "/UpdateInfrastructureConfiguration",
    paginator = list()
  )
  input <- .imagebuilder$update_infrastructure_configuration_input(infrastructureConfigurationArn = infrastructureConfigurationArn, description = description, instanceTypes = instanceTypes, instanceProfileName = instanceProfileName, securityGroupIds = securityGroupIds, subnetId = subnetId, logging = logging, keyPair = keyPair, terminateInstanceOnFailure = terminateInstanceOnFailure, snsTopicArn = snsTopicArn, clientToken = clientToken, resourceTags = resourceTags, instanceMetadataOptions = instanceMetadataOptions)
  output <- .imagebuilder$update_infrastructure_configuration_output()
  config <- get_config()
  svc <- .imagebuilder$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.imagebuilder$operations$update_infrastructure_configuration <- imagebuilder_update_infrastructure_configuration
