% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_certificates}
\alias{lightsail_get_certificates}
\title{Returns information about one or more Amazon Lightsail SSL/TLS
certificates}
\usage{
lightsail_get_certificates(
  certificateStatuses = NULL,
  includeCertificateDetails = NULL,
  certificateName = NULL
)
}
\arguments{
\item{certificateStatuses}{The status of the certificates for which to return information.

For example, specify \code{ISSUED} to return only certificates with an
\code{ISSUED} status.

When omitted, the response includes all of your certificates in the
Amazon Web Services Region where the request is made, regardless of
their current status.}

\item{includeCertificateDetails}{Indicates whether to include detailed information about the certificates
in the response.

When omitted, the response includes only the certificate names, Amazon
Resource Names (ARNs), domain names, and tags.}

\item{certificateName}{The name for the certificate for which to return information.

When omitted, the response includes all of your certificates in the
Amazon Web Services Region where the request is made.}
}
\description{
Returns information about one or more Amazon Lightsail SSL/TLS certificates.

See \url{https://paws-r.github.io/docs/lightsail/get_certificates.html} for full documentation.
}
\keyword{internal}
