% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_transit_gateway_peering_attachments}
\alias{ec2_describe_transit_gateway_peering_attachments}
\title{Describes your transit gateway peering attachments}
\usage{
ec2_describe_transit_gateway_peering_attachments(
  TransitGatewayAttachmentIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{TransitGatewayAttachmentIds}{One or more IDs of the transit gateway peering attachments.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{transit-gateway-attachment-id} - The ID of the transit gateway
attachment.
\item \code{local-owner-id} - The ID of your Amazon Web Services account.
\item \code{remote-owner-id} - The ID of the Amazon Web Services account in the
remote Region that owns the transit gateway.
\item \code{state} - The state of the peering attachment. Valid values are
\code{available} | \code{deleted} | \code{deleting} | \code{failed} | \code{failing} |
\code{initiatingRequest} | \code{modifying} | \code{pendingAcceptance} | \code{pending}
| \code{rollingBack} | \code{rejected} | \code{rejecting}).
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources that have a tag with a specific key,
regardless of the tag value.
\item \code{transit-gateway-id} - The ID of the transit gateway.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes your transit gateway peering attachments.

See \url{https://paws-r.github.io/docs/ec2/describe_transit_gateway_peering_attachments.html} for full documentation.
}
\keyword{internal}
