% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc_endpoint_connection_notification}
\alias{ec2_create_vpc_endpoint_connection_notification}
\title{Creates a connection notification for a specified VPC endpoint or VPC
endpoint service}
\usage{
ec2_create_vpc_endpoint_connection_notification(
  DryRun = NULL,
  ServiceId = NULL,
  VpcEndpointId = NULL,
  ConnectionNotificationArn,
  ConnectionEvents,
  ClientToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ServiceId}{The ID of the endpoint service.}

\item{VpcEndpointId}{The ID of the endpoint.}

\item{ConnectionNotificationArn}{[required] The ARN of the SNS topic for the notifications.}

\item{ConnectionEvents}{[required] One or more endpoint events for which to receive notifications. Valid
values are \code{Accept}, \code{Connect}, \code{Delete}, and \code{Reject}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.}
}
\description{
Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more information, see \href{https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html}{Create a Topic} in the \emph{Amazon Simple Notification Service Developer Guide}.

See \url{https://paws-r.github.io/docs/ec2/create_vpc_endpoint_connection_notification.html} for full documentation.
}
\keyword{internal}
